/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.rcp.mainmenu.handlers;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MSnippetContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspectiveStack;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainer;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.registry.PerspectiveRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportPerspectiveHandler {
    private static final Logger Logger = LoggerFactory.getLogger(ImportPerspectiveHandler.class);

    @Execute
    public void execute(Shell shell, EModelService modelService, MApplication application) {
        MWindow window = (MWindow)modelService.find("org.eclipse.apogy.rcp.windows.main", (MUIElement)application);
        FileDialog dialog = new FileDialog(shell, 4096);
        dialog.setFilterExtensions(new String[]{"*.e4xmi"});
        String path = dialog.open();
        if (path != null) {
            File tmpFile = new File(path);
            URI uri = URI.createURI((String)tmpFile.toURI().toString());
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            Resource resource = resourceSet.getResource(uri, true);
            try {
                MPerspective perspective = (MPerspective)resource.getContents().get(0);
                MPerspectiveStack stack = (MPerspectiveStack)modelService.find("org.eclipse.apogy.rcp.perspectivesStack", (MUIElement)window);
                perspective.setLabel(String.valueOf(perspective.getLabel()) + "_import");
                perspective.setElementId(String.valueOf(perspective.getElementId()) + "_import");
                this.makeIDsUnique(perspective, stack);
                ArrayList partSashElementToAdd = new ArrayList();
                partSashElementToAdd.addAll(modelService.findElements((MUIElement)perspective, null, MPart.class, null));
                partSashElementToAdd.addAll(modelService.findElements((MUIElement)perspective, null, MPartSashContainer.class, null));
                partSashElementToAdd.addAll(modelService.findElements((MUIElement)perspective, null, MPartStack.class, null));
                for (MUIElement element : partSashElementToAdd) {
                    if (element instanceof MPart && element instanceof MPart && "bundleclass://org.eclipse.ui.workbench/org.eclipse.ui.internal.e4.compatibility.CompatibilityView".equals(((MPart)element).getContributionURI())) continue;
                    element.setElementId(String.valueOf(element.getElementId()) + "_" + perspective.getElementId());
                }
                ((PerspectiveRegistry)PlatformUI.getWorkbench().getPerspectiveRegistry()).addPerspective(perspective);
                application.getSnippets().add(modelService.cloneElement((MUIElement)perspective, (MSnippetContainer)application));
                stack.getChildren().add(perspective);
                stack.setSelectedElement((MUIElement)perspective);
            }
            catch (Exception e) {
                Logger.error("Error opening the .e4xmi, top element is not a perspective", (Throwable)e);
            }
        }
    }

    private void makeIDsUnique(MPerspective perspective, MPerspectiveStack stack) {
        int j = 1;
        int i = 0;
        while (i < stack.getChildren().size()) {
            MPerspective stackedPerspective;
            if (stack.getChildren().get(i) instanceof MPerspective && (stackedPerspective = (MPerspective)stack.getChildren().get(i)).getElementId() != null && stackedPerspective.getElementId().startsWith(String.valueOf(perspective.getElementId()) + "_" + Integer.toString(j))) {
                ++j;
                i = 0;
            }
            ++i;
        }
        perspective.setElementId(String.valueOf(perspective.getElementId()) + "_" + Integer.toString(j));
    }
}

