/*
 * Decompiled with CFR 0.152.
 */
package org.ros.internal.message.field;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import org.jboss.netty.buffer.ChannelBuffer;
import org.ros.internal.message.field.Field;
import org.ros.internal.message.field.FieldType;
import org.ros.internal.message.field.PrimitiveFieldType;

public class FloatArrayField
extends Field {
    private final int size;
    private float[] value;

    public static FloatArrayField newVariable(String name, int size) {
        return new FloatArrayField((FieldType)PrimitiveFieldType.FLOAT32, name, size);
    }

    private FloatArrayField(FieldType type, String name, int size) {
        super(type, name, false);
        this.size = size;
        this.setValue(new float[Math.max(0, size)]);
    }

    public float[] getValue() {
        return this.value;
    }

    @Override
    public void setValue(Object value) {
        Preconditions.checkArgument((this.size < 0 || ((float[])value).length == this.size ? 1 : 0) != 0);
        this.value = (float[])value;
    }

    @Override
    public void serialize(ChannelBuffer buffer) {
        if (this.size < 0) {
            buffer.writeInt(this.value.length);
        }
        float[] fArray = this.value;
        int n = this.value.length;
        int n2 = 0;
        while (n2 < n) {
            float v = fArray[n2];
            this.type.serialize(Float.valueOf(v), buffer);
            ++n2;
        }
    }

    @Override
    public void deserialize(ChannelBuffer buffer) {
        int currentSize = this.size;
        if (currentSize < 0) {
            currentSize = buffer.readInt();
        }
        this.value = new float[currentSize];
        int i = 0;
        while (i < currentSize) {
            this.value[i] = buffer.readFloat();
            ++i;
        }
    }

    @Override
    public String getMd5String() {
        return String.format("%s %s\n", this.type, this.name);
    }

    @Override
    public String getJavaTypeName() {
        return String.valueOf(this.type.getJavaTypeName()) + "[]";
    }

    public String toString() {
        return "FloatArrayField<" + this.type + ", " + this.name + ">";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FloatArrayField other = (FloatArrayField)obj;
        return !(this.value == null ? other.value != null : !Arrays.equals(this.value, other.value));
    }
}

