/*
 * Decompiled with CFR 0.152.
 */
package org.ros.internal.node.server;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.server.PropertyHandlerMapping;
import org.apache.xmlrpc.server.XmlRpcHandlerMapping;
import org.apache.xmlrpc.server.XmlRpcServerConfigImpl;
import org.apache.xmlrpc.server.XmlRpcStreamServer;
import org.apache.xmlrpc.webserver.WebServer;
import org.ros.address.AdvertiseAddress;
import org.ros.address.BindAddress;
import org.ros.exception.RosRuntimeException;
import org.ros.internal.node.server.NodeRequestProcessorFactoryFactory;
import org.ros.internal.node.xmlrpc.XmlRpcEndpoint;
import org.ros.internal.system.Process;

public class XmlRpcServer {
    private static final boolean DEBUG = false;
    private static final Log log = LogFactory.getLog(XmlRpcServer.class);
    private final WebServer server;
    private final AdvertiseAddress advertiseAddress;
    private final CountDownLatch startLatch;

    public XmlRpcServer(BindAddress bindAddress, AdvertiseAddress advertiseAddress) {
        InetSocketAddress address = bindAddress.toInetSocketAddress();
        this.server = new WebServer(address.getPort(), address.getAddress());
        this.advertiseAddress = advertiseAddress;
        this.advertiseAddress.setPortCallable(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return XmlRpcServer.this.server.getPort();
            }
        });
        this.startLatch = new CountDownLatch(1);
    }

    public <T extends XmlRpcEndpoint> void start(Class<T> instanceClass, T instance) {
        XmlRpcStreamServer xmlRpcServer = this.server.getXmlRpcServer();
        PropertyHandlerMapping phm = new PropertyHandlerMapping();
        phm.setRequestProcessorFactoryFactory(new NodeRequestProcessorFactoryFactory<T>(instance));
        try {
            phm.addHandler("", instanceClass);
        }
        catch (XmlRpcException e) {
            throw new RosRuntimeException(e);
        }
        xmlRpcServer.setHandlerMapping((XmlRpcHandlerMapping)phm);
        XmlRpcServerConfigImpl serverConfig = (XmlRpcServerConfigImpl)xmlRpcServer.getConfig();
        serverConfig.setEnabledForExtensions(false);
        serverConfig.setContentLengthOptional(false);
        try {
            this.server.start();
        }
        catch (IOException e) {
            throw new RosRuntimeException(e);
        }
        this.startLatch.countDown();
    }

    public void shutdown() {
        this.server.shutdown();
    }

    public URI getUri() {
        return this.advertiseAddress.toUri("http");
    }

    public InetSocketAddress getAddress() {
        return this.advertiseAddress.toInetSocketAddress();
    }

    public AdvertiseAddress getAdvertiseAddress() {
        return this.advertiseAddress;
    }

    public void awaitStart() throws InterruptedException {
        this.startLatch.await();
    }

    public boolean awaitStart(long timeout, TimeUnit unit) throws InterruptedException {
        return this.startLatch.await(timeout, unit);
    }

    public int getPid() {
        return Process.getPid();
    }
}

