/*
 * Decompiled with CFR 0.152.
 */
package org.ros.internal.node.service;

import com.google.common.base.Preconditions;
import java.net.URI;
import org.ros.internal.message.service.ServiceDescription;
import org.ros.internal.node.service.ServiceIdentifier;
import org.ros.internal.transport.ConnectionHeader;
import org.ros.namespace.GraphName;

public class ServiceDeclaration {
    private final ServiceIdentifier identifier;
    private final ServiceDescription description;

    public ServiceDeclaration(ServiceIdentifier identifier, ServiceDescription description) {
        Preconditions.checkNotNull((Object)identifier);
        Preconditions.checkNotNull((Object)description);
        this.identifier = identifier;
        this.description = description;
    }

    public ConnectionHeader toConnectionHeader() {
        ConnectionHeader connectionHeader = new ConnectionHeader();
        connectionHeader.addField("service", this.getName().toString());
        connectionHeader.addField("type", this.description.getType());
        connectionHeader.addField("message_definition", this.description.getDefinition());
        connectionHeader.addField("md5sum", this.description.getMd5Checksum());
        return connectionHeader;
    }

    public String getType() {
        return this.description.getType();
    }

    public String getDefinition() {
        return this.description.getDefinition();
    }

    public GraphName getName() {
        return this.identifier.getName();
    }

    public String toString() {
        return "ServiceDeclaration<" + this.getName().toString() + ", " + this.description.toString() + ">";
    }

    public String getMd5Checksum() {
        return this.description.getMd5Checksum();
    }

    public URI getUri() {
        return this.identifier.getUri();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.identifier == null ? 0 : this.identifier.hashCode());
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ServiceDeclaration other = (ServiceDeclaration)obj;
        if (this.identifier == null ? other.identifier != null : !this.identifier.equals(other.identifier)) {
            return false;
        }
        return !(this.description == null ? other.description != null : !this.description.equals((Object)other.description));
    }
}

