/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.vehicle.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.vecmath.Matrix4d;
import org.eclipse.apogy.addons.vehicle.ClosestNeighbourIteratorProvider;
import org.eclipse.apogy.addons.vehicle.MeshExtent2D;
import org.eclipse.apogy.addons.vehicle.WheelVehicleUtilities;
import org.eclipse.apogy.addons.vehicle.impl.ContactProviderImpl;
import org.eclipse.apogy.common.geometry.data3d.CartesianAxis;
import org.eclipse.apogy.common.geometry.data3d.CartesianPolygon;
import org.eclipse.apogy.common.geometry.data3d.CartesianPositionCoordinates;
import org.eclipse.apogy.common.geometry.data3d.CartesianTriangle;
import org.eclipse.apogy.common.geometry.data3d.CartesianTriangularMesh;
import org.eclipse.apogy.common.geometry.data3d.Geometry3DUtilities;
import org.eclipse.apogy.common.math.Matrix4x4;
import org.eclipse.apogy.common.topology.ApogyCommonTopologyFacade;
import org.eclipse.apogy.common.topology.Node;
import org.eclipse.apogy.common.topology.addons.dynamics.PhysicalBody;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.traverse.BreadthFirstIterator;

public abstract class ContactProviderCustomImpl
extends ContactProviderImpl {
    protected Map<CartesianTriangularMesh, Map<Integer, CartesianTriangle>> meshToWheelToLastTriangleMap = new HashMap<CartesianTriangularMesh, Map<Integer, CartesianTriangle>>();

    protected CartesianPositionCoordinates[] getProjectionAlongAxisOnToPolygon(CartesianAxis axis, List<CartesianPositionCoordinates> points, CartesianTriangularMesh mesh) {
        CartesianPositionCoordinates[] intersections = new CartesianPositionCoordinates[points.size()];
        ClosestNeighbourIteratorProvider closestNeighbourIteratorProvider = this.getVehiclePoseCorrector().getClosestNeighbourIteratorProvider(mesh);
        MeshExtent2D meshExtent2D = this.getVehiclePoseCorrector().getMeshExtent2D(mesh);
        Map<Integer, CartesianTriangle> wheelToLastTriangleMap = this.meshToWheelToLastTriangleMap.get(mesh);
        if (wheelToLastTriangleMap == null) {
            wheelToLastTriangleMap = new HashMap<Integer, CartesianTriangle>();
            this.meshToWheelToLastTriangleMap.put(mesh, wheelToLastTriangleMap);
        }
        int i = 0;
        while (i < points.size()) {
            CartesianPositionCoordinates point = points.get(i);
            Integer wheelIndex = new Integer(i);
            if (WheelVehicleUtilities.INSTANCE.isWithin(point.asPoint3d(), meshExtent2D)) {
                CartesianTriangle startTriangle = wheelToLastTriangleMap.get(wheelIndex);
                BreadthFirstIterator<CartesianTriangle, DefaultEdge> it = closestNeighbourIteratorProvider.createBreadthFirstIterator(startTriangle);
                CartesianPositionCoordinates projection = null;
                while (it.hasNext() && projection == null) {
                    CartesianPolygon polygon = (CartesianPolygon)it.next();
                    projection = Geometry3DUtilities.getProjectionAlongAxisOnToPolygon((CartesianAxis)CartesianAxis.Z, (CartesianPositionCoordinates)point, (CartesianPolygon)polygon);
                    if (projection == null) continue;
                    wheelToLastTriangleMap.put(wheelIndex, (CartesianTriangle)polygon);
                }
                intersections[i] = projection;
            }
            ++i;
        }
        return intersections;
    }

    protected Matrix4d getBodyToMeshTransform(Matrix4x4 originalPose, PhysicalBody body, Node node) {
        Matrix4d bodyToSystemTransform = this.getFootToSystemTransform(body);
        Matrix4d bodyToWorldTransform = new Matrix4d(originalPose.asMatrix4d());
        bodyToWorldTransform.mul(bodyToSystemTransform);
        Matrix4d meshToWorldTransform = ApogyCommonTopologyFacade.INSTANCE.expressNodeInRootFrame(node);
        meshToWorldTransform.invert();
        bodyToWorldTransform.mul(meshToWorldTransform);
        return bodyToWorldTransform;
    }

    protected Matrix4d getFootToSystemTransform(PhysicalBody body) {
        Node root = this.getVehiclePoseCorrector().getSystemRootNode();
        Matrix4d transform = ApogyCommonTopologyFacade.INSTANCE.expressInFrame((Node)body, root);
        return transform;
    }
}

