/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.geometry.data3d.impl;

import java.util.ArrayList;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import org.eclipse.apogy.common.geometry.data3d.CartesianPositionCoordinates;
import org.eclipse.apogy.common.geometry.data3d.CartesianTriangle;
import org.eclipse.apogy.common.geometry.data3d.CartesianTriangularMesh;
import org.eclipse.apogy.common.geometry.data3d.Geometry3DUtilities;
import org.eclipse.apogy.common.geometry.data3d.impl.MaximumEdgeLengthTriangularMeshFilterImpl;
import org.eclipse.core.runtime.IProgressMonitor;

public class MaximumEdgeLengthTriangularMeshFilterCustomImpl
extends MaximumEdgeLengthTriangularMeshFilterImpl {
    public CartesianTriangularMesh doProcess(CartesianTriangularMesh input, IProgressMonitor progressMonitor) throws Exception {
        Matrix4d identity = new Matrix4d();
        identity.setIdentity();
        CartesianTriangularMesh output = Geometry3DUtilities.createTransformedCartesianTriangularMesh(identity, input);
        ArrayList<CartesianTriangle> trianglesToRemove = new ArrayList<CartesianTriangle>();
        for (CartesianTriangle triangle : output.getPolygons()) {
            int i = 0;
            while (i < 2) {
                Point3d p1;
                Point3d p0 = ((CartesianPositionCoordinates)triangle.getVertices().get(i)).asPoint3d();
                double edgeLength = p0.distance(p1 = ((CartesianPositionCoordinates)triangle.getVertices().get(i + 1)).asPoint3d());
                if (edgeLength > this.getMaximumEdgeLength()) {
                    trianglesToRemove.add(triangle);
                }
                ++i;
            }
        }
        output.getPolygons().removeAll(trianglesToRemove);
        return output;
    }
}

