/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.images.converters;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.apogy.common.converters.FileExporterUtilities;
import org.eclipse.apogy.common.converters.IFileExporter;
import org.eclipse.apogy.common.images.AbstractEImage;
import org.eclipse.apogy.common.images.EImagesUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractImageToFileConverter
implements IFileExporter {
    private static final Logger Logger = LoggerFactory.getLogger(AbstractImageToFileConverter.class);
    public static final String JPEG_FILE_EXTENSION = "jpg";
    public static final String PNG_FILE_EXTENSION = "png";

    public Class<?> getOutputType() {
        return File.class;
    }

    public Class<?> getInputType() {
        return AbstractEImage.class;
    }

    public boolean canConvert(Object input) {
        if (input instanceof AbstractEImage) {
            boolean canConvert;
            boolean bl = canConvert = ((AbstractEImage)input).asBufferedImage() != null;
            return ((AbstractEImage)input).asBufferedImage() != null;
        }
        return false;
    }

    public Object convert(Object input) throws Exception {
        AbstractEImage eImage = (AbstractEImage)input;
        String tmpFolder = String.valueOf(System.getProperty("user.home")) + File.separator + System.getProperty("java.io.tmpdir");
        Date now = new Date();
        String fileName = null;
        try {
            fileName = String.valueOf(tmpFolder) + File.separator + now.getTime() + "." + JPEG_FILE_EXTENSION;
            System.out.println("fileName " + fileName);
            EImagesUtilities.INSTANCE.saveImageAsJPEG(fileName, eImage);
            return new File(fileName);
        }
        catch (Exception e) {
            File toDelete = new File(fileName);
            toDelete.delete();
            Logger.error("could not create temporary file <" + fileName + "> !", (Throwable)e);
            return null;
        }
    }

    public void exportToFile(Object input, String filePath, List<String> extensions) throws Exception {
        AbstractEImage eImage = (AbstractEImage)input;
        for (String extension : extensions) {
            String fullPathString = String.valueOf(filePath) + "." + extension;
            if (extension.equalsIgnoreCase(JPEG_FILE_EXTENSION)) {
                EImagesUtilities.INSTANCE.saveImageAsJPEG(fullPathString, eImage);
                continue;
            }
            if (extension.equalsIgnoreCase(PNG_FILE_EXTENSION)) {
                EImagesUtilities.INSTANCE.saveImageAsPNG(fullPathString, eImage);
                continue;
            }
            if (!extension.equalsIgnoreCase("metadata")) continue;
            FileExporterUtilities.saveMetaDataToFile((String)fullPathString, (String)AbstractImageToFileConverter.getMetaData(eImage));
        }
    }

    public List<String> getSupportedFileExtensions() {
        ArrayList<String> extensions = new ArrayList<String>();
        extensions.add(JPEG_FILE_EXTENSION);
        extensions.add(PNG_FILE_EXTENSION);
        extensions.add("metadata");
        return extensions;
    }

    public String getDescription(String fileExtension) {
        if (fileExtension.contains(JPEG_FILE_EXTENSION)) {
            return "Image file in JPEG format.";
        }
        if (fileExtension.contains(PNG_FILE_EXTENSION)) {
            return "Image file in PNG format.";
        }
        if (fileExtension.contains("metadata")) {
            return "The Image metadata.";
        }
        return null;
    }

    public static String getMetaData(AbstractEImage eImage) {
        String metadata = "";
        if (eImage != null) {
            metadata = String.valueOf(metadata) + "Image Width = " + eImage.getWidth() + "\n";
            metadata = String.valueOf(metadata) + "Image Height = " + eImage.getHeight() + "\n";
        }
        return metadata;
    }
}

