/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.topology.bindings.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.apogy.common.topology.GroupNode;
import org.eclipse.apogy.common.topology.Node;
import org.eclipse.apogy.common.topology.bindings.AbstractTopologyBinding;
import org.eclipse.apogy.common.topology.bindings.EnumerationCase;
import org.eclipse.apogy.common.topology.bindings.EnumerationSwitchBinding;
import org.eclipse.apogy.common.topology.bindings.impl.EnumerationSwitchBindingImpl;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnumerationSwitchBindingCustomImpl
extends EnumerationSwitchBindingImpl {
    private static final Logger Logger = LoggerFactory.getLogger(EnumerationSwitchBindingImpl.class);
    private final Map<EnumerationCase, Node> enumerationCaseToTopologyRootCopy = new HashMap<EnumerationCase, Node>();

    @Override
    protected synchronized void valueChanged(Object newValue) {
        try {
            Enumerator enumerator = (Enumerator)newValue;
            EnumerationCase newCase = this.getEnumerationCase(enumerator);
            if (newCase != this.getActiveCase()) {
                this.deActivateCase(this.getActiveCase());
                this.activateCase(newCase);
            }
        }
        catch (Throwable t) {
            Logger.error(t.getMessage(), t);
        }
    }

    @Override
    public AbstractTopologyBinding clone(Map<Node, Node> originalToCopyNodeMap) {
        EnumerationSwitchBinding enumerationSwitchBindingCopy = (EnumerationSwitchBinding)EcoreUtil.copy((EObject)this);
        enumerationSwitchBindingCopy.setParentNode((GroupNode)originalToCopyNodeMap.get(this.getParentNode()));
        return enumerationSwitchBindingCopy;
    }

    private void deActivateCase(EnumerationCase enumerationCase) {
        Node topologyRoot;
        if (enumerationCase != null && (topologyRoot = this.enumerationCaseToTopologyRootCopy.get(enumerationCase)) != null) {
            this.getParentNode().getChildren().remove((Object)topologyRoot);
        }
    }

    private void activateCase(EnumerationCase enumerationCase) {
        if (enumerationCase != null && enumerationCase.getTopologyRoot() != null) {
            Node topologyRoot = this.enumerationCaseToTopologyRootCopy.get(enumerationCase);
            if (topologyRoot == null) {
                topologyRoot = (Node)EcoreUtil.copy((EObject)enumerationCase.getTopologyRoot());
                this.enumerationCaseToTopologyRootCopy.put(enumerationCase, topologyRoot);
            }
            this.getParentNode().getChildren().add((Object)topologyRoot);
        }
        this.setActiveCase(enumerationCase);
    }

    private EnumerationCase getEnumerationCase(Enumerator enumerator) {
        EnumerationCase tmp;
        Iterator it;
        EnumerationCase enumerationCase = null;
        if (enumerator != null) {
            it = this.getCases().iterator();
            while (enumerationCase == null && it.hasNext()) {
                tmp = (EnumerationCase)it.next();
                for (EEnumLiteral literal : tmp.getEnumerationLiterals()) {
                    if (literal.getValue() != enumerator.getValue()) continue;
                    enumerationCase = tmp;
                }
            }
        }
        it = this.getCases().iterator();
        while (enumerationCase == null && it.hasNext()) {
            tmp = (EnumerationCase)it.next();
            if (!tmp.getEnumerationLiterals().isEmpty()) continue;
            enumerationCase = tmp;
        }
        return enumerationCase;
    }

    @Override
    public Class<?> getSupportedFeatureType() {
        return Enumerator.class;
    }

    @Override
    public void unbind() {
        try {
            this.deActivateCase(this.getActiveCase());
            this.enumerationCaseToTopologyRootCopy.clear();
        }
        catch (Throwable t) {
            Logger.error(t.getMessage(), t);
        }
        super.unbind();
    }
}

