/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.earth.surface.impl;

import javax.vecmath.Point3d;
import org.eclipse.apogy.common.emf.ApogyCommonEMFPackage;
import org.eclipse.apogy.common.geometry.data.ApogyCommonGeometryDataPackage;
import org.eclipse.apogy.common.geometry.data3d.ApogyCommonGeometryData3DPackage;
import org.eclipse.apogy.common.images.ApogyCommonImagesPackage;
import org.eclipse.apogy.common.math.ApogyCommonMathPackage;
import org.eclipse.apogy.common.processors.ApogyCommonProcessorsPackage;
import org.eclipse.apogy.common.topology.ApogyCommonTopologyPackage;
import org.eclipse.apogy.common.topology.bindings.ApogyCommonTopologyBindingsPackage;
import org.eclipse.apogy.core.ApogyCorePackage;
import org.eclipse.apogy.core.environment.ApogyCoreEnvironmentPackage;
import org.eclipse.apogy.core.environment.earth.ApogyCoreEnvironmentEarthPackage;
import org.eclipse.apogy.core.environment.earth.surface.ApogyEarthSurfaceEnvironmentFacade;
import org.eclipse.apogy.core.environment.earth.surface.ApogyEarthSurfaceEnvironmentFactory;
import org.eclipse.apogy.core.environment.earth.surface.ApogyEarthSurfaceEnvironmentPackage;
import org.eclipse.apogy.core.environment.earth.surface.AstronomyUtils;
import org.eclipse.apogy.core.environment.earth.surface.AtmosphereUtils;
import org.eclipse.apogy.core.environment.earth.surface.EarthSky;
import org.eclipse.apogy.core.environment.earth.surface.EarthSkyNode;
import org.eclipse.apogy.core.environment.earth.surface.EarthSurfaceWorksite;
import org.eclipse.apogy.core.environment.earth.surface.EarthSurfaceWorksiteNode;
import org.eclipse.apogy.core.environment.surface.ApogySurfaceEnvironmentPackage;
import org.eclipse.apogy.core.invocator.ApogyCoreInvocatorPackage;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.impl.EPackageImpl;

public class ApogyEarthSurfaceEnvironmentPackageImpl
extends EPackageImpl
implements ApogyEarthSurfaceEnvironmentPackage {
    private EClass earthSurfaceWorksiteEClass = null;
    private EClass earthSkyEClass = null;
    private EClass earthSurfaceWorksiteNodeEClass = null;
    private EClass earthSkyNodeEClass = null;
    private EClass apogyEarthSurfaceEnvironmentFacadeEClass = null;
    private EClass atmosphereUtilsEClass = null;
    private EClass astronomyUtilsEClass = null;
    private EDataType point3dEDataType = null;
    private static boolean isInited = false;
    private boolean isCreated = false;
    private boolean isInitialized = false;

    private ApogyEarthSurfaceEnvironmentPackageImpl() {
        super("org.eclipse.apogy.core.environment.earth.surface", (EFactory)ApogyEarthSurfaceEnvironmentFactory.eINSTANCE);
    }

    public static ApogyEarthSurfaceEnvironmentPackage init() {
        if (isInited) {
            return (ApogyEarthSurfaceEnvironmentPackage)EPackage.Registry.INSTANCE.getEPackage("org.eclipse.apogy.core.environment.earth.surface");
        }
        Object registeredApogyEarthSurfaceEnvironmentPackage = EPackage.Registry.INSTANCE.get((Object)"org.eclipse.apogy.core.environment.earth.surface");
        ApogyEarthSurfaceEnvironmentPackageImpl theApogyEarthSurfaceEnvironmentPackage = registeredApogyEarthSurfaceEnvironmentPackage instanceof ApogyEarthSurfaceEnvironmentPackageImpl ? (ApogyEarthSurfaceEnvironmentPackageImpl)registeredApogyEarthSurfaceEnvironmentPackage : new ApogyEarthSurfaceEnvironmentPackageImpl();
        isInited = true;
        ApogyCoreEnvironmentEarthPackage.eINSTANCE.eClass();
        ApogySurfaceEnvironmentPackage.eINSTANCE.eClass();
        EcorePackage.eINSTANCE.eClass();
        ApogyCommonEMFPackage.eINSTANCE.eClass();
        ApogyCoreEnvironmentPackage.eINSTANCE.eClass();
        ApogyCommonMathPackage.eINSTANCE.eClass();
        ApogyCommonTopologyPackage.eINSTANCE.eClass();
        ApogyCoreInvocatorPackage.eINSTANCE.eClass();
        ApogyCorePackage.eINSTANCE.eClass();
        ApogyCommonImagesPackage.eINSTANCE.eClass();
        ApogyCommonGeometryData3DPackage.eINSTANCE.eClass();
        ApogyCommonTopologyBindingsPackage.eINSTANCE.eClass();
        ApogyCommonGeometryDataPackage.eINSTANCE.eClass();
        ApogyCommonProcessorsPackage.eINSTANCE.eClass();
        theApogyEarthSurfaceEnvironmentPackage.createPackageContents();
        theApogyEarthSurfaceEnvironmentPackage.initializePackageContents();
        theApogyEarthSurfaceEnvironmentPackage.freeze();
        EPackage.Registry.INSTANCE.put((Object)"org.eclipse.apogy.core.environment.earth.surface", (Object)theApogyEarthSurfaceEnvironmentPackage);
        return theApogyEarthSurfaceEnvironmentPackage;
    }

    @Override
    public EClass getEarthSurfaceWorksite() {
        return this.earthSurfaceWorksiteEClass;
    }

    @Override
    public EAttribute getEarthSurfaceWorksite_XAxisAzimuth() {
        return (EAttribute)this.earthSurfaceWorksiteEClass.getEStructuralFeatures().get(0);
    }

    @Override
    public EReference getEarthSurfaceWorksite_EarthSky() {
        return (EReference)this.earthSurfaceWorksiteEClass.getEStructuralFeatures().get(1);
    }

    @Override
    public EOperation getEarthSurfaceWorksite__ConvertToGeographicCoordinates__Tuple3d() {
        return (EOperation)this.earthSurfaceWorksiteEClass.getEOperations().get(0);
    }

    @Override
    public EOperation getEarthSurfaceWorksite__ConvertToXYZPosition__GeographicCoordinates() {
        return (EOperation)this.earthSurfaceWorksiteEClass.getEOperations().get(1);
    }

    @Override
    public EClass getEarthSky() {
        return this.earthSkyEClass;
    }

    @Override
    public EReference getEarthSky_SunHorizontalCoordinates() {
        return (EReference)this.earthSkyEClass.getEStructuralFeatures().get(0);
    }

    @Override
    public EReference getEarthSky_Moon() {
        return (EReference)this.earthSkyEClass.getEStructuralFeatures().get(1);
    }

    @Override
    public EReference getEarthSky_MoonHorizontalCoordinates() {
        return (EReference)this.earthSkyEClass.getEStructuralFeatures().get(2);
    }

    @Override
    public EOperation getEarthSky__GetMoonAngularDiameter() {
        return (EOperation)this.earthSkyEClass.getEOperations().get(0);
    }

    @Override
    public EClass getEarthSurfaceWorksiteNode() {
        return this.earthSurfaceWorksiteNodeEClass;
    }

    @Override
    public EReference getEarthSurfaceWorksiteNode_SkyTransformNode() {
        return (EReference)this.earthSurfaceWorksiteNodeEClass.getEStructuralFeatures().get(0);
    }

    @Override
    public EClass getEarthSkyNode() {
        return this.earthSkyNodeEClass;
    }

    @Override
    public EClass getApogyEarthSurfaceEnvironmentFacade() {
        return this.apogyEarthSurfaceEnvironmentFacadeEClass;
    }

    @Override
    public EReference getApogyEarthSurfaceEnvironmentFacade_ActiveEarthSurfaceWorksite() {
        return (EReference)this.apogyEarthSurfaceEnvironmentFacadeEClass.getEStructuralFeatures().get(0);
    }

    @Override
    public EReference getApogyEarthSurfaceEnvironmentFacade_ActiveMoon() {
        return (EReference)this.apogyEarthSurfaceEnvironmentFacadeEClass.getEStructuralFeatures().get(1);
    }

    @Override
    public EOperation getApogyEarthSurfaceEnvironmentFacade__CreateEarthSky__GeographicCoordinates() {
        return (EOperation)this.apogyEarthSurfaceEnvironmentFacadeEClass.getEOperations().get(0);
    }

    @Override
    public EOperation getApogyEarthSurfaceEnvironmentFacade__CreateEarthSkyNode__GeographicCoordinates() {
        return (EOperation)this.apogyEarthSurfaceEnvironmentFacadeEClass.getEOperations().get(1);
    }

    @Override
    public EOperation getApogyEarthSurfaceEnvironmentFacade__CreateAndInitializeDefaultCSAWorksite() {
        return (EOperation)this.apogyEarthSurfaceEnvironmentFacadeEClass.getEOperations().get(2);
    }

    @Override
    public EOperation getApogyEarthSurfaceEnvironmentFacade__CreateEmptyEarthSurfaceWorksite() {
        return (EOperation)this.apogyEarthSurfaceEnvironmentFacadeEClass.getEOperations().get(3);
    }

    @Override
    public EOperation getApogyEarthSurfaceEnvironmentFacade__GetMarsYardGeographicalCoordinates() {
        return (EOperation)this.apogyEarthSurfaceEnvironmentFacadeEClass.getEOperations().get(4);
    }

    @Override
    public EOperation getApogyEarthSurfaceEnvironmentFacade__GetMarsYardTransformNode() {
        return (EOperation)this.apogyEarthSurfaceEnvironmentFacadeEClass.getEOperations().get(5);
    }

    @Override
    public EOperation getApogyEarthSurfaceEnvironmentFacade__CreateApogySession() {
        return (EOperation)this.apogyEarthSurfaceEnvironmentFacadeEClass.getEOperations().get(6);
    }

    @Override
    public EClass getAtmosphereUtils() {
        return this.atmosphereUtilsEClass;
    }

    @Override
    public EOperation getAtmosphereUtils__GetAirMass__double() {
        return (EOperation)this.atmosphereUtilsEClass.getEOperations().get(0);
    }

    @Override
    public EOperation getAtmosphereUtils__GetDirectSunIntensity__double_double() {
        return (EOperation)this.atmosphereUtilsEClass.getEOperations().get(1);
    }

    @Override
    public EOperation getAtmosphereUtils__GetDiffuseSunIntensity__double_double() {
        return (EOperation)this.atmosphereUtilsEClass.getEOperations().get(2);
    }

    @Override
    public EOperation getAtmosphereUtils__GetAtmosphereRefractionCorrection__double() {
        return (EOperation)this.atmosphereUtilsEClass.getEOperations().get(3);
    }

    @Override
    public EClass getAstronomyUtils() {
        return this.astronomyUtilsEClass;
    }

    @Override
    public EOperation getAstronomyUtils__GetSunEquatorialPosition__double() {
        return (EOperation)this.astronomyUtilsEClass.getEOperations().get(0);
    }

    @Override
    public EOperation getAstronomyUtils__GetHorizontalSunPosition__Date_double_double() {
        return (EOperation)this.astronomyUtilsEClass.getEOperations().get(1);
    }

    @Override
    public EOperation getAstronomyUtils__GetMoonEquatorialPosition__double() {
        return (EOperation)this.astronomyUtilsEClass.getEOperations().get(2);
    }

    @Override
    public EOperation getAstronomyUtils__GetMoonTopocentricEquatorialPosition__Date_double_double() {
        return (EOperation)this.astronomyUtilsEClass.getEOperations().get(3);
    }

    @Override
    public EOperation getAstronomyUtils__GetHorizontalMoonPosition__Date_double_double() {
        return (EOperation)this.astronomyUtilsEClass.getEOperations().get(4);
    }

    @Override
    public EOperation getAstronomyUtils__GetTimeSinceJ2000__double() {
        return (EOperation)this.astronomyUtilsEClass.getEOperations().get(5);
    }

    @Override
    public EOperation getAstronomyUtils__GetLocalSideralTime__Date_double() {
        return (EOperation)this.astronomyUtilsEClass.getEOperations().get(6);
    }

    @Override
    public EOperation getAstronomyUtils__GetUTCDecimalHours__Date() {
        return (EOperation)this.astronomyUtilsEClass.getEOperations().get(7);
    }

    @Override
    public EOperation getAstronomyUtils__ConvertToHorizontalCoordinates__EquatorialCoordinates_double_double_Date() {
        return (EOperation)this.astronomyUtilsEClass.getEOperations().get(8);
    }

    @Override
    public EOperation getAstronomyUtils__ConvertTimeToAngle__int_int_int() {
        return (EOperation)this.astronomyUtilsEClass.getEOperations().get(9);
    }

    @Override
    public EOperation getAstronomyUtils__ClampAngleToZero2PI__double() {
        return (EOperation)this.astronomyUtilsEClass.getEOperations().get(10);
    }

    @Override
    public EOperation getAstronomyUtils__ConvertToEquatorialCoordinates__EclipticCoordinates() {
        return (EOperation)this.astronomyUtilsEClass.getEOperations().get(11);
    }

    @Override
    public EOperation getAstronomyUtils__ConvertToEclipticCoordinates__EquatorialCoordinates() {
        return (EOperation)this.astronomyUtilsEClass.getEOperations().get(12);
    }

    @Override
    public EOperation getAstronomyUtils__ConvertFromEquatorialRectangularToEclipticRectangular__Point3d() {
        return (EOperation)this.astronomyUtilsEClass.getEOperations().get(13);
    }

    @Override
    public EOperation getAstronomyUtils__ConvertFromEclipticRectangularToEquatorialRectangular__Point3d() {
        return (EOperation)this.astronomyUtilsEClass.getEOperations().get(14);
    }

    @Override
    public EOperation getAstronomyUtils__ConvertFromEclipticRectangularToEclipticCoordinates__Point3d() {
        return (EOperation)this.astronomyUtilsEClass.getEOperations().get(15);
    }

    @Override
    public EOperation getAstronomyUtils__ConvertFromEquatorialRectangularToEquatorialCoordinates__Point3d() {
        return (EOperation)this.astronomyUtilsEClass.getEOperations().get(16);
    }

    @Override
    public EOperation getAstronomyUtils__ConvertFromHorizontalCoordinatesToHorizontalRectangular__HorizontalCoordinates() {
        return (EOperation)this.astronomyUtilsEClass.getEOperations().get(17);
    }

    @Override
    public EOperation getAstronomyUtils__ConvertFromEquatorialCoordinatesToEquatorialRectangular__EquatorialCoordinates() {
        return (EOperation)this.astronomyUtilsEClass.getEOperations().get(18);
    }

    @Override
    public EOperation getAstronomyUtils__ConvertAUtoMeters__double() {
        return (EOperation)this.astronomyUtilsEClass.getEOperations().get(19);
    }

    @Override
    public EOperation getAstronomyUtils__GetMaximumSunAltitude__double() {
        return (EOperation)this.astronomyUtilsEClass.getEOperations().get(20);
    }

    @Override
    public EOperation getAstronomyUtils__ConvertToHHmmssString__double() {
        return (EOperation)this.astronomyUtilsEClass.getEOperations().get(21);
    }

    @Override
    public EOperation getAstronomyUtils__GetSunRiseTime__Date_double_double() {
        return (EOperation)this.astronomyUtilsEClass.getEOperations().get(22);
    }

    @Override
    public EOperation getAstronomyUtils__GetSunSetTime__Date_double_double() {
        return (EOperation)this.astronomyUtilsEClass.getEOperations().get(23);
    }

    @Override
    public EOperation getAstronomyUtils__GetSunHighestElevationTime__Date_double_double() {
        return (EOperation)this.astronomyUtilsEClass.getEOperations().get(24);
    }

    @Override
    public EDataType getPoint3d() {
        return this.point3dEDataType;
    }

    @Override
    public ApogyEarthSurfaceEnvironmentFactory getApogyEarthSurfaceEnvironmentFactory() {
        return (ApogyEarthSurfaceEnvironmentFactory)this.getEFactoryInstance();
    }

    public void createPackageContents() {
        if (this.isCreated) {
            return;
        }
        this.isCreated = true;
        this.earthSurfaceWorksiteEClass = this.createEClass(0);
        this.createEAttribute(this.earthSurfaceWorksiteEClass, 11);
        this.createEReference(this.earthSurfaceWorksiteEClass, 12);
        this.createEOperation(this.earthSurfaceWorksiteEClass, 1);
        this.createEOperation(this.earthSurfaceWorksiteEClass, 2);
        this.earthSkyEClass = this.createEClass(1);
        this.createEReference(this.earthSkyEClass, 5);
        this.createEReference(this.earthSkyEClass, 6);
        this.createEReference(this.earthSkyEClass, 7);
        this.createEOperation(this.earthSkyEClass, 1);
        this.earthSurfaceWorksiteNodeEClass = this.createEClass(2);
        this.createEReference(this.earthSurfaceWorksiteNodeEClass, 6);
        this.earthSkyNodeEClass = this.createEClass(3);
        this.apogyEarthSurfaceEnvironmentFacadeEClass = this.createEClass(4);
        this.createEReference(this.apogyEarthSurfaceEnvironmentFacadeEClass, 0);
        this.createEReference(this.apogyEarthSurfaceEnvironmentFacadeEClass, 1);
        this.createEOperation(this.apogyEarthSurfaceEnvironmentFacadeEClass, 0);
        this.createEOperation(this.apogyEarthSurfaceEnvironmentFacadeEClass, 1);
        this.createEOperation(this.apogyEarthSurfaceEnvironmentFacadeEClass, 2);
        this.createEOperation(this.apogyEarthSurfaceEnvironmentFacadeEClass, 3);
        this.createEOperation(this.apogyEarthSurfaceEnvironmentFacadeEClass, 4);
        this.createEOperation(this.apogyEarthSurfaceEnvironmentFacadeEClass, 5);
        this.createEOperation(this.apogyEarthSurfaceEnvironmentFacadeEClass, 6);
        this.atmosphereUtilsEClass = this.createEClass(5);
        this.createEOperation(this.atmosphereUtilsEClass, 0);
        this.createEOperation(this.atmosphereUtilsEClass, 1);
        this.createEOperation(this.atmosphereUtilsEClass, 2);
        this.createEOperation(this.atmosphereUtilsEClass, 3);
        this.astronomyUtilsEClass = this.createEClass(6);
        this.createEOperation(this.astronomyUtilsEClass, 0);
        this.createEOperation(this.astronomyUtilsEClass, 1);
        this.createEOperation(this.astronomyUtilsEClass, 2);
        this.createEOperation(this.astronomyUtilsEClass, 3);
        this.createEOperation(this.astronomyUtilsEClass, 4);
        this.createEOperation(this.astronomyUtilsEClass, 5);
        this.createEOperation(this.astronomyUtilsEClass, 6);
        this.createEOperation(this.astronomyUtilsEClass, 7);
        this.createEOperation(this.astronomyUtilsEClass, 8);
        this.createEOperation(this.astronomyUtilsEClass, 9);
        this.createEOperation(this.astronomyUtilsEClass, 10);
        this.createEOperation(this.astronomyUtilsEClass, 11);
        this.createEOperation(this.astronomyUtilsEClass, 12);
        this.createEOperation(this.astronomyUtilsEClass, 13);
        this.createEOperation(this.astronomyUtilsEClass, 14);
        this.createEOperation(this.astronomyUtilsEClass, 15);
        this.createEOperation(this.astronomyUtilsEClass, 16);
        this.createEOperation(this.astronomyUtilsEClass, 17);
        this.createEOperation(this.astronomyUtilsEClass, 18);
        this.createEOperation(this.astronomyUtilsEClass, 19);
        this.createEOperation(this.astronomyUtilsEClass, 20);
        this.createEOperation(this.astronomyUtilsEClass, 21);
        this.createEOperation(this.astronomyUtilsEClass, 22);
        this.createEOperation(this.astronomyUtilsEClass, 23);
        this.createEOperation(this.astronomyUtilsEClass, 24);
        this.point3dEDataType = this.createEDataType(7);
    }

    public void initializePackageContents() {
        if (this.isInitialized) {
            return;
        }
        this.isInitialized = true;
        this.setName("surface");
        this.setNsPrefix("surface");
        this.setNsURI("org.eclipse.apogy.core.environment.earth.surface");
        ApogyCoreEnvironmentEarthPackage theApogyCoreEnvironmentEarthPackage = (ApogyCoreEnvironmentEarthPackage)EPackage.Registry.INSTANCE.getEPackage("org.eclipse.apogy.core.environment.earth");
        ApogySurfaceEnvironmentPackage theApogySurfaceEnvironmentPackage = (ApogySurfaceEnvironmentPackage)EPackage.Registry.INSTANCE.getEPackage("org.eclipse.apogy.core.environment.surface");
        EcorePackage theEcorePackage = (EcorePackage)EPackage.Registry.INSTANCE.getEPackage("http://www.eclipse.org/emf/2002/Ecore");
        ApogyCommonMathPackage theApogyCommonMathPackage = (ApogyCommonMathPackage)EPackage.Registry.INSTANCE.getEPackage("org.eclipse.apogy.common.math");
        ApogyCoreEnvironmentPackage theApogyCoreEnvironmentPackage = (ApogyCoreEnvironmentPackage)EPackage.Registry.INSTANCE.getEPackage("org.eclipse.apogy.core.environment");
        ApogyCommonTopologyPackage theApogyCommonTopologyPackage = (ApogyCommonTopologyPackage)EPackage.Registry.INSTANCE.getEPackage("org.eclipse.apogy.common.topology");
        ApogyCoreInvocatorPackage theApogyCoreInvocatorPackage = (ApogyCoreInvocatorPackage)EPackage.Registry.INSTANCE.getEPackage("org.eclipse.apogy.core.invocator");
        this.earthSurfaceWorksiteEClass.getESuperTypes().add((Object)theApogyCoreEnvironmentEarthPackage.getEarthWorksite());
        this.earthSurfaceWorksiteEClass.getESuperTypes().add((Object)theApogySurfaceEnvironmentPackage.getSurfaceWorksite());
        this.earthSkyEClass.getESuperTypes().add((Object)theApogyCoreEnvironmentPackage.getSky());
        this.earthSurfaceWorksiteNodeEClass.getESuperTypes().add((Object)theApogySurfaceEnvironmentPackage.getSurfaceWorksiteNode());
        this.earthSkyNodeEClass.getESuperTypes().add((Object)theApogyCoreEnvironmentPackage.getSkyNode());
        this.initEClass(this.earthSurfaceWorksiteEClass, EarthSurfaceWorksite.class, "EarthSurfaceWorksite", false, false, true);
        this.initEAttribute(this.getEarthSurfaceWorksite_XAxisAzimuth(), (EClassifier)theEcorePackage.getEDouble(), "xAxisAzimuth", "0", 0, 1, EarthSurfaceWorksite.class, false, false, true, false, false, false, false, true);
        this.initEReference(this.getEarthSurfaceWorksite_EarthSky(), (EClassifier)this.getEarthSky(), null, "earthSky", null, 1, 1, EarthSurfaceWorksite.class, true, true, true, false, true, false, true, true, true);
        EOperation op = this.initEOperation(this.getEarthSurfaceWorksite__ConvertToGeographicCoordinates__Tuple3d(), (EClassifier)theApogyCoreEnvironmentEarthPackage.getGeographicCoordinates(), "convertToGeographicCoordinates", 0, 1, false, true);
        this.addEParameter(op, (EClassifier)theApogyCommonMathPackage.getTuple3d(), "position", 0, 1, false, true);
        op = this.initEOperation(this.getEarthSurfaceWorksite__ConvertToXYZPosition__GeographicCoordinates(), (EClassifier)theApogyCommonMathPackage.getTuple3d(), "convertToXYZPosition", 0, 1, false, true);
        this.addEParameter(op, (EClassifier)theApogyCoreEnvironmentEarthPackage.getGeographicCoordinates(), "geographicalCoordinates", 0, 1, false, true);
        this.initEClass(this.earthSkyEClass, EarthSky.class, "EarthSky", false, false, true);
        this.initEReference(this.getEarthSky_SunHorizontalCoordinates(), (EClassifier)theApogyCoreEnvironmentEarthPackage.getHorizontalCoordinates(), null, "sunHorizontalCoordinates", null, 0, 1, EarthSky.class, true, false, true, false, true, false, true, true, true);
        this.initEReference(this.getEarthSky_Moon(), (EClassifier)theApogyCoreEnvironmentPackage.getMoon(), null, "moon", null, 0, 1, EarthSky.class, true, false, false, false, true, false, true, true, true);
        this.initEReference(this.getEarthSky_MoonHorizontalCoordinates(), (EClassifier)theApogyCoreEnvironmentEarthPackage.getHorizontalCoordinates(), null, "moonHorizontalCoordinates", null, 0, 1, EarthSky.class, true, false, true, false, true, false, true, true, true);
        this.initEOperation(this.getEarthSky__GetMoonAngularDiameter(), (EClassifier)theEcorePackage.getEDouble(), "getMoonAngularDiameter", 0, 1, false, true);
        this.initEClass(this.earthSurfaceWorksiteNodeEClass, EarthSurfaceWorksiteNode.class, "EarthSurfaceWorksiteNode", false, false, true);
        this.initEReference(this.getEarthSurfaceWorksiteNode_SkyTransformNode(), (EClassifier)theApogyCommonTopologyPackage.getTransformNode(), null, "skyTransformNode", null, 0, 1, EarthSurfaceWorksiteNode.class, true, false, true, false, true, false, true, false, true);
        this.initEClass(this.earthSkyNodeEClass, EarthSkyNode.class, "EarthSkyNode", false, false, true);
        this.initEClass(this.apogyEarthSurfaceEnvironmentFacadeEClass, ApogyEarthSurfaceEnvironmentFacade.class, "ApogyEarthSurfaceEnvironmentFacade", false, false, true);
        this.initEReference(this.getApogyEarthSurfaceEnvironmentFacade_ActiveEarthSurfaceWorksite(), (EClassifier)this.getEarthSurfaceWorksite(), null, "activeEarthSurfaceWorksite", null, 0, 1, ApogyEarthSurfaceEnvironmentFacade.class, true, false, true, false, true, false, true, false, true);
        this.initEReference(this.getApogyEarthSurfaceEnvironmentFacade_ActiveMoon(), (EClassifier)theApogyCoreEnvironmentPackage.getMoon(), null, "activeMoon", null, 0, 1, ApogyEarthSurfaceEnvironmentFacade.class, true, false, true, false, true, false, true, false, true);
        op = this.initEOperation(this.getApogyEarthSurfaceEnvironmentFacade__CreateEarthSky__GeographicCoordinates(), (EClassifier)this.getEarthSky(), "createEarthSky", 0, 1, false, true);
        this.addEParameter(op, (EClassifier)theApogyCoreEnvironmentEarthPackage.getGeographicCoordinates(), "gsiteGeographicCoordinates", 0, 1, false, true);
        op = this.initEOperation(this.getApogyEarthSurfaceEnvironmentFacade__CreateEarthSkyNode__GeographicCoordinates(), (EClassifier)this.getEarthSkyNode(), "createEarthSkyNode", 0, 1, false, true);
        this.addEParameter(op, (EClassifier)theApogyCoreEnvironmentEarthPackage.getGeographicCoordinates(), "gsiteGeographicCoordinates", 0, 1, false, true);
        this.initEOperation(this.getApogyEarthSurfaceEnvironmentFacade__CreateAndInitializeDefaultCSAWorksite(), (EClassifier)this.getEarthSurfaceWorksite(), "createAndInitializeDefaultCSAWorksite", 0, 1, false, true);
        this.initEOperation(this.getApogyEarthSurfaceEnvironmentFacade__CreateEmptyEarthSurfaceWorksite(), (EClassifier)this.getEarthSurfaceWorksite(), "createEmptyEarthSurfaceWorksite", 0, 1, false, true);
        this.initEOperation(this.getApogyEarthSurfaceEnvironmentFacade__GetMarsYardGeographicalCoordinates(), (EClassifier)theApogyCoreEnvironmentEarthPackage.getGeographicCoordinates(), "getMarsYardGeographicalCoordinates", 0, 1, false, true);
        this.initEOperation(this.getApogyEarthSurfaceEnvironmentFacade__GetMarsYardTransformNode(), (EClassifier)theApogyCommonTopologyPackage.getTransformNode(), "getMarsYardTransformNode", 0, 1, false, true);
        this.initEOperation(this.getApogyEarthSurfaceEnvironmentFacade__CreateApogySession(), (EClassifier)theApogyCoreInvocatorPackage.getInvocatorSession(), "createApogySession", 0, 1, false, true);
        this.initEClass(this.atmosphereUtilsEClass, AtmosphereUtils.class, "AtmosphereUtils", false, false, true);
        op = this.initEOperation(this.getAtmosphereUtils__GetAirMass__double(), (EClassifier)theEcorePackage.getEDouble(), "getAirMass", 0, 1, false, true);
        this.addEParameter(op, (EClassifier)theEcorePackage.getEDouble(), "sunAltitudeAngle", 0, 1, false, true);
        op = this.initEOperation(this.getAtmosphereUtils__GetDirectSunIntensity__double_double(), (EClassifier)theEcorePackage.getEDouble(), "getDirectSunIntensity", 0, 1, false, true);
        this.addEParameter(op, (EClassifier)theEcorePackage.getEDouble(), "sunAltitudeAngle", 0, 1, false, true);
        this.addEParameter(op, (EClassifier)theEcorePackage.getEDouble(), "heightAboveSeaLevel", 0, 1, false, true);
        op = this.initEOperation(this.getAtmosphereUtils__GetDiffuseSunIntensity__double_double(), (EClassifier)theEcorePackage.getEDouble(), "getDiffuseSunIntensity", 0, 1, false, true);
        this.addEParameter(op, (EClassifier)theEcorePackage.getEDouble(), "sunAltitudeAngle", 0, 1, false, true);
        this.addEParameter(op, (EClassifier)theEcorePackage.getEDouble(), "heightAboveSeaLevel", 0, 1, false, true);
        op = this.initEOperation(this.getAtmosphereUtils__GetAtmosphereRefractionCorrection__double(), (EClassifier)theEcorePackage.getEDouble(), "getAtmosphereRefractionCorrection", 0, 1, false, true);
        this.addEParameter(op, (EClassifier)theEcorePackage.getEDouble(), "geometricAltitude", 0, 1, false, true);
        this.initEClass(this.astronomyUtilsEClass, AstronomyUtils.class, "AstronomyUtils", false, false, true);
        op = this.initEOperation(this.getAstronomyUtils__GetSunEquatorialPosition__double(), (EClassifier)theApogyCoreEnvironmentPackage.getEquatorialCoordinates(), "getSunEquatorialPosition", 0, 1, false, true);
        this.addEParameter(op, (EClassifier)theEcorePackage.getEDouble(), "julianDay", 0, 1, false, true);
        op = this.initEOperation(this.getAstronomyUtils__GetHorizontalSunPosition__Date_double_double(), (EClassifier)theApogyCoreEnvironmentEarthPackage.getHorizontalCoordinates(), "getHorizontalSunPosition", 0, 1, false, true);
        this.addEParameter(op, (EClassifier)theEcorePackage.getEDate(), "date", 0, 1, false, true);
        this.addEParameter(op, (EClassifier)theEcorePackage.getEDouble(), "observerLongitude", 0, 1, false, true);
        this.addEParameter(op, (EClassifier)theEcorePackage.getEDouble(), "observerLatitude", 0, 1, false, true);
        op = this.initEOperation(this.getAstronomyUtils__GetMoonEquatorialPosition__double(), (EClassifier)theApogyCoreEnvironmentPackage.getEquatorialCoordinates(), "getMoonEquatorialPosition", 0, 1, false, true);
        this.addEParameter(op, (EClassifier)theEcorePackage.getEDouble(), "julianDay", 0, 1, false, true);
        op = this.initEOperation(this.getAstronomyUtils__GetMoonTopocentricEquatorialPosition__Date_double_double(), (EClassifier)theApogyCoreEnvironmentPackage.getEquatorialCoordinates(), "getMoonTopocentricEquatorialPosition", 0, 1, false, true);
        this.addEParameter(op, (EClassifier)theEcorePackage.getEDate(), "date", 0, 1, false, true);
        this.addEParameter(op, (EClassifier)theEcorePackage.getEDouble(), "observerLongitude", 0, 1, false, true);
        this.addEParameter(op, (EClassifier)theEcorePackage.getEDouble(), "observerLatitude", 0, 1, false, true);
        op = this.initEOperation(this.getAstronomyUtils__GetHorizontalMoonPosition__Date_double_double(), (EClassifier)theApogyCoreEnvironmentEarthPackage.getHorizontalCoordinates(), "getHorizontalMoonPosition", 0, 1, false, true);
        this.addEParameter(op, (EClassifier)theEcorePackage.getEDate(), "date", 0, 1, false, true);
        this.addEParameter(op, (EClassifier)theEcorePackage.getEDouble(), "observerLongitude", 0, 1, false, true);
        this.addEParameter(op, (EClassifier)theEcorePackage.getEDouble(), "observerLatitude", 0, 1, false, true);
        op = this.initEOperation(this.getAstronomyUtils__GetTimeSinceJ2000__double(), (EClassifier)theEcorePackage.getEDouble(), "getTimeSinceJ2000", 0, 1, false, true);
        this.addEParameter(op, (EClassifier)theEcorePackage.getEDouble(), "julianDay", 0, 1, false, true);
        op = this.initEOperation(this.getAstronomyUtils__GetLocalSideralTime__Date_double(), (EClassifier)theEcorePackage.getEDouble(), "getLocalSideralTime", 0, 1, false, true);
        this.addEParameter(op, (EClassifier)theEcorePackage.getEDate(), "date", 0, 1, false, true);
        this.addEParameter(op, (EClassifier)theEcorePackage.getEDouble(), "observerLongitude", 0, 1, false, true);
        op = this.initEOperation(this.getAstronomyUtils__GetUTCDecimalHours__Date(), (EClassifier)theEcorePackage.getEDouble(), "getUTCDecimalHours", 0, 1, false, true);
        this.addEParameter(op, (EClassifier)theEcorePackage.getEDate(), "date", 0, 1, false, true);
        op = this.initEOperation(this.getAstronomyUtils__ConvertToHorizontalCoordinates__EquatorialCoordinates_double_double_Date(), (EClassifier)theApogyCoreEnvironmentEarthPackage.getHorizontalCoordinates(), "convertToHorizontalCoordinates", 0, 1, false, true);
        this.addEParameter(op, (EClassifier)theApogyCoreEnvironmentPackage.getEquatorialCoordinates(), "equatorialCoordinates", 0, 1, false, true);
        this.addEParameter(op, (EClassifier)theEcorePackage.getEDouble(), "observerLongitude", 0, 1, false, true);
        this.addEParameter(op, (EClassifier)theEcorePackage.getEDouble(), "observerLatitude", 0, 1, false, true);
        this.addEParameter(op, (EClassifier)theEcorePackage.getEDate(), "date", 0, 1, false, true);
        op = this.initEOperation(this.getAstronomyUtils__ConvertTimeToAngle__int_int_int(), (EClassifier)theEcorePackage.getEDouble(), "convertTimeToAngle", 0, 1, false, true);
        this.addEParameter(op, (EClassifier)theEcorePackage.getEInt(), "hours", 0, 1, false, true);
        this.addEParameter(op, (EClassifier)theEcorePackage.getEInt(), "minutes", 0, 1, false, true);
        this.addEParameter(op, (EClassifier)theEcorePackage.getEInt(), "seconds", 0, 1, false, true);
        op = this.initEOperation(this.getAstronomyUtils__ClampAngleToZero2PI__double(), (EClassifier)theEcorePackage.getEDouble(), "clampAngleToZero2PI", 0, 1, false, true);
        this.addEParameter(op, (EClassifier)theEcorePackage.getEDouble(), "angleInRadians", 0, 1, false, true);
        op = this.initEOperation(this.getAstronomyUtils__ConvertToEquatorialCoordinates__EclipticCoordinates(), (EClassifier)theApogyCoreEnvironmentPackage.getEquatorialCoordinates(), "convertToEquatorialCoordinates", 0, 1, false, true);
        this.addEParameter(op, (EClassifier)theApogyCoreEnvironmentEarthPackage.getEclipticCoordinates(), "eclipticCoordinates", 0, 1, false, true);
        op = this.initEOperation(this.getAstronomyUtils__ConvertToEclipticCoordinates__EquatorialCoordinates(), (EClassifier)theApogyCoreEnvironmentEarthPackage.getEclipticCoordinates(), "convertToEclipticCoordinates", 0, 1, false, true);
        this.addEParameter(op, (EClassifier)theApogyCoreEnvironmentPackage.getEquatorialCoordinates(), "equatorialCoordinates", 0, 1, false, true);
        op = this.initEOperation(this.getAstronomyUtils__ConvertFromEquatorialRectangularToEclipticRectangular__Point3d(), (EClassifier)this.getPoint3d(), "convertFromEquatorialRectangularToEclipticRectangular", 0, 1, false, true);
        this.addEParameter(op, (EClassifier)this.getPoint3d(), "equatorialRectangularCoordinates", 0, 1, false, true);
        op = this.initEOperation(this.getAstronomyUtils__ConvertFromEclipticRectangularToEquatorialRectangular__Point3d(), (EClassifier)this.getPoint3d(), "convertFromEclipticRectangularToEquatorialRectangular", 0, 1, false, true);
        this.addEParameter(op, (EClassifier)this.getPoint3d(), "eclipticCoordinates", 0, 1, false, true);
        op = this.initEOperation(this.getAstronomyUtils__ConvertFromEclipticRectangularToEclipticCoordinates__Point3d(), (EClassifier)theApogyCoreEnvironmentEarthPackage.getEclipticCoordinates(), "convertFromEclipticRectangularToEclipticCoordinates", 0, 1, false, true);
        this.addEParameter(op, (EClassifier)this.getPoint3d(), "eclipticCoordinates", 0, 1, false, true);
        op = this.initEOperation(this.getAstronomyUtils__ConvertFromEquatorialRectangularToEquatorialCoordinates__Point3d(), (EClassifier)theApogyCoreEnvironmentPackage.getEquatorialCoordinates(), "convertFromEquatorialRectangularToEquatorialCoordinates", 0, 1, false, true);
        this.addEParameter(op, (EClassifier)this.getPoint3d(), "equatorialCoordinates", 0, 1, false, true);
        op = this.initEOperation(this.getAstronomyUtils__ConvertFromHorizontalCoordinatesToHorizontalRectangular__HorizontalCoordinates(), (EClassifier)this.getPoint3d(), "convertFromHorizontalCoordinatesToHorizontalRectangular", 0, 1, false, true);
        this.addEParameter(op, (EClassifier)theApogyCoreEnvironmentEarthPackage.getHorizontalCoordinates(), "horizontalCoordinates", 0, 1, false, true);
        op = this.initEOperation(this.getAstronomyUtils__ConvertFromEquatorialCoordinatesToEquatorialRectangular__EquatorialCoordinates(), (EClassifier)this.getPoint3d(), "convertFromEquatorialCoordinatesToEquatorialRectangular", 0, 1, false, true);
        this.addEParameter(op, (EClassifier)theApogyCoreEnvironmentPackage.getEquatorialCoordinates(), "equatorialCoordinates", 0, 1, false, true);
        op = this.initEOperation(this.getAstronomyUtils__ConvertAUtoMeters__double(), (EClassifier)theEcorePackage.getEDouble(), "convertAUtoMeters", 0, 1, false, true);
        this.addEParameter(op, (EClassifier)theEcorePackage.getEDouble(), "astronomicalUnits", 0, 1, false, true);
        op = this.initEOperation(this.getAstronomyUtils__GetMaximumSunAltitude__double(), (EClassifier)theEcorePackage.getEDouble(), "getMaximumSunAltitude", 0, 1, false, true);
        this.addEParameter(op, (EClassifier)theEcorePackage.getEDouble(), "observerLatitude", 0, 1, false, true);
        op = this.initEOperation(this.getAstronomyUtils__ConvertToHHmmssString__double(), (EClassifier)theEcorePackage.getEString(), "convertToHHmmssString", 0, 1, false, true);
        this.addEParameter(op, (EClassifier)theEcorePackage.getEDouble(), "sideralTime", 0, 1, false, true);
        op = this.initEOperation(this.getAstronomyUtils__GetSunRiseTime__Date_double_double(), (EClassifier)theEcorePackage.getEDate(), "getSunRiseTime", 0, 1, false, true);
        this.addEParameter(op, (EClassifier)theEcorePackage.getEDate(), "day", 0, 1, false, true);
        this.addEParameter(op, (EClassifier)theEcorePackage.getEDouble(), "observerLongitude", 0, 1, false, true);
        this.addEParameter(op, (EClassifier)theEcorePackage.getEDouble(), "observerLatitude", 0, 1, false, true);
        op = this.initEOperation(this.getAstronomyUtils__GetSunSetTime__Date_double_double(), (EClassifier)theEcorePackage.getEDate(), "getSunSetTime", 0, 1, false, true);
        this.addEParameter(op, (EClassifier)theEcorePackage.getEDate(), "day", 0, 1, false, true);
        this.addEParameter(op, (EClassifier)theEcorePackage.getEDouble(), "observerLongitude", 0, 1, false, true);
        this.addEParameter(op, (EClassifier)theEcorePackage.getEDouble(), "observerLatitude", 0, 1, false, true);
        op = this.initEOperation(this.getAstronomyUtils__GetSunHighestElevationTime__Date_double_double(), (EClassifier)theEcorePackage.getEDate(), "getSunHighestElevationTime", 0, 1, false, true);
        this.addEParameter(op, (EClassifier)theEcorePackage.getEDate(), "day", 0, 1, false, true);
        this.addEParameter(op, (EClassifier)theEcorePackage.getEDouble(), "observerLongitude", 0, 1, false, true);
        this.addEParameter(op, (EClassifier)theEcorePackage.getEDouble(), "observerLatitude", 0, 1, false, true);
        this.initEDataType(this.point3dEDataType, Point3d.class, "Point3d", true, false);
        this.createResource("org.eclipse.apogy.core.environment.earth.surface");
        this.createGenModelAnnotations();
        this.createApogyAnnotations();
    }

    protected void createGenModelAnnotations() {
        String source = "http://www.eclipse.org/emf/2002/GenModel";
        this.addAnnotation((ENamedElement)this, source, new String[]{"prefix", "ApogyEarthSurfaceEnvironment", "childCreationExtenders", "true", "extensibleProviderFactory", "true", "multipleEditorPages", "false", "copyrightText", "*******************************************************************************\nCopyright (c) 2018 Agence spatiale canadienne / Canadian Space Agency \nAll rights reserved. This program and the accompanying materials\nare made available under the terms of the Eclipse Public License v1.0\nwhich accompanies this distribution, and is available at\nhttp://www.eclipse.org/legal/epl-v10.html\n\nContributors:\n     Pierre Allard - initial API and implementation\n     Regent L'Archeveque \n        \nSPDX-License-Identifier: EPL-1.0    \n*******************************************************************************", "modelName", "ApogyCoreEnvironment", "complianceLevel", "8.0", "suppressGenModelAnnotations", "false", "dynamicTemplates", "true", "templateDirectory", "platform:/plugin/org.eclipse.apogy.common.emf.codegen/templates", "modelDirectory", "/org.eclipse.apogy.core.environment.earth.surface/src-gen", "editDirectory", "/org.eclipse.apogy.core.environment.earth.surface.edit/src-gen", "basePackage", "org.eclipse.apogy.core.environment.earth"});
        this.addAnnotation((ENamedElement)this.earthSurfaceWorksiteEClass, source, new String[]{"documentation", "*\nA specialization of Worksite defining a are or volume at the Earth surface."});
        this.addAnnotation((ENamedElement)this.getEarthSurfaceWorksite__ConvertToGeographicCoordinates__Tuple3d(), source, new String[]{"documentation", "*\nConverts a position expressed as XYZ in the EarthSurfaceWorksite frame\nto a WS84 GeographicCoordinates.\n@param position The position in the worksite coordinates system.\n@return The GeographicCoordinates of the position, in the WS84 datum."});
        this.addAnnotation((ENamedElement)this.getEarthSurfaceWorksite__ConvertToXYZPosition__GeographicCoordinates(), source, new String[]{"documentation", "*\nConverts a WS84 GeographicCoordinates to a XYZ position in the EarthSurfaceWorksite frame.\n@param geographicalCoordinates The geographical coordinates expressed in the WS84 datum.\n@return The XYZ position in the worksite coordinates system."});
        this.addAnnotation((ENamedElement)this.getEarthSurfaceWorksite_XAxisAzimuth(), source, new String[]{"documentation", "*\nAzimuth, relative to true North, of the X axis of the worksite\ncoordinates system. Follows the right hand rule.\nNote that the Z axis is pointing up (toward zenith)."});
        this.addAnnotation((ENamedElement)this.getEarthSurfaceWorksite_EarthSky(), source, new String[]{"documentation", "*\nThe EarthSky associated with the worksite,"});
        this.addAnnotation((ENamedElement)this.earthSkyEClass, source, new String[]{"documentation", "A specialization of the Sky for Earth use that adds the Moon. The position of the Moon is\nupdated, along with the Sun and stars, when the time is changed."});
        this.addAnnotation((ENamedElement)this.getEarthSky__GetMoonAngularDiameter(), source, new String[]{"documentation", "Returns the Moon angular diameter, in radians."});
        this.addAnnotation((ENamedElement)this.getEarthSky_SunHorizontalCoordinates(), source, new String[]{"documentation", "The current HorizontalCordinates of the Sun.", "propertyCategory", "SUN"});
        this.addAnnotation((ENamedElement)this.getEarthSky_Moon(), source, new String[]{"documentation", "The Moon in the sky.", "propertyCategory", "MOON"});
        this.addAnnotation((ENamedElement)this.getEarthSky_MoonHorizontalCoordinates(), source, new String[]{"documentation", "The current HorizontalCordinates of the Moon.", "propertyCategory", "MOON"});
        this.addAnnotation((ENamedElement)this.earthSurfaceWorksiteNodeEClass, source, new String[]{"documentation", " -------------------------------------------------------------------------\n\nSpecific Topology Nodes.\n\n-------------------------------------------------------------------------"});
        this.addAnnotation((ENamedElement)this.earthSkyNodeEClass, source, new String[]{"documentation", "SkyNode specialized for the Earth Sky."});
        this.addAnnotation((ENamedElement)this.apogyEarthSurfaceEnvironmentFacadeEClass, source, new String[]{"documentation", " -------------------------------------------------------------------------\n\nFacade\n\n-------------------------------------------------------------------------"});
        this.addAnnotation((ENamedElement)this.getApogyEarthSurfaceEnvironmentFacade__CreateEarthSky__GeographicCoordinates(), source, new String[]{"documentation", "*\nCreates an EarthSky"});
        this.addAnnotation((ENamedElement)this.getApogyEarthSurfaceEnvironmentFacade__CreateEarthSkyNode__GeographicCoordinates(), source, new String[]{"documentation", "*\nCreates an EarthSkyNode"});
        this.addAnnotation((ENamedElement)this.getApogyEarthSurfaceEnvironmentFacade__CreateAndInitializeDefaultCSAWorksite(), source, new String[]{"documentation", "Create an empty EarthSurfaceWorksite with the CSA Mars Yard coordinates."});
        this.addAnnotation((ENamedElement)this.getApogyEarthSurfaceEnvironmentFacade__CreateEmptyEarthSurfaceWorksite(), source, new String[]{"documentation", "Create an empty EarthSurfaceWorksite."});
        this.addAnnotation((ENamedElement)this.getApogyEarthSurfaceEnvironmentFacade__GetMarsYardGeographicalCoordinates(), source, new String[]{"documentation", "*\nReturn the GeographicCoordinates of the CSA Mars Yard."});
        this.addAnnotation((ENamedElement)this.getApogyEarthSurfaceEnvironmentFacade__CreateApogySession(), source, new String[]{"documentation", "*\nCreates an invocator session containing a fully initialized EarthSurfaceWorksite."});
        this.addAnnotation((ENamedElement)this.getApogyEarthSurfaceEnvironmentFacade_ActiveEarthSurfaceWorksite(), source, new String[]{"documentation", "Refers to the active EarthSurfaceWorksite. May be null."});
        this.addAnnotation((ENamedElement)this.getApogyEarthSurfaceEnvironmentFacade_ActiveMoon(), source, new String[]{"documentation", "Refers to the active Moon. May be null."});
        this.addAnnotation((ENamedElement)this.atmosphereUtilsEClass, source, new String[]{"documentation", " -------------------------------------------------------------------------\n\nUtilities classes.\n\n-------------------------------------------------------------------------"});
        this.addAnnotation((ENamedElement)this.getAtmosphereUtils__GetAirMass__double(), source, new String[]{"documentation", "Computes the air mass. The Air Mass is the path length which light\ntakes through the atmosphere normalized to the shortest possible path\nlength (that is, when the sun is directly overhead). The Air Mass\nquantifies the reduction in the power of light as it passes through\nthe atmosphere and is absorbed by air and dust.\n@param sunAltitudeAngle The sun elevation angle above the horizon, in radians.\n@see http://pvcdrom.pveducation.org/SUNLIGHT/AIRMASS.HTM."});
        this.addAnnotation((ENamedElement)this.getAtmosphereUtils__GetDirectSunIntensity__double_double(), source, new String[]{"documentation", "Computes the intensity of the direct component of sunlight, in Watts/m^2.\n@param sunAltitudeAngle The sun elevation angle above the horizon, in radians.\n@param heightAboveSeaLevel Height above sea level, in meters.\n@see http://pvcdrom.pveducation.org/SUNLIGHT/AIRMASS.HTM"});
        this.addAnnotation((ENamedElement)this.getAtmosphereUtils__GetDiffuseSunIntensity__double_double(), source, new String[]{"documentation", "Computes the intensity of the diffuse component of sunlight, in Watts/m^2.\n@param sunAltitudeAngle The sun elevation angle above the horizon, in radians.\n@param heightAboveSeaLevel Height above sea level, in meters.\n@see http://pvcdrom.pveducation.org/SUNLIGHT/AIRMASS.HTM"});
        this.addAnnotation((ENamedElement)this.getAtmosphereUtils__GetAtmosphereRefractionCorrection__double(), source, new String[]{"documentation", "Computes the change in altitude that needs to be added to the altitude of\nHorizontalCoordinates to take into account the Earth's atmosphere refraction.\nThe calculations in the NOAA Sunrise/Sunset and Solar Position Calculators are\nbased on equations from Astronomical Algorithms, by Jean Meeus. The sunrise and\nsunset results have been verified to be accurate to within a minute for locations\nbetween +/- 72\u00b0 latitude, and within 10 minutes outside of those latitudes.\n@param geometricAltitude The true altitude (as defined in HorizontalCoordinates) of the object, in radians.\n@see ../doc/AtmosphereRefractionCalculations.html or http://www.srrb.noaa.gov/highlights/sunrise/calcdetails.html."});
        this.addAnnotation((ENamedElement)this.astronomyUtilsEClass, source, new String[]{"documentation", "Class that provides methods to find the position of the Moon and Sun in the sky."});
        this.addAnnotation((ENamedElement)this.getAstronomyUtils__GetSunEquatorialPosition__double(), source, new String[]{"documentation", "Computes the Sun's equatorial coordinates for a given Julian date.\nThe calculation are based on page C24 of the 1996 Astronomical Almanac\nwhich provides a method for finding the position of the Sun in the sky\nto an accuracy of 0.01 degree between the years 1950 and 2050. The\nformulas are based on an elliptical orbit for the Earth, using mean\norbital elements and a two term approximation for the 'equation of centre'.\n\nThere is also an approximate allowance made for the change in obliquity of\nthe ecliptic with time, needed when converting to right ascension and\ndeclination. The positions are thus apparent positions, they are referred to\nthe mean ecliptic and equinox of date. The positions found using this low\nprecision formula with values referred to the mean ecliptic and equinox of\ndate from a more accurate program. The results (for the whole 1950 to 2050 range)\nhave been found to be accurate within 3 seconds of RA and 15 arc seconds in declination.\n\n@see http://www.stargazing.net/kepler/sun.html#twig02"});
        this.addAnnotation((ENamedElement)this.getAstronomyUtils__GetHorizontalSunPosition__Date_double_double(), source, new String[]{"documentation", "Computes the Sun's horizontal coordinates for a date and location on the surface of the Earth.\n@param observerLongitude The observer longitude, in radians. Longitude east of Greenwich are positive, west of Greenwich are negative.\n@param observerLatitude The observer latitude, in radians. Latitude North of the equator are positive, Southe of the equator are negative."});
        this.addAnnotation((ENamedElement)this.getAstronomyUtils__GetMoonEquatorialPosition__double(), source, new String[]{"documentation", "Computes the Moon's equatorial coordinates for a given Julian date for\nan observer a the center of the Earth.\nSee doc/tutorial.html for more details."});
        this.addAnnotation((ENamedElement)this.getAstronomyUtils__GetMoonTopocentricEquatorialPosition__Date_double_double(), source, new String[]{"documentation", "Computes the Moon's equatorial coordinates for a date and location on\nthe surface of the Earth. This position take into account the radius of\nthe Earth.\n@param observerLongitude The observer longitude, in radians. Longitude east of Greenwich are positive, west of Greenwich are negative.\n@param observerLatitude The observer latitude, in radians. Latitude North of the equator are positive, Southe of the equator are negative."});
        this.addAnnotation((ENamedElement)this.getAstronomyUtils__GetHorizontalMoonPosition__Date_double_double(), source, new String[]{"documentation", "Computes the Moon's horizontal coordinates.\n@param observerLongitude The observer longitude, in radians. Longitude east of Greenwich are positive, west of Greenwich are negative.\n@param observerLatitude The observer latitude, in radians. Latitude North of the equator are positive, Southe of the equator are negative."});
        this.addAnnotation((ENamedElement)this.getAstronomyUtils__GetTimeSinceJ2000__double(), source, new String[]{"documentation", "Return the number of days since epoch J2000."});
        this.addAnnotation((ENamedElement)this.getAstronomyUtils__GetLocalSideralTime__Date_double(), source, new String[]{"documentation", "Return the local sideral time, in radians, clamped between 0 and 2\u03c0 (360 degrees).\n\nSidereal time is a system of timekeeping based on the rotation of the Earth with respect\nto the fixed stars in the sky. More specifically, it is the measure of the hour angle of\nthe vernal equinox. If the hour angle is measured with respect to the true equinox, apparent\nsidereal time is being measured. If the hour angle is measured with respect to the mean\nequinox, mean sidereal time is being measured. When the measurements are made with respect to\nthe meridian at Greenwich, the times are referred to as Greenwich mean sidereal time (GMST)\nand Greenwich apparent sidereal time (GAST). Given below is a simple algorithm for computing\napparent sidereal time to an accuracy of about 0.1 second, equivalent to about 1.5 arcseconds\non the sky. The input time required by the algorithm is represented as a Julian date (Julian\ndates can be used to determine Universal Time.)Let JD be the Julian date of the time of interest.\nLet JD0 be the Julian date of the previous midnight (0h) UT (the value of JD0 will end in .5\nexactly), and let H be the hours of UT elapsed since that time. Thus we have JD = JD0 + H/24.\n\nFor both of these Julian dates, compute the number of days and fraction (+ or -) from 2000\nJanuary 1, 12h UT, Julian date 2451545.0:\n\nD = JD - 2451545.0\nD0 = JD0 - 2451545.0\n\nThen the Greenwich mean sidereal time in hours is:\n\nGMST = 6.697374558 + 0.06570982441908 D0 + 1.00273790935 H + 0.000026 T\n\t * where T = D/36525 is the number of centuries since the year 2000; thus the\nlast term can be omitted in most applications. It will be necessary to\nreduce GMST to the range 0h to 24h. Setting H = 0 in the above formula yields\nthe Greenwich mean sidereal time at 0h UT, which is tabulated in The Astronomical Almanac.\n\nThe following alternative formula can be used with a loss of precision of 0.1 second per century:\n\nGMST = 18.697374558 + 24.06570982441908 D\n\t * where, as above, GMST must be reduced to the range 0h to 24h. The equations for GMST given\nabove are adapted from those given in Appendix A of USNO Circular No. 163 (1981).\n\t * The Greenwich apparent sidereal time is obtained by adding a correction to the Greenwich\nmean sidereal time computed above. The correction term is called the nutation in right\nascension or the equation of the equinoxes. Thus,\n\nGAST = GMST + eqeq.\n\nThe equation of the equinoxes is given as eqeq = \u0394\u03c8 cos \u03b5 where \u0394\u03c8, the nutation in longitude,\nis given in hours approximately by:\n\n \u0394\u03c8 \u2248 -0.000319 sin \u03a9 - 0.000024 sin 2L\n\nwith \u03a9,  the Longitude of the ascending node of the Moon, given as:\n\n\u03a9 = 125.04 - 0.052954 D,\n\t * and L, the Mean Longitude of the Sun, given as:\n\nL = 280.47 + 0.98565 D.\n\n \u03b5 is the obliquity and is given as:\n\n \u03b5 = 23.4393 - 0.0000004 D.\n\nThe above expressions for \u03a9, L, and \u03b5 are all expressed in degrees.\n\t * The mean or apparent sidereal time locally is found by obtaining the local longitude in degrees,\nconverting it to hours by dividing by 15, and then adding it to or subtracting it from the Greenwich\ntime depending on whether the local position is east (add) or west (subtract) of Greenwich.\n\n@param date The date\n@param observerLongitude The observer longitude, in radians. Longitude East of Greenwich are positive, West of Greenwich are negative."});
        this.addAnnotation((ENamedElement)this.getAstronomyUtils__GetUTCDecimalHours__Date(), source, new String[]{"documentation", "Return the decimal time of day in UTC for a given date."});
        this.addAnnotation((ENamedElement)this.getAstronomyUtils__ConvertToHorizontalCoordinates__EquatorialCoordinates_double_double_Date(), source, new String[]{"documentation", "Converts Equatorial Coordinates to HorizontalCoordinates for a given geographic location and date.\n@param equatorialCoordinates The location, in equatorial coordinates\n@param observerLongitude The observer longitude, in radians. Longitude east of Greenwich are positive, west of Greenwich are negative.\n@param observerLatitude The observer latitude, in radians. Latitude North of the equator are positive, Southe of the equator are negative.\n@param date The date"});
        this.addAnnotation((ENamedElement)this.getAstronomyUtils__ConvertTimeToAngle__int_int_int(), source, new String[]{"documentation", "Convert a day's hour, minutes and seconds to an angle, in radians. 24 hours converts to 2\u03c0 (360 degrees)."});
        this.addAnnotation((ENamedElement)this.getAstronomyUtils__ClampAngleToZero2PI__double(), source, new String[]{"documentation", "Clamps the specified angle between 0 and 2\u03c0 (360 degrees)."});
        this.addAnnotation((ENamedElement)this.getAstronomyUtils__ConvertToEquatorialCoordinates__EclipticCoordinates(), source, new String[]{"documentation", "Converts Ecliptic Coordinates to Equatorial Coordinates."});
        this.addAnnotation((ENamedElement)this.getAstronomyUtils__ConvertToEclipticCoordinates__EquatorialCoordinates(), source, new String[]{"documentation", "Converts Equatorial Coordinates to Ecliptic Coordinates."});
        this.addAnnotation((ENamedElement)this.getAstronomyUtils__ConvertFromEquatorialRectangularToEclipticRectangular__Point3d(), source, new String[]{"documentation", "Converts Rectangular (x,y,z) Equatorial Coordinates to Equatorial Coordinates\n(Right Ascension and Declination)."});
        this.addAnnotation((ENamedElement)this.getAstronomyUtils__ConvertFromEclipticRectangularToEquatorialRectangular__Point3d(), source, new String[]{"documentation", "Converts Rectangular (x,y,z) Ecliptic Coordinates to Rectangular (x,y,z) Equatorial Coordinates."});
        this.addAnnotation((ENamedElement)this.getAstronomyUtils__ConvertFromEclipticRectangularToEclipticCoordinates__Point3d(), source, new String[]{"documentation", "Converts Rectangular (x,y,z) Ecliptic Coordinates to Ecliptic Coordinates (longitude, latitude, radius)."});
        this.addAnnotation((ENamedElement)this.getAstronomyUtils__ConvertFromEquatorialRectangularToEquatorialCoordinates__Point3d(), source, new String[]{"documentation", "Converts Rectangular (x,y,z) Equatorial Coordinates to Equatorial Coordinates (Right Ascension, Declination)."});
        this.addAnnotation((ENamedElement)this.getAstronomyUtils__ConvertFromHorizontalCoordinatesToHorizontalRectangular__HorizontalCoordinates(), source, new String[]{"documentation", "Converts HorizontalCoordinates () to Rectangular Horizontal (x,y,z) coordinates. Rectangular\nHorizontal coordinates are defined as followed:\n- X point to True North.\n- Y points West.\n- Z point toward nadir (up)"});
        this.addAnnotation((ENamedElement)this.getAstronomyUtils__ConvertAUtoMeters__double(), source, new String[]{"documentation", "Convert Astronomical Units (A.U.) to meters."});
        this.addAnnotation((ENamedElement)this.getAstronomyUtils__GetMaximumSunAltitude__double(), source, new String[]{"documentation", "Return the maximum altitude angle that the sun could reach at the specified latitude, in radians."});
        this.addAnnotation((ENamedElement)this.getAstronomyUtils__ConvertToHHmmssString__double(), source, new String[]{"documentation", "Converts a sidreal time in HH:mm:ss string"});
        this.addAnnotation((ENamedElement)this.getAstronomyUtils__GetSunRiseTime__Date_double_double(), source, new String[]{"documentation", "Computes the sun rise time for a given day and location.\n@param day The date of the day\n@param observerLongitude The observer longitude, in radians. Longitude east of Greenwich are positive, west of Greenwich are negative.\n@param observerLatitude The observer latitude, in radians. Latitude North of the equator are positive, South of the equator are negative."});
        this.addAnnotation((ENamedElement)this.getAstronomyUtils__GetSunSetTime__Date_double_double(), source, new String[]{"documentation", "Computes the sun set time for a given day and location.\n@param day The date of the day\n@param observerLongitude The observer longitude, in radians. Longitude east of Greenwich are positive, west of Greenwich are negative.\n@param observerLatitude The observer latitude, in radians. Latitude North of the equator are positive, South of the equator are negative."});
        this.addAnnotation((ENamedElement)this.getAstronomyUtils__GetSunHighestElevationTime__Date_double_double(), source, new String[]{"documentation", "Computes the time of maximum sun elevation for a given day and location.\n@param day The date of the day\n@param observerLongitude The observer longitude, in radians. Longitude east of Greenwich are positive, west of Greenwich are negative.\n@param observerLatitude The observer latitude, in radians. Latitude North of the equator are positive, South of the equator are negative."});
    }

    protected void createApogyAnnotations() {
        String source = "http://www.eclipse.org/apogy";
        this.addAnnotation((ENamedElement)this.earthSurfaceWorksiteEClass, source, new String[]{"hasCustomClass", "true"});
        this.addAnnotation((ENamedElement)this.getEarthSurfaceWorksite_XAxisAzimuth(), source, new String[]{"units", "rad"});
        this.addAnnotation((ENamedElement)this.earthSkyEClass, source, new String[]{"hasCustomClass", "true"});
        this.addAnnotation((ENamedElement)this.getEarthSky__GetMoonAngularDiameter(), source, new String[]{"units", "rad"});
        this.addAnnotation((ENamedElement)this.earthSurfaceWorksiteNodeEClass, source, new String[]{"hasCustomClass", "true"});
        this.addAnnotation((ENamedElement)this.earthSkyNodeEClass, source, new String[]{"hasCustomClass", "true"});
        this.addAnnotation((ENamedElement)this.apogyEarthSurfaceEnvironmentFacadeEClass, source, new String[]{"isSingleton", "true", "hasCustomClass", "true"});
        this.addAnnotation((ENamedElement)this.atmosphereUtilsEClass, source, new String[]{"hasCustomClass", "true", "isSingleton", "true"});
        this.addAnnotation((ENamedElement)this.getAtmosphereUtils__GetAirMass__double().getEParameters().get(0), source, new String[]{"units", "rad"});
        this.addAnnotation((ENamedElement)this.getAtmosphereUtils__GetDirectSunIntensity__double_double(), source, new String[]{"units", "W/m\u00b2"});
        this.addAnnotation((ENamedElement)this.getAtmosphereUtils__GetDirectSunIntensity__double_double().getEParameters().get(0), source, new String[]{"units", "rad"});
        this.addAnnotation((ENamedElement)this.getAtmosphereUtils__GetDirectSunIntensity__double_double().getEParameters().get(1), source, new String[]{"units", "m"});
        this.addAnnotation((ENamedElement)this.getAtmosphereUtils__GetDiffuseSunIntensity__double_double(), source, new String[]{"units", "W/m\u00b2"});
        this.addAnnotation((ENamedElement)this.getAtmosphereUtils__GetDiffuseSunIntensity__double_double().getEParameters().get(0), source, new String[]{"units", "rad"});
        this.addAnnotation((ENamedElement)this.getAtmosphereUtils__GetDiffuseSunIntensity__double_double().getEParameters().get(1), source, new String[]{"units", "m"});
        this.addAnnotation((ENamedElement)this.getAtmosphereUtils__GetAtmosphereRefractionCorrection__double().getEParameters().get(0), source, new String[]{"units", "rad"});
        this.addAnnotation((ENamedElement)this.astronomyUtilsEClass, source, new String[]{"hasCustomClass", "true", "isSingleton", "true"});
        this.addAnnotation((ENamedElement)this.getAstronomyUtils__GetHorizontalSunPosition__Date_double_double().getEParameters().get(1), source, new String[]{"units", "rad"});
        this.addAnnotation((ENamedElement)this.getAstronomyUtils__GetHorizontalSunPosition__Date_double_double().getEParameters().get(2), source, new String[]{"units", "rad"});
        this.addAnnotation((ENamedElement)this.getAstronomyUtils__GetMoonTopocentricEquatorialPosition__Date_double_double().getEParameters().get(1), source, new String[]{"units", "rad"});
        this.addAnnotation((ENamedElement)this.getAstronomyUtils__GetMoonTopocentricEquatorialPosition__Date_double_double().getEParameters().get(2), source, new String[]{"units", "rad"});
        this.addAnnotation((ENamedElement)this.getAstronomyUtils__GetHorizontalMoonPosition__Date_double_double().getEParameters().get(1), source, new String[]{"units", "rad"});
        this.addAnnotation((ENamedElement)this.getAstronomyUtils__GetHorizontalMoonPosition__Date_double_double().getEParameters().get(2), source, new String[]{"units", "rad"});
        this.addAnnotation((ENamedElement)this.getAstronomyUtils__GetLocalSideralTime__Date_double().getEParameters().get(1), source, new String[]{"units", "rad"});
        this.addAnnotation((ENamedElement)this.getAstronomyUtils__ConvertToHorizontalCoordinates__EquatorialCoordinates_double_double_Date().getEParameters().get(1), source, new String[]{"units", "rad"});
        this.addAnnotation((ENamedElement)this.getAstronomyUtils__ConvertToHorizontalCoordinates__EquatorialCoordinates_double_double_Date().getEParameters().get(2), source, new String[]{"units", "rad"});
        this.addAnnotation((ENamedElement)this.getAstronomyUtils__ConvertTimeToAngle__int_int_int(), source, new String[]{"units", "rad"});
        this.addAnnotation((ENamedElement)this.getAstronomyUtils__ClampAngleToZero2PI__double(), source, new String[]{"units", "rad"});
        this.addAnnotation((ENamedElement)this.getAstronomyUtils__ClampAngleToZero2PI__double().getEParameters().get(0), source, new String[]{"units", "rad"});
        this.addAnnotation((ENamedElement)this.getAstronomyUtils__ConvertAUtoMeters__double(), source, new String[]{"units", "m"});
        this.addAnnotation((ENamedElement)this.getAstronomyUtils__GetMaximumSunAltitude__double(), source, new String[]{"units", "rad"});
        this.addAnnotation((ENamedElement)this.getAstronomyUtils__GetMaximumSunAltitude__double().getEParameters().get(0), source, new String[]{"units", "rad"});
        this.addAnnotation((ENamedElement)this.getAstronomyUtils__GetSunRiseTime__Date_double_double().getEParameters().get(1), source, new String[]{"units", "rad"});
        this.addAnnotation((ENamedElement)this.getAstronomyUtils__GetSunRiseTime__Date_double_double().getEParameters().get(2), source, new String[]{"units", "rad"});
        this.addAnnotation((ENamedElement)this.getAstronomyUtils__GetSunSetTime__Date_double_double().getEParameters().get(1), source, new String[]{"units", "rad"});
        this.addAnnotation((ENamedElement)this.getAstronomyUtils__GetSunSetTime__Date_double_double().getEParameters().get(2), source, new String[]{"units", "rad"});
        this.addAnnotation((ENamedElement)this.getAstronomyUtils__GetSunHighestElevationTime__Date_double_double().getEParameters().get(1), source, new String[]{"units", "rad"});
        this.addAnnotation((ENamedElement)this.getAstronomyUtils__GetSunHighestElevationTime__Date_double_double().getEParameters().get(2), source, new String[]{"units", "rad"});
    }
}

