/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.earth.ui.impl;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.BasicShapeAttributes;
import gov.nasa.worldwind.render.Cone;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.render.ShapeAttributes;
import gov.nasa.worldwind.render.SurfaceCircle;
import org.eclipse.apogy.addons.sensors.fov.ConicalFieldOfView;
import org.eclipse.apogy.addons.sensors.fov.DistanceRange;
import org.eclipse.apogy.common.emf.MultiEObjectsAdapter;
import org.eclipse.apogy.core.environment.earth.AbstractSkyline;
import org.eclipse.apogy.core.environment.earth.EarthOutlook;
import org.eclipse.apogy.core.environment.earth.GeographicCoordinates;
import org.eclipse.apogy.core.environment.earth.SimpleSkyline;
import org.eclipse.apogy.core.environment.earth.ui.impl.EarthOutlookWorldWindLayerImpl;
import org.eclipse.apogy.core.environment.earth.ui.utils.WorldWindUtils;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EarthOutlookWorldWindLayerCustomImpl
extends EarthOutlookWorldWindLayerImpl {
    private static final Logger Logger = LoggerFactory.getLogger(EarthOutlookWorldWindLayerCustomImpl.class);
    private MultiEObjectsAdapter groundStationAdapter = null;

    @Override
    public void setEarthSurfaceLocation(EarthOutlook newEarthSurfaceLocation) {
        this.getGroundStationAdapter().unregisterFromAllObjects();
        super.setEarthSurfaceLocation(newEarthSurfaceLocation);
        if (newEarthSurfaceLocation != null) {
            this.getGroundStationAdapter().registerToEObject((EObject)newEarthSurfaceLocation);
        }
        if (this.isAutoUpdateEnabled()) {
            try {
                this.update();
            }
            catch (Exception e) {
                Logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public void setReferenceAltitude(double newReferenceAltitude) {
        super.setReferenceAltitude(newReferenceAltitude);
        if (this.isAutoUpdateEnabled()) {
            try {
                this.update();
            }
            catch (Exception e) {
                Logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public void setShowVisibilityCircle(boolean newShowVisibilityCircle) {
        super.setShowVisibilityCircle(newShowVisibilityCircle);
        if (this.isAutoUpdateEnabled()) {
            try {
                this.update();
            }
            catch (Exception e) {
                Logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public void setShowVisibilityCone(boolean newShowVisibilityCone) {
        super.setShowVisibilityCone(newShowVisibilityCone);
        if (this.isAutoUpdateEnabled()) {
            try {
                this.update();
            }
            catch (Exception e) {
                Logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public void setShowOutline(boolean newShowOutline) {
        super.setShowOutline(newShowOutline);
        if (this.isAutoUpdateEnabled()) {
            try {
                this.update();
            }
            catch (Exception e) {
                Logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public void setName(String newName) {
        super.setName(newName);
        if (this.isAutoUpdateEnabled()) {
            try {
                this.update();
            }
            catch (Exception e) {
                Logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public boolean getDefaultAutoUpdateEnabled() {
        return true;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.getGroundStationAdapter().unregisterFromAllObjects();
    }

    @Override
    protected void updateRenderableLayer() {
        RenderableLayer layer = this.getRenderableLayer();
        layer.removeAllRenderables();
        if (this.isVisible() && this.getEarthSurfaceLocation() != null) {
            EarthOutlookWorldWindLayerCustomImpl.super.addRenderable(layer);
            Object coord = this.getEarthSurfaceLocation();
            Angle latitude = Angle.fromRadiansLatitude((double)coord.getLatitude());
            Angle longitude = Angle.fromRadiansLongitude((double)coord.getLongitude());
            double elevation = coord.getElevation();
            Position position = new Position(latitude, longitude, elevation);
            if (((EarthOutlook)this.getEarthSurfaceLocation()).getSkyline() instanceof SimpleSkyline) {
                double d;
                double angleC;
                double h;
                double R;
                double angleB;
                double angleA;
                double x;
                double r;
                double refAltitude;
                SimpleSkyline cFOV = (SimpleSkyline)((EarthOutlook)this.getEarthSurfaceLocation()).getSkyline();
                double radius = this.computeGroundCircle(cFOV, refAltitude = this.getReferenceAltitude() * 1000.0);
                if (radius < 0.0) {
                    radius = 0.0;
                }
                BasicShapeAttributes fovAttributes = new BasicShapeAttributes();
                fovAttributes.setDrawInterior(true);
                fovAttributes.setOutlineOpacity(0.95);
                fovAttributes.setDrawOutline(this.isShowOutline());
                Material interiorMat = new Material(WorldWindUtils.convertFrom(this.getColor()));
                fovAttributes.setInteriorMaterial(interiorMat);
                fovAttributes.setDrawInterior(true);
                fovAttributes.setInteriorOpacity(this.getOpacity());
                Material outlineMat = new Material(WorldWindUtils.convertFrom(this.getColor()));
                fovAttributes.setOutlineMaterial(outlineMat);
                if (this.isShowVisibilityCircle()) {
                    SurfaceCircle visibilityCircle = new SurfaceCircle((ShapeAttributes)fovAttributes, (LatLon)position, radius, 36);
                    visibilityCircle.setVisible(true);
                    layer.addRenderable((Renderable)visibilityCircle);
                }
                if (this.isShowVisibilityCone() && cFOV.getConstantElevation() > 0.0 && Math.toDegrees(cFOV.getConstantElevation()) < 90.0 && (r = Math.sqrt((x = Math.sin(angleA = Math.PI - (angleB = Math.asin((R = 6371000.0) / (R + (h = this.getReferenceAltitude() * 1000.0)) * Math.sin(angleC = 1.5707963267948966 + cFOV.getConstantElevation()))) - angleC) / Math.sin(angleC) * (R + h)) * x - (d = x * Math.asin(cFOV.getConstantElevation())) * d)) > 0.0) {
                    double northSouthRadius = r;
                    double verticalRadius = d / 2.0;
                    double eastWestRadius = r;
                    Angle heading = Angle.fromDegrees((double)0.0);
                    Angle tilt = Angle.fromDegrees((double)180.0);
                    Angle roll = Angle.fromDegrees((double)0.0);
                    Cone cone = new Cone(new Position(latitude, longitude, elevation + verticalRadius), northSouthRadius, verticalRadius, eastWestRadius, heading, tilt, roll);
                    cone.setAttributes((ShapeAttributes)fovAttributes);
                    layer.addRenderable((Renderable)cone);
                }
            }
        }
    }

    protected double computeGroundCircle(SimpleSkyline simpleSkyline, double range) {
        double radius = 0.0;
        double A = 1.5707963267948966 + simpleSkyline.getConstantElevation();
        double a = 6378137.0 + range;
        double b = 6378137.0;
        double B = Math.asin(b / a * Math.sin(A));
        double C = Math.PI - A - B;
        radius = C * 6378137.0;
        return radius;
    }

    protected MultiEObjectsAdapter getGroundStationAdapter() {
        if (this.groundStationAdapter == null) {
            this.groundStationAdapter = new MultiEObjectsAdapter(){

                public void registerToEObject(EObject eObject) {
                    if (eObject instanceof EarthOutlook) {
                        EarthOutlook newGroundStation = (EarthOutlook)eObject;
                        super.registerToEObject((EObject)newGroundStation);
                        if (newGroundStation.getSkyline() != null) {
                            newGroundStation.getSkyline().eAdapters().add((Object)this);
                        }
                    } else {
                        eObject.eAdapters().add((Object)this);
                    }
                }

                public void notifyChanged(Notification msg) {
                    block40: {
                        block44: {
                            block43: {
                                block42: {
                                    block41: {
                                        block39: {
                                            if (!(msg.getNotifier() instanceof EarthOutlook)) break block39;
                                            int featureId = msg.getFeatureID(EarthOutlook.class);
                                            switch (featureId) {
                                                case 4: {
                                                    if (EarthOutlookWorldWindLayerCustomImpl.this.isAutoUpdateEnabled()) {
                                                        try {
                                                            EarthOutlookWorldWindLayerCustomImpl.this.update();
                                                        }
                                                        catch (Exception e) {
                                                            Logger.error(e.getMessage(), (Throwable)e);
                                                        }
                                                        break;
                                                    }
                                                    break block40;
                                                }
                                                case 7: {
                                                    if (msg.getOldValue() instanceof AbstractSkyline) {
                                                        ((AbstractSkyline)msg.getOldValue()).eAdapters().remove((Object)this);
                                                    }
                                                    if (msg.getNewValue() instanceof AbstractSkyline) {
                                                        ((AbstractSkyline)msg.getNewValue()).eAdapters().add((Object)this);
                                                    }
                                                    if (EarthOutlookWorldWindLayerCustomImpl.this.isAutoUpdateEnabled()) {
                                                        try {
                                                            EarthOutlookWorldWindLayerCustomImpl.this.update();
                                                        }
                                                        catch (Exception e) {
                                                            Logger.error(e.getMessage(), (Throwable)e);
                                                        }
                                                        break;
                                                    }
                                                    break block40;
                                                }
                                                case 0: 
                                                case 1: 
                                                case 2: {
                                                    if (EarthOutlookWorldWindLayerCustomImpl.this.isAutoUpdateEnabled()) {
                                                        try {
                                                            EarthOutlookWorldWindLayerCustomImpl.this.update();
                                                        }
                                                        catch (Exception e) {
                                                            Logger.error(e.getMessage(), (Throwable)e);
                                                        }
                                                        break;
                                                    }
                                                    break block40;
                                                }
                                            }
                                            break block40;
                                        }
                                        if (!(msg.getNotifier() instanceof AbstractSkyline)) break block41;
                                        if (EarthOutlookWorldWindLayerCustomImpl.this.isAutoUpdateEnabled()) {
                                            try {
                                                EarthOutlookWorldWindLayerCustomImpl.this.update();
                                            }
                                            catch (Exception e) {
                                                Logger.error(e.getMessage(), (Throwable)e);
                                            }
                                        }
                                        break block40;
                                    }
                                    if (!(msg.getNotifier() instanceof GeographicCoordinates)) break block42;
                                    if (EarthOutlookWorldWindLayerCustomImpl.this.isAutoUpdateEnabled()) {
                                        try {
                                            EarthOutlookWorldWindLayerCustomImpl.this.update();
                                        }
                                        catch (Exception e) {
                                            Logger.error(e.getMessage(), (Throwable)e);
                                        }
                                    }
                                    break block40;
                                }
                                if (!(msg.getNotifier() instanceof DistanceRange)) break block43;
                                if (EarthOutlookWorldWindLayerCustomImpl.this.isAutoUpdateEnabled()) {
                                    try {
                                        EarthOutlookWorldWindLayerCustomImpl.this.update();
                                    }
                                    catch (Exception e) {
                                        Logger.error(e.getMessage(), (Throwable)e);
                                    }
                                }
                                break block40;
                            }
                            if (!(msg.getNotifier() instanceof ConicalFieldOfView)) break block44;
                            int featureId = msg.getFeatureID(ConicalFieldOfView.class);
                            switch (featureId) {
                                case 3: {
                                    if (msg.getOldValue() instanceof DistanceRange) {
                                        EarthOutlookWorldWindLayerCustomImpl.this.getGroundStationAdapter().unregisterFromEObject((EObject)((DistanceRange)msg.getOldValue()));
                                    }
                                    if (msg.getNewValue() instanceof DistanceRange) {
                                        EarthOutlookWorldWindLayerCustomImpl.this.getGroundStationAdapter().registerToEObject((EObject)((DistanceRange)msg.getNewValue()));
                                    }
                                    if (EarthOutlookWorldWindLayerCustomImpl.this.isAutoUpdateEnabled()) {
                                        try {
                                            EarthOutlookWorldWindLayerCustomImpl.this.update();
                                        }
                                        catch (Exception e) {
                                            Logger.error(e.getMessage(), (Throwable)e);
                                        }
                                        break;
                                    }
                                    break block40;
                                }
                                default: {
                                    if (EarthOutlookWorldWindLayerCustomImpl.this.isAutoUpdateEnabled()) {
                                        try {
                                            EarthOutlookWorldWindLayerCustomImpl.this.update();
                                        }
                                        catch (Exception e) {
                                            Logger.error(e.getMessage(), (Throwable)e);
                                        }
                                        break;
                                    }
                                    break block40;
                                }
                            }
                            break block40;
                        }
                        if (EarthOutlookWorldWindLayerCustomImpl.this.isAutoUpdateEnabled()) {
                            try {
                                EarthOutlookWorldWindLayerCustomImpl.this.update();
                            }
                            catch (Exception e) {
                                Logger.error(e.getMessage(), (Throwable)e);
                            }
                        }
                    }
                }
            };
        }
        return this.groundStationAdapter;
    }
}

