/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.surface.ui.composites;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.images.AbstractEImage;
import org.eclipse.apogy.common.images.EImagesUtilities;
import org.eclipse.apogy.common.images.ui.ImagesUiUtilities;
import org.eclipse.apogy.common.images.ui.composites.ImageDisplayComposite;
import org.eclipse.apogy.common.ui.composites.NoContentComposite;
import org.eclipse.apogy.core.environment.surface.ApogySurfaceEnvironmentPackage;
import org.eclipse.apogy.core.environment.surface.ImageMapLayer;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.databinding.edit.EMFEditProperties;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageMapLayerPreviewComposite
extends Composite {
    private static final Logger Logger = LoggerFactory.getLogger(ImageMapLayerPreviewComposite.class);
    private Adapter adapter = null;
    private ImageMapLayer imageMapLayer;
    private final Label lblImageWidthValue;
    private final Button btnGenerateImage;
    private final Label lblImageHeightValue;
    private final Button btnExportImage;
    private final Composite containerComposite;
    private ImageDisplayComposite imageDisplayComposite;
    private DataBindingContext m_bindingContext;

    public ImageMapLayerPreviewComposite(Composite parent, int style) {
        this(parent, style, null);
    }

    public ImageMapLayerPreviewComposite(Composite parent, int style, final ImageMapLayer imageMapLayer) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(3, false));
        Label lblImageWidth = new Label((Composite)this, 0);
        lblImageWidth.setText("Image Width (pixels):");
        lblImageWidth.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        this.lblImageWidthValue = new Label((Composite)this, 2048);
        GridData gd_lblImageWidthValue = new GridData(16384, 128, false, false, 1, 1);
        gd_lblImageWidthValue.widthHint = 100;
        gd_lblImageWidthValue.minimumWidth = 100;
        this.lblImageWidthValue.setLayoutData((Object)gd_lblImageWidthValue);
        this.btnGenerateImage = new Button((Composite)this, 8);
        GridData gd_btnGenerateImage = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_btnGenerateImage.minimumWidth = 120;
        gd_btnGenerateImage.widthHint = 120;
        this.btnGenerateImage.setLayoutData((Object)gd_btnGenerateImage);
        this.btnGenerateImage.setText("Update Image");
        this.btnGenerateImage.setToolTipText("Update the image based on the selected setting. Note that this can take several minutes depending on the processing involved.");
        this.btnGenerateImage.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                IRunnableWithProgress runnable = new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        if (ImageMapLayerPreviewComposite.this.getImageMapLayer() != null) {
                            ImageMapLayerPreviewComposite.this.getImageMapLayer().updateImage(monitor);
                        }
                    }
                };
                try {
                    new ProgressMonitorDialog(ImageMapLayerPreviewComposite.this.getShell()).run(true, true, runnable);
                }
                catch (Throwable t) {
                    Logger.error(t.getMessage(), t);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Label lblImageHeight = new Label((Composite)this, 0);
        lblImageHeight.setText("Image Height (pixels):");
        lblImageHeight.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        this.lblImageHeightValue = new Label((Composite)this, 2048);
        GridData gd_lblImageHeightValue = new GridData(16384, 128, false, false, 1, 1);
        gd_lblImageHeightValue.widthHint = 100;
        gd_lblImageHeightValue.minimumWidth = 100;
        this.lblImageHeightValue.setLayoutData((Object)gd_lblImageHeightValue);
        this.btnExportImage = new Button((Composite)this, 8);
        GridData gd_btnExportImage = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_btnExportImage.minimumWidth = 120;
        gd_btnExportImage.widthHint = 120;
        this.btnExportImage.setLayoutData((Object)gd_btnExportImage);
        this.btnExportImage.setText("Export Image...");
        this.btnExportImage.setToolTipText("Exports the layer image to file.");
        this.btnExportImage.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    if (ImageMapLayerPreviewComposite.this.getImageMapLayer() != null) {
                        ImageData imageData = EImagesUtilities.INSTANCE.convertToImageData(ImageMapLayerPreviewComposite.this.getImageMapLayer().getImage().asBufferedImage());
                        String defaultName = null;
                        if (ImageMapLayerPreviewComposite.this.getImageMapLayer().getName() != null && ImageMapLayerPreviewComposite.this.getImageMapLayer().getName().length() > 1) {
                            defaultName = String.valueOf(ImageMapLayerPreviewComposite.this.getImageMapLayer().getName()) + ".jpg";
                        }
                        ImagesUiUtilities.export((ImageData)imageData, defaultName);
                    }
                }
                catch (Throwable t) {
                    Logger.error(t.getMessage(), t);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.containerComposite = new Composite((Composite)this, 0);
        GridData gd_compositeDetails = new GridData(4, 4, false, true, 3, 1);
        gd_compositeDetails.widthHint = 398;
        gd_compositeDetails.minimumWidth = 398;
        this.containerComposite.setLayoutData((Object)gd_compositeDetails);
        this.containerComposite.setLayout((Layout)new GridLayout(1, false));
        this.imageDisplayComposite = new ImageDisplayComposite(this.containerComposite, 2048);
        GridData gd_imageDisplayComposite = new GridData(4, 4, true, true, 1, 1);
        gd_imageDisplayComposite.heightHint = 200;
        gd_imageDisplayComposite.minimumHeight = 200;
        gd_imageDisplayComposite.widthHint = 200;
        gd_imageDisplayComposite.minimumWidth = 200;
        this.imageDisplayComposite.setLayoutData((Object)gd_imageDisplayComposite);
        this.imageDisplayComposite.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                ImageMapLayerPreviewComposite.this.imageDisplayComposite.fitImage();
            }
        });
        this.setImageMapLayer(imageMapLayer);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (ImageMapLayerPreviewComposite.this.m_bindingContext != null) {
                    ImageMapLayerPreviewComposite.this.m_bindingContext.dispose();
                }
                if (imageMapLayer != null) {
                    imageMapLayer.eAdapters().remove((Object)ImageMapLayerPreviewComposite.this.getAdapter());
                }
            }
        });
    }

    public ImageMapLayer getImageMapLayer() {
        return this.imageMapLayer;
    }

    public void setImageMapLayer(ImageMapLayer newImageMapLayer) {
        if (this.m_bindingContext != null) {
            this.m_bindingContext.dispose();
        }
        if (this.imageMapLayer != null) {
            this.imageMapLayer.eAdapters().remove((Object)this.getAdapter());
        }
        this.imageMapLayer = newImageMapLayer;
        if (newImageMapLayer != null) {
            this.m_bindingContext = this.customInitDataBindings();
            newImageMapLayer.eAdapters().add((Object)this.getAdapter());
            this.updateImage(newImageMapLayer.getImage());
        } else {
            this.updateImage(null);
        }
    }

    private void updateImage(AbstractEImage abstractEImage) {
        if (abstractEImage != null) {
            this.lblImageWidthValue.setText("0");
            this.lblImageHeightValue.setText("0");
            ImageData imageData = EImagesUtilities.INSTANCE.convertToImageData(this.imageMapLayer.getImage().asBufferedImage());
            if (imageData != null) {
                this.lblImageWidthValue.setText(Integer.toString(this.imageMapLayer.getImage().getWidth()));
                this.lblImageHeightValue.setText(Integer.toString(this.imageMapLayer.getImage().getHeight()));
                this.setImagePreview(imageData);
            } else {
                this.setNoImageToDisplayMessage("Map layer contains no image.");
            }
        } else {
            this.setNoImageToDisplayMessage("Map layer contains no image.");
        }
    }

    private void setImagePreview(ImageData imageData) {
        Control[] controlArray = this.containerComposite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            control.dispose();
            ++n2;
        }
        this.imageDisplayComposite = new ImageDisplayComposite(this.containerComposite, 0);
        GridData gd = new GridData(4, 4, true, true, 1, 1);
        gd.minimumWidth = 200;
        gd.widthHint = 200;
        gd.heightHint = 200;
        gd.minimumWidth = 200;
        this.imageDisplayComposite.setLayoutData((Object)gd);
        this.imageDisplayComposite.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                ImageMapLayerPreviewComposite.this.imageDisplayComposite.fitImage();
            }
        });
        this.imageDisplayComposite.setImageData(imageData);
        this.imageDisplayComposite.fitImage();
        this.containerComposite.layout();
        this.containerComposite.redraw();
    }

    private void setNoImageToDisplayMessage(final String message) {
        Control[] controlArray = this.containerComposite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            control.dispose();
            ++n2;
        }
        NoContentComposite noContentComposite = new NoContentComposite(this.containerComposite, 0){

            protected String getMessage() {
                return message;
            }
        };
        GridData gd = new GridData(4, 4, false, true, 1, 1);
        gd.minimumWidth = 200;
        gd.widthHint = 200;
        gd.heightHint = 200;
        gd.minimumWidth = 200;
        noContentComposite.setLayoutData((Object)gd);
        this.containerComposite.layout();
    }

    private Adapter getAdapter() {
        if (this.adapter == null) {
            this.adapter = new AdapterImpl(){

                public void notifyChanged(final Notification msg) {
                    int featureID;
                    if (msg.getNotifier() instanceof ImageMapLayer && (featureID = msg.getFeatureID(ImageMapLayer.class)) == 8 && !ImageMapLayerPreviewComposite.this.isDisposed()) {
                        ImageMapLayerPreviewComposite.this.getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (msg.getNewValue() instanceof AbstractEImage) {
                                    ImageMapLayerPreviewComposite.this.updateImage((AbstractEImage)msg.getNewValue());
                                } else {
                                    ImageMapLayerPreviewComposite.this.updateImage(null);
                                }
                            }
                        });
                    }
                }
            };
        }
        return this.adapter;
    }

    protected DataBindingContext customInitDataBindings() {
        DataBindingContext bindingContext = new DataBindingContext();
        IObservableValue observeImageMapLayerImage = EMFEditProperties.value((EditingDomain)ApogyCommonTransactionFacade.INSTANCE.getTransactionalEditingDomain((EObject)this.getImageMapLayer()), (FeaturePath)FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{ApogySurfaceEnvironmentPackage.Literals.IMAGE_MAP_LAYER__IMAGE})).observe((Object)this.getImageMapLayer());
        ISWTObservableValue observeEnabledBtnDeleteObserveWidget = WidgetProperties.enabled().observe((Widget)this.btnExportImage);
        bindingContext.bindValue((IObservableValue)observeEnabledBtnDeleteObserveWidget, observeImageMapLayerImage, null, new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE).setConverter((IConverter)new Converter(Object.class, Boolean.class){

            public Object convert(Object fromObject) {
                if (fromObject != null) {
                    return true;
                }
                return false;
            }
        }));
        return bindingContext;
    }
}

