/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.surface.ui.wizards;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.apogy.core.environment.surface.AbstractMapLayer;
import org.eclipse.apogy.core.environment.surface.ApogySurfaceEnvironmentPackage;
import org.eclipse.apogy.core.environment.surface.CartesianTriangularMeshDerivedImageMapLayer;
import org.eclipse.apogy.core.environment.surface.CartesianTriangularMeshMapLayer;
import org.eclipse.apogy.core.environment.surface.Map;
import org.eclipse.apogy.core.environment.surface.ui.ImageMapLayerUISettings;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.databinding.edit.EMFEditProperties;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;

public class CartesianTriangularMeshDerivedImageMapLayerWizardPage
extends WizardPage {
    private static final String WIZARD_PAGE_ID = "org.eclipse.apogy.core.environment.surface.ui.wizards.CartesianTriangularMeshDerivedImageMapLayerWizardPage";
    private final CartesianTriangularMeshDerivedImageMapLayer cartesianTriangularMeshDerivedImageMapLayer;
    private final ImageMapLayerUISettings uiSettings;
    private final AdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
    private Tree tree;
    private TreeViewer treeViewer;
    private Text txtRequiredresolutiontext;
    private DataBindingContext m_bindingContext;

    public CartesianTriangularMeshDerivedImageMapLayerWizardPage(CartesianTriangularMeshDerivedImageMapLayer cartesianTriangularMeshDerivedImageMapLayer, ImageMapLayerUISettings uiSettings) {
        super(WIZARD_PAGE_ID);
        this.cartesianTriangularMeshDerivedImageMapLayer = cartesianTriangularMeshDerivedImageMapLayer;
        this.uiSettings = uiSettings;
        this.setTitle("Mesh Derived Image Map Layer");
        this.setDescription("Select the required resolution and map layer containing the mesh for which to generate the image.");
        this.validate();
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        Label lblRequiredResolutionmpixel = new Label(container, 0);
        lblRequiredResolutionmpixel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblRequiredResolutionmpixel.setText("Resolution (m/pixel):");
        this.txtRequiredresolutiontext = new Text(container, 2048);
        this.txtRequiredresolutiontext.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblCartesianTriangularMeshMapLayer = new Label(container, 0);
        lblCartesianTriangularMeshMapLayer.setLayoutData((Object)new GridData(131072, 128, false, false, 1, 1));
        lblCartesianTriangularMeshMapLayer.setText("Source Mesh Layer:");
        this.treeViewer = new TreeViewer(container, 68354);
        this.tree = this.treeViewer.getTree();
        GridData gd_tree = new GridData(4, 4, false, true, 1, 1);
        gd_tree.widthHint = 300;
        gd_tree.minimumWidth = 300;
        this.tree.setLayoutData((Object)gd_tree);
        this.tree.setLinesVisible(true);
        this.treeViewer.setContentProvider((IContentProvider)new CompositeFilterContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider(this.adapterFactory));
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                CartesianTriangularMeshMapLayer cartesianTriangularMeshMapLayer = (CartesianTriangularMeshMapLayer)((IStructuredSelection)event.getSelection()).getFirstElement();
                CartesianTriangularMeshDerivedImageMapLayerWizardPage.this.uiSettings.getUserDataMap().put("CartesianTriangularMeshMapLayer", cartesianTriangularMeshMapLayer);
                ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)CartesianTriangularMeshDerivedImageMapLayerWizardPage.this.cartesianTriangularMeshDerivedImageMapLayer, (EStructuralFeature)ApogySurfaceEnvironmentPackage.Literals.CARTESIAN_TRIANGULAR_MESH_DERIVED_IMAGE_MAP_LAYER__CARTESIAN_TRIANGULAR_MESH_MAP_LAYER, (Object)cartesianTriangularMeshMapLayer);
                CartesianTriangularMeshDerivedImageMapLayerWizardPage.this.validate();
            }
        });
        this.treeViewer.setInput((Object)this.uiSettings.getMap());
        this.m_bindingContext = this.initDataBindingsCustom();
        this.setControl((Control)container);
        this.validate();
        container.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (CartesianTriangularMeshDerivedImageMapLayerWizardPage.this.m_bindingContext != null) {
                    CartesianTriangularMeshDerivedImageMapLayerWizardPage.this.m_bindingContext.dispose();
                }
            }
        });
    }

    protected void validate() {
        System.out.println("Map " + this.uiSettings.getUserDataMap());
        if (this.uiSettings.getUserDataMap().get("CartesianTriangularMeshMapLayer") != null) {
            this.setErrorMessage(null);
            this.setPageComplete(true);
        } else {
            this.setErrorMessage("The Cartesian Triangular Mesh Map Layer is not set !");
            this.setPageComplete(false);
        }
    }

    private DataBindingContext initDataBindingsCustom() {
        DataBindingContext bindingContext = new DataBindingContext();
        IObservableValue observeRequiredResolution = EMFEditProperties.value((EditingDomain)ApogyCommonTransactionFacade.INSTANCE.getTransactionalEditingDomain((EObject)this.cartesianTriangularMeshDerivedImageMapLayer), (FeaturePath)FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{ApogySurfaceEnvironmentPackage.Literals.CARTESIAN_TRIANGULAR_MESH_DERIVED_IMAGE_MAP_LAYER__REQUIRED_RESOLUTION})).observe((Object)this.cartesianTriangularMeshDerivedImageMapLayer);
        ISWTObservableValue observeRequiredResolutionValueText = WidgetProperties.text((int)24).observe((Widget)this.txtRequiredresolutiontext);
        bindingContext.bindValue((IObservableValue)observeRequiredResolutionValueText, observeRequiredResolution, new UpdateValueStrategy().setConverter((IConverter)new Converter(String.class, Double.class){

            public Object convert(Object fromObject) {
                return Double.parseDouble((String)fromObject);
            }
        }), new UpdateValueStrategy().setConverter((IConverter)new Converter(Double.class, String.class){

            public Object convert(Object fromObject) {
                return ((Double)fromObject).toString();
            }
        }));
        return bindingContext;
    }

    public class CompositeFilterContentProvider
    implements ITreeContentProvider {
        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Map) {
                Map map = (Map)inputElement;
                return this.filterMap(map).toArray();
            }
            return null;
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof Map) {
                Map map = (Map)parentElement;
                return this.filterMap(map).toArray();
            }
            return null;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof Map) {
                Map map = (Map)element;
                return !this.filterMap(map).isEmpty();
            }
            return false;
        }

        protected List<CartesianTriangularMeshMapLayer> filterMap(Map map) {
            ArrayList<CartesianTriangularMeshMapLayer> imageMapLayers = new ArrayList<CartesianTriangularMeshMapLayer>();
            for (AbstractMapLayer layer : map.getLayers()) {
                if (!(layer instanceof CartesianTriangularMeshMapLayer)) continue;
                imageMapLayers.add((CartesianTriangularMeshMapLayer)layer);
            }
            return imageMapLayers;
        }
    }
}

