/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.topology.impl;

import org.eclipse.apogy.common.topology.Node;
import org.eclipse.apogy.core.ApogyCoreFactory;
import org.eclipse.apogy.core.ResultsListNode;
import org.eclipse.apogy.core.environment.AbstractWorksite;
import org.eclipse.apogy.core.environment.ApogyEnvironment;
import org.eclipse.apogy.core.environment.Worksite;
import org.eclipse.apogy.core.environment.WorksiteNode;
import org.eclipse.apogy.core.invocator.Context;
import org.eclipse.apogy.core.invocator.OperationCallResultsList;
import org.eclipse.apogy.core.invocator.ResultsList;
import org.eclipse.apogy.core.topology.ApogyCoreTopologyFactory;
import org.eclipse.apogy.core.topology.ApogySystemAPIsNode;
import org.eclipse.apogy.core.topology.impl.ApogyEnvironmentNodeImpl;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;

public class ApogyEnvironmentNodeCustomImpl
extends ApogyEnvironmentNodeImpl {
    private Adapter adapter = null;

    @Override
    public void setApogyEnvironment(ApogyEnvironment newApogyEnvironment) {
        this.updateApogyEnvironment(this.getApogyEnvironment(), newApogyEnvironment);
        super.setApogyEnvironment(newApogyEnvironment);
    }

    @Override
    public void setWorksiteNode(WorksiteNode newWorksiteNode) {
        if (this.getWorksiteNode() != null) {
            this.getChildren().remove((Object)this.getWorksiteNode());
        }
        if (newWorksiteNode != null) {
            this.getChildren().add((Object)newWorksiteNode);
        }
        super.setWorksiteNode(newWorksiteNode);
    }

    @Override
    public ResultsListNode getResultsListNode() {
        if (super.getResultsListNode() == null) {
            this.resultsListNode = ApogyCoreFactory.eINSTANCE.createResultsListNode();
            this.resultsListNode.setDescription("Results" + this.getNodeId());
            this.resultsListNode.setNodeId("RESULTS");
            this.getReferencedChildren().add((Object)this.resultsListNode);
            this.resultsListNode.setParent((Node)this);
        }
        return super.getResultsListNode();
    }

    @Override
    public ApogySystemAPIsNode getApogySystemAPIsNode() {
        if (super.getApogySystemAPIsNode() == null) {
            this.apogySystemAPIsNode = ApogyCoreTopologyFactory.eINSTANCE.createApogySystemAPIsNode();
            this.apogySystemAPIsNode.setNodeId("APOGY_SYSTEMS");
            this.apogySystemAPIsNode.setDescription("Root node of all Apogy Systems topologies.");
            this.getChildren().add((Object)this.apogySystemAPIsNode);
            this.apogySystemAPIsNode.setApogyEnvironment(this.getApogyEnvironment());
        }
        return super.getApogySystemAPIsNode();
    }

    @Override
    public void dispose() {
        this.setApogyEnvironment(null);
        this.getWorksiteNode().setWorksite(null);
        this.setWorksiteNode(null);
        this.getResultsListNode().setResultsList(null);
        this.getApogySystemAPIsNode().setApogyEnvironment(null);
        this.getChildren().clear();
    }

    private void updateApogyEnvironment(ApogyEnvironment oldApogyEnvironment, ApogyEnvironment newApogyEnvironment) {
        OperationCallResultsList oldResultsList = null;
        OperationCallResultsList newResultsList = null;
        AbstractWorksite oldWorksite = null;
        AbstractWorksite newWorksite = null;
        if (oldApogyEnvironment != null) {
            oldApogyEnvironment.eAdapters().remove((Object)this.getAdapter());
            oldWorksite = oldApogyEnvironment.getActiveWorksite();
            if (oldApogyEnvironment.getActiveContext() != null && oldApogyEnvironment.getActiveContext().getDataProductsList() != null) {
                oldResultsList = oldApogyEnvironment.getActiveContext().getDataProductsList().getOperationCallResultsList();
            }
        }
        if (newApogyEnvironment != null) {
            if (newApogyEnvironment.getName() != null) {
                this.setNodeId(newApogyEnvironment.getName());
            }
            this.setDescription("Apogy Environment Node");
            this.setNodeId("APOGY_ENVIRONMENT");
            newWorksite = newApogyEnvironment.getActiveWorksite();
            newApogyEnvironment.eAdapters().add((Object)this.getAdapter());
            if (newApogyEnvironment.getActiveContext() != null) {
                newResultsList = newApogyEnvironment.getActiveContext().getDataProductsList().getOperationCallResultsList();
            }
        }
        this.updateResultLists((ResultsList)oldResultsList, (ResultsList)newResultsList);
        this.updateWorksite(oldWorksite, newWorksite);
        this.updateSystems(oldApogyEnvironment, newApogyEnvironment);
    }

    private void updateContext(Context oldContext, Context newContext) {
        OperationCallResultsList oldResultsList = null;
        OperationCallResultsList newResultsList = null;
        if (oldContext != null) {
            oldContext.eAdapters().remove((Object)this.getAdapter());
            if (oldContext.getDataProductsList() != null) {
                oldResultsList = oldContext.getDataProductsList().getOperationCallResultsList();
            }
        }
        if (newContext != null) {
            newContext.eAdapters().add((Object)this.getAdapter());
            if (newContext.getDataProductsList() != null) {
                newResultsList = newContext.getDataProductsList().getOperationCallResultsList();
            }
        }
        this.updateResultLists((ResultsList)oldResultsList, (ResultsList)newResultsList);
    }

    private void updateSystems(ApogyEnvironment oldApogyEnvironment, ApogyEnvironment newApogyEnvironment) {
        this.getApogySystemAPIsNode().setApogyEnvironment(newApogyEnvironment);
    }

    private void updateResultLists(ResultsList oldResultsList, ResultsList newResultsList) {
        if (oldResultsList != null) {
            oldResultsList.eAdapters().remove((Object)this.getAdapter());
        }
        if (newResultsList != null) {
            newResultsList.eAdapters().add((Object)this.getAdapter());
        }
        this.getResultsListNode().setResultsList(newResultsList);
    }

    private void updateWorksite(AbstractWorksite oldWorksite, AbstractWorksite newWorksite) {
        if (newWorksite instanceof Worksite) {
            Worksite worksite = (Worksite)newWorksite;
            this.setWorksiteNode(worksite.getWorksiteNode());
        } else {
            this.setWorksiteNode(null);
        }
    }

    protected Adapter getAdapter() {
        if (this.adapter == null) {
            this.adapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    super.notifyChanged(msg);
                    if (msg.getNotifier() instanceof ApogyEnvironment) {
                        if (msg.getFeatureID(ApogyEnvironment.class) == 7) {
                            Context oldContext = (Context)msg.getOldValue();
                            Context newContext = (Context)msg.getOldValue();
                            ApogyEnvironmentNodeCustomImpl.this.updateContext(oldContext, newContext);
                        } else if (msg.getFeatureID(ApogyEnvironment.class) == 10) {
                            AbstractWorksite oldWorksite = (AbstractWorksite)msg.getOldValue();
                            AbstractWorksite newWorksite = (AbstractWorksite)msg.getNewValue();
                            ApogyEnvironmentNodeCustomImpl.this.updateWorksite(oldWorksite, newWorksite);
                        }
                    } else if (msg.getNotifier() instanceof Context && msg.getFeatureID(Context.class) == 6) {
                        ResultsList oldResultsList = (ResultsList)msg.getOldValue();
                        ResultsList newResultsList = (ResultsList)msg.getNewValue();
                        ApogyEnvironmentNodeCustomImpl.this.updateResultLists(oldResultsList, newResultsList);
                    }
                }
            };
        }
        return this.adapter;
    }
}

