/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.examples.camera.apogy.impl;

import javax.vecmath.Matrix4d;
import org.eclipse.apogy.addons.sensors.fov.ApogyAddonsSensorsFOVFacade;
import org.eclipse.apogy.common.math.ApogyCommonMathFacade;
import org.eclipse.apogy.common.math.Matrix4x4;
import org.eclipse.apogy.common.topology.ApogyCommonTopologyFacade;
import org.eclipse.apogy.common.topology.Node;
import org.eclipse.apogy.core.invocator.AbstractInitializationData;
import org.eclipse.apogy.core.invocator.OperationCall;
import org.eclipse.apogy.examples.camera.Camera;
import org.eclipse.apogy.examples.camera.apogy.ApogyExamplesCameraApogyFactory;
import org.eclipse.apogy.examples.camera.apogy.CameraData;
import org.eclipse.apogy.examples.camera.apogy.impl.CameraApogySystemApiAdapterImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CameraApogySystemApiAdapterCustomImpl
extends CameraApogySystemApiAdapterImpl {
    private static final Logger Logger = LoggerFactory.getLogger(CameraApogySystemApiAdapterImpl.class);

    protected Camera getCamera() {
        return (Camera)this.getInstance();
    }

    public AbstractInitializationData createInitializationData() {
        return ApogyExamplesCameraApogyFactory.eINSTANCE.createCameraData();
    }

    public void apply(AbstractInitializationData initializationData) {
        super.apply(initializationData);
        if (initializationData instanceof CameraData) {
            CameraData cameraData = (CameraData)initializationData;
            if (cameraData.isInitialized()) {
                if (!this.getCamera().isInitialized()) {
                    this.getCamera().init();
                }
                this.getCamera().commandZoom(cameraData.getZoom());
                if (cameraData.getFov() != null) {
                    this.getCamera().setFov(ApogyAddonsSensorsFOVFacade.INSTANCE.createRectangularFrustrumFieldOfView(cameraData.getFov()));
                } else {
                    this.getCamera().setFov(null);
                }
            } else if (this.getCamera().isInitialized()) {
                String message = "The given initialization data cannot be applied to this camera; the given init data says that the camera should not be initialized, when it already is in that state.";
                throw new RuntimeException(message);
            }
        }
    }

    public void collect(AbstractInitializationData initializationData) {
        super.collect(initializationData);
        if (initializationData instanceof CameraData) {
            CameraData cameraData = (CameraData)initializationData;
            if (this.getCamera().getFov() != null) {
                cameraData.setFov(ApogyAddonsSensorsFOVFacade.INSTANCE.createRectangularFrustrumFieldOfView(this.getCamera().getFov()));
            } else {
                cameraData.setFov(null);
            }
            cameraData.setZoom(this.getCamera().getCurrentZoom());
            cameraData.setInitialized(this.getCamera().isInitialized());
        }
    }

    public Matrix4x4 createResultMatrix(OperationCall operationCall) {
        if (operationCall.getEOperation().getOperationID() == 2) {
            Node tip = (Node)ApogyCommonTopologyFacade.INSTANCE.findNodesByID("CAMERA_SYM_SYS_BODY_TO_LENS", this.getApogySystem().getTopologyRoot().getOriginNode()).get(0);
            Node root = (Node)ApogyCommonTopologyFacade.INSTANCE.findNodesByID("CAMERA_SYM_SYS_ROOT", this.getApogySystem().getTopologyRoot().getOriginNode()).get(0);
            Matrix4d matrix4d = ApogyCommonTopologyFacade.INSTANCE.expressInFrame(tip, root);
            return ApogyCommonMathFacade.INSTANCE.createMatrix4x4(matrix4d);
        }
        return super.createResultMatrix(operationCall);
    }

    public void dispose() {
        try {
            if (this.getCamera().isStreamingEnabled()) {
                this.getCamera().commandStreaming(false);
            }
        }
        catch (Exception e) {
            Logger.error(e.getMessage(), (Throwable)e);
        }
        super.dispose();
    }
}

