/*
 * Decompiled with CFR 0.152.
 */
package org.ros.internal.node.service;

import java.util.Queue;
import java.util.concurrent.ExecutorService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.MessageEvent;
import org.ros.internal.node.service.ServiceClientHandshake;
import org.ros.internal.node.service.ServiceResponseDecoder;
import org.ros.internal.node.service.ServiceResponseHandler;
import org.ros.internal.transport.BaseClientHandshakeHandler;
import org.ros.internal.transport.ConnectionHeader;
import org.ros.message.MessageDeserializer;
import org.ros.node.service.ServiceResponseListener;

class ServiceClientHandshakeHandler<T, S>
extends BaseClientHandshakeHandler {
    private static final Log log = LogFactory.getLog(ServiceClientHandshakeHandler.class);
    private final Queue<ServiceResponseListener<S>> responseListeners;
    private final MessageDeserializer<S> deserializer;
    private final ExecutorService executorService;

    public ServiceClientHandshakeHandler(ConnectionHeader outgoingConnectionHeader, Queue<ServiceResponseListener<S>> responseListeners, MessageDeserializer<S> deserializer, ExecutorService executorService) {
        super(new ServiceClientHandshake(outgoingConnectionHeader), executorService);
        this.responseListeners = responseListeners;
        this.deserializer = deserializer;
        this.executorService = executorService;
    }

    @Override
    protected void onSuccess(ConnectionHeader incommingConnectionHeader, ChannelHandlerContext ctx, MessageEvent e) {
        ChannelPipeline pipeline = e.getChannel().getPipeline();
        pipeline.remove("LengthFieldBasedFrameDecoder");
        pipeline.remove((ChannelHandler)this);
        pipeline.addLast("ResponseDecoder", new ServiceResponseDecoder());
        pipeline.addLast("ResponseHandler", new ServiceResponseHandler(this.responseListeners, this.deserializer, this.executorService));
    }

    @Override
    protected void onFailure(String errorMessage, ChannelHandlerContext ctx, MessageEvent e) {
        log.error((Object)("Service client handshake failed: " + errorMessage));
        e.getChannel().close();
    }

    @Override
    public String getName() {
        return "ServiceClientHandshakeHandler";
    }
}

