/*
 * Decompiled with CFR 0.152.
 */
package org.ros.internal.node.service;

import com.google.common.base.Preconditions;
import java.nio.charset.Charset;
import java.util.Queue;
import java.util.concurrent.ExecutorService;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.ros.exception.RemoteException;
import org.ros.internal.node.response.StatusCode;
import org.ros.internal.node.service.ServiceServerResponse;
import org.ros.message.MessageDeserializer;
import org.ros.node.service.ServiceResponseListener;

class ServiceResponseHandler<ResponseType>
extends SimpleChannelHandler {
    private final Queue<ServiceResponseListener<ResponseType>> responseListeners;
    private final MessageDeserializer<ResponseType> deserializer;
    private final ExecutorService executorService;

    public ServiceResponseHandler(Queue<ServiceResponseListener<ResponseType>> messageListeners, MessageDeserializer<ResponseType> deserializer, ExecutorService executorService) {
        this.responseListeners = messageListeners;
        this.deserializer = deserializer;
        this.executorService = executorService;
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        final ServiceResponseListener<ResponseType> listener = this.responseListeners.poll();
        Preconditions.checkNotNull(listener, (Object)"No listener for incoming service response.");
        final ServiceServerResponse response = (ServiceServerResponse)e.getMessage();
        final ChannelBuffer buffer = response.getMessage();
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                if (response.getErrorCode() == 1) {
                    listener.onSuccess(ServiceResponseHandler.this.deserializer.deserialize(buffer));
                } else {
                    String message = Charset.forName("US-ASCII").decode(buffer.toByteBuffer()).toString();
                    listener.onFailure(new RemoteException(StatusCode.ERROR, message));
                }
            }
        });
    }
}

