/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.ros.utilities;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.ros.internal.loader.CommandLineLoader;
import org.ros.namespace.GraphName;
import org.ros.node.AbstractNodeMain;
import org.ros.node.ConnectedNode;
import org.ros.node.DefaultNodeMainExecutor;
import org.ros.node.NodeConfiguration;
import org.ros.node.NodeMain;
import org.ros.node.NodeMainExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ROSNodeMain
extends AbstractNodeMain {
    private static final Logger Logger = LoggerFactory.getLogger(ROSNodeMain.class);
    private final String nodeName;
    private final List<NodeStartedListener> nodeStartedListeners = new ArrayList<NodeStartedListener>();

    public ROSNodeMain(String nodeName) {
        this.nodeName = nodeName;
    }

    public GraphName getDefaultNodeName() {
        return GraphName.of((String)this.nodeName);
    }

    public void start() {
        try {
            CommandLineLoader loader = new CommandLineLoader((List)Lists.newArrayList((Object[])new String[]{((Object)((Object)this)).getClass().getName()}));
            NodeConfiguration nodeConfiguration = loader.build();
            ROSNodeMain nodeMain = null;
            nodeMain = this;
            Preconditions.checkState((nodeMain != null ? 1 : 0) != 0);
            NodeMainExecutor nodeMainExecutor = DefaultNodeMainExecutor.newDefault();
            nodeMainExecutor.execute((NodeMain)nodeMain, nodeConfiguration);
        }
        catch (Exception e) {
            Logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void onStart(ConnectedNode connectedNode) {
        Logger.info("Node connected");
        for (NodeStartedListener l : this.nodeStartedListeners) {
            l.nodeStarted(connectedNode);
        }
    }

    public void addNodeStartedListener(NodeStartedListener l) {
        this.nodeStartedListeners.add(l);
    }

    public static interface NodeStartedListener {
        public void nodeStarted(ConnectedNode var1);
    }
}

