/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.converters.ui.composites;

import java.util.List;
import org.eclipse.apogy.common.converters.ApogyCommonConvertersGraphsFacade;
import org.eclipse.apogy.common.converters.ConverterEdge;
import org.eclipse.apogy.common.converters.IConverter;
import org.eclipse.apogy.common.converters.ui.composites.ConvertersUIConstants;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.wb.swt.TableViewerColumnSorter;
import org.jgrapht.graph.SimpleDirectedWeightedGraph;

public class ConverterGraphComposite
extends Composite {
    private Table table;
    private TableViewer tableViewer;
    private IContentProvider contentProvider;
    private ConvertersUIConstants.ClassNameDisplayMode classNameDisplayMode = ConvertersUIConstants.ClassNameDisplayMode.SIMPLE_CLASS_NAME;
    private SimpleDirectedWeightedGraph<Class<?>, ConverterEdge> convertersGraph = null;
    private ITableLabelProvider labelProvider;
    private Label dummyLabel;

    public ConverterGraphComposite(Composite parent, int style, SimpleDirectedWeightedGraph<Class<?>, ConverterEdge> graph) {
        this(parent, style);
        this.setConvertersGraph(graph);
    }

    public ConverterGraphComposite(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout(256));
        this.tableViewer = new TableViewer((Composite)this, 67584);
        this.tableViewer.setUseHashlookup(true);
        this.table = this.tableViewer.getTable();
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        TableViewerColumn tableViewerColumn = new TableViewerColumn(this.tableViewer, 0);
        new TableViewerColumnSorter(tableViewerColumn){

            @Override
            protected int doCompare(Viewer viewer, Object e1, Object e2) {
                ITableLabelProvider labelProvider = (ITableLabelProvider)ConverterGraphComposite.this.tableViewer.getLabelProvider();
                String s1 = labelProvider.getColumnText(e1, 0);
                String s2 = labelProvider.getColumnText(e2, 0);
                return s1.compareTo(s2);
            }

            @Override
            protected Object getValue(Object o) {
                return super.getValue(o);
            }
        };
        TableColumn tblclmnNewColumn_1 = tableViewerColumn.getColumn();
        tblclmnNewColumn_1.setWidth(100);
        tblclmnNewColumn_1.setText("Input Type");
        TableViewerColumn tableViewerColumn_1 = new TableViewerColumn(this.tableViewer, 0);
        new TableViewerColumnSorter(tableViewerColumn_1){

            @Override
            protected int doCompare(Viewer viewer, Object e1, Object e2) {
                ITableLabelProvider labelProvider = (ITableLabelProvider)ConverterGraphComposite.this.tableViewer.getLabelProvider();
                String s1 = labelProvider.getColumnText(e1, 1);
                String s2 = labelProvider.getColumnText(e2, 1);
                return s1.compareTo(s2);
            }

            @Override
            protected Object getValue(Object o) {
                return super.getValue(o);
            }
        };
        TableColumn tblclmnNewColumn = tableViewerColumn_1.getColumn();
        tblclmnNewColumn.setWidth(100);
        tblclmnNewColumn.setText("Output Type");
        TableViewerColumn tableViewerColumn_2 = new TableViewerColumn(this.tableViewer, 0);
        new TableViewerColumnSorter(tableViewerColumn_2){

            @Override
            protected int doCompare(Viewer viewer, Object e1, Object e2) {
                ITableLabelProvider labelProvider = (ITableLabelProvider)ConverterGraphComposite.this.tableViewer.getLabelProvider();
                String s1 = labelProvider.getColumnText(e1, 2);
                String s2 = labelProvider.getColumnText(e2, 2);
                return s1.compareTo(s2);
            }

            @Override
            protected Object getValue(Object o) {
                return super.getValue(o);
            }
        };
        TableColumn tblclmnNewColumn_2 = tableViewerColumn_2.getColumn();
        tblclmnNewColumn_2.setMoveable(true);
        tblclmnNewColumn_2.setWidth(100);
        tblclmnNewColumn_2.setText("Converter");
        this.tableViewer.setContentProvider(this.getContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)this.getTableLabelProvider());
    }

    public ConvertersUIConstants.ClassNameDisplayMode getClassNameDisplayMode() {
        return this.classNameDisplayMode;
    }

    public void setClassNameDisplayMode(ConvertersUIConstants.ClassNameDisplayMode classNameDisplayMode) {
        this.classNameDisplayMode = classNameDisplayMode;
        this.updateColumnsWidth();
    }

    public TableViewer getTableViewer() {
        return this.tableViewer;
    }

    public SimpleDirectedWeightedGraph<Class<?>, ConverterEdge> getConvertersGraph() {
        return this.convertersGraph;
    }

    public void setConvertersGraph(SimpleDirectedWeightedGraph<Class<?>, ConverterEdge> convertersGraph) {
        this.convertersGraph = convertersGraph;
        if (this.convertersGraph != null) {
            this.getTableViewer().setInput((Object)ApogyCommonConvertersGraphsFacade.INSTANCE.getAllNonTypeCastConverters(this.convertersGraph));
            this.updateColumnsWidth();
        } else {
            this.getTableViewer().setInput(null);
        }
    }

    private ITableLabelProvider getTableLabelProvider() {
        if (this.labelProvider == null) {
            this.labelProvider = new ITableLabelProvider(){

                public void addListener(ILabelProviderListener listener) {
                }

                public void dispose() {
                }

                public boolean isLabelProperty(Object element, String property) {
                    return false;
                }

                public void removeListener(ILabelProviderListener listener) {
                }

                public Image getColumnImage(Object element, int columnIndex) {
                    return null;
                }

                public String getColumnText(Object element, int columnIndex) {
                    IConverter converter = (IConverter)element;
                    switch (ConverterGraphComposite.this.classNameDisplayMode) {
                        case FULLY_QUALIFIED_CLASS_NAME: {
                            switch (columnIndex) {
                                case 0: {
                                    return converter.getInputType().getName();
                                }
                                case 1: {
                                    return converter.getOutputType().getName();
                                }
                                case 2: {
                                    return converter.getClass().getName();
                                }
                            }
                            return "?";
                        }
                        case SIMPLE_CLASS_NAME: {
                            switch (columnIndex) {
                                case 0: {
                                    return converter.getInputType().getSimpleName();
                                }
                                case 1: {
                                    return converter.getOutputType().getSimpleName();
                                }
                                case 2: {
                                    return converter.getClass().getSimpleName();
                                }
                            }
                            return "?";
                        }
                    }
                    return "?";
                }
            };
        }
        return this.labelProvider;
    }

    private void updateColumnsWidth() {
        TableColumn[] columns = this.getTableViewer().getTable().getColumns();
        int i = 0;
        while (i < columns.length) {
            int columnWidth = this.getMaximumColumnWidth(i) + 1;
            columns[i].setWidth(columnWidth);
            ++i;
        }
        this.getTableViewer().refresh();
    }

    private int getMaximumColumnWidth(int columnIndex) {
        try {
            List converters = (List)this.getTableViewer().getInput();
            int maximumColumnWidth = 0;
            for (IConverter converter : converters) {
                String columnString = this.getTableLabelProvider().getColumnText((Object)converter, columnIndex);
                this.getDummyLabel().setText(" " + columnString + " ");
                Point p = this.getDummyLabel().computeSize(-1, -1);
                if (p.x <= maximumColumnWidth) continue;
                maximumColumnWidth = p.x;
            }
            return maximumColumnWidth;
        }
        catch (Exception e) {
            return 0;
        }
    }

    private Label getDummyLabel() {
        if (this.dummyLabel == null) {
            this.dummyLabel = new Label((Composite)this.getTableViewer().getTable(), 0);
            this.dummyLabel.setVisible(false);
        }
        return this.dummyLabel;
    }

    private IContentProvider getContentProvider() {
        if (this.contentProvider == null) {
            this.contentProvider = new IStructuredContentProvider(){

                public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                }

                public void dispose() {
                }

                public Object[] getElements(Object inputElement) {
                    List list = (List)inputElement;
                    return list.toArray();
                }
            };
        }
        return this.contentProvider;
    }
}

