/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.emf.ui.emfforms.renderers;

import java.util.ArrayList;
import java.util.TimeZone;
import javax.inject.Inject;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFacade;
import org.eclipse.apogy.common.emf.ui.emfforms.ApogyCommonEMFUiEMFFormsFacade;
import org.eclipse.apogy.common.emf.ui.emfforms.PropertyType;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.core.swt.SimpleControlSWTControlSWTRenderer;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.model.VFeaturePathDomainModelReference;
import org.eclipse.emf.ecp.view.template.model.VTViewTemplateProvider;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.EMFFormsDatabinding;
import org.eclipse.emfforms.spi.core.services.label.EMFFormsLabelProvider;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeZoneControlSWTRenderer
extends SimpleControlSWTControlSWTRenderer {
    private static final Logger Logger = LoggerFactory.getLogger(TimeZoneControlSWTRenderer.class);
    private ComboViewer comboViewer;
    private Binding valueBinding;
    private Binding toolTipBinding;

    @Inject
    public TimeZoneControlSWTRenderer(VControl vElement, ViewModelContext viewContext, ReportService reportService, EMFFormsDatabinding emfFormsDatabinding, EMFFormsLabelProvider emfFormsLabelProvider, VTViewTemplateProvider vtViewTemplateProvider) {
        super(vElement, viewContext, reportService, emfFormsDatabinding, emfFormsLabelProvider, vtViewTemplateProvider);
    }

    protected Binding[] createBindings(Control control) throws DatabindingFailedException {
        Binding[] bindings = new Binding[2];
        IViewerObservableValue observeComboSingleSelectionIndexObserveWidget = ViewersObservables.observeSingleSelection((Viewer)this.comboViewer);
        bindings[0] = this.valueBinding = this.getDataBindingContext().bindValue((IObservableValue)observeComboSingleSelectionIndexObserveWidget, this.getModelValue(), null, null);
        ISWTObservableValue textToolTip = WidgetProperties.tooltipText().observe((Widget)this.comboViewer.getCombo());
        bindings[1] = this.toolTipBinding = this.getDataBindingContext().bindValue((IObservableValue)textToolTip, this.getModelValue(), new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE).setConverter((IConverter)new Converter(EObject.class, String.class){

            public Object convert(Object fromObject) {
                String toolTip = ApogyCommonEMFFacade.INSTANCE.getFullDescription(TimeZoneControlSWTRenderer.this.getTypedElement());
                return toolTip;
            }
        }));
        return bindings;
    }

    protected Control createSWTControl(Composite parent) throws DatabindingFailedException {
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)GridLayoutFactory.fillDefaults().margins(0, 0).numColumns(1).create());
        main.setLayoutData((Object)new GridData(4, 1, true, false, 1, 1));
        main.setBackground(parent.getBackground());
        main.setBackgroundMode(2);
        this.comboViewer = this.createCombo(main, 0);
        this.comboViewer.getCombo().setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        return main;
    }

    protected String getUnsetText() {
        return "unset";
    }

    protected UpdateValueStrategy getUpdateTextValueStrategy() {
        return new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE).setConverter((IConverter)new Converter(this.getTypedElement().getEType().getInstanceClass(), String.class){

            public Object convert(Object fromObject) {
                return "";
            }
        });
    }

    protected UpdateValueStrategy getUpdateModelValueStrategy() {
        PropertyType propertyType = this.getPropertyType(this.getVElement());
        if (propertyType == PropertyType.EDITABLE) {
            return new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE).setConverter((IConverter)new Converter(TimeZone.class, this.getTypedElement().getEType().getInstanceClass()){

                public Object convert(Object fromObject) {
                    return (TimeZone)fromObject;
                }
            });
        }
        return new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER);
    }

    protected PropertyType getPropertyType(VElement vElement) {
        VControl vControl;
        PropertyType propertyType = PropertyType.EDITABLE;
        if (vElement instanceof VControl && (vControl = (VControl)vElement).getDomainModelReference() instanceof VFeaturePathDomainModelReference) {
            VFeaturePathDomainModelReference vFeaturePathDomainModelReference = (VFeaturePathDomainModelReference)vControl.getDomainModelReference();
            EStructuralFeature feature = vFeaturePathDomainModelReference.getDomainModelEFeature();
            if (feature.isDerived() || !feature.isChangeable()) {
                propertyType = PropertyType.READONLY;
            } else if (feature instanceof EAttribute) {
                propertyType = ApogyCommonEMFUiEMFFormsFacade.INSTANCE.getPropertyType((EAttribute)feature);
            } else if (feature instanceof EReference) {
                propertyType = ApogyCommonEMFUiEMFFormsFacade.INSTANCE.getPropertyType((EReference)feature);
            }
        }
        return propertyType;
    }

    protected ETypedElement getTypedElement() {
        try {
            return (ETypedElement)this.getModelValue().getValueType();
        }
        catch (DatabindingFailedException e) {
            Logger.error("Error getting the typedElement");
            return null;
        }
    }

    private ComboViewer createCombo(Composite parent, int style) {
        ComboViewer comboViewer = new ComboViewer(parent, 2052);
        comboViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        comboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof TimeZone) {
                    TimeZone timeZone = (TimeZone)element;
                    return timeZone.getID();
                }
                return "?";
            }
        });
        comboViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                TimeZone timeZone1 = (TimeZone)e1;
                TimeZone timeZone2 = (TimeZone)e2;
                if (timeZone1.getID().length() != timeZone2.getID().length()) {
                    return timeZone1.getID().length() - timeZone2.getID().length();
                }
                return timeZone1.getID().compareTo(timeZone2.getID());
            }
        });
        String[] zoneIds = TimeZone.getAvailableIDs();
        ArrayList<TimeZone> availableTimeZones = new ArrayList<TimeZone>();
        int i = 0;
        while (i < zoneIds.length) {
            String zoneID = zoneIds[i];
            try {
                TimeZone timeZone = TimeZone.getTimeZone(zoneID);
                if (timeZone != null) {
                    availableTimeZones.add(timeZone);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
        comboViewer.setInput((Object)availableTimeZones.toArray());
        return comboViewer;
    }
}

