/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.geometry.data3d.xyz.ui.adapters;

import java.io.IOException;
import org.eclipse.apogy.common.geometry.data3d.CartesianCoordinatesSet;
import org.eclipse.apogy.common.geometry.data3d.Data3DIO;
import org.eclipse.apogy.common.topology.AggregateGroupNode;
import org.eclipse.apogy.common.topology.ApogyCommonTopologyFacade;
import org.eclipse.apogy.common.topology.ApogyCommonTopologyFactory;
import org.eclipse.apogy.common.topology.ContentNode;
import org.eclipse.apogy.common.topology.Node;
import org.eclipse.apogy.common.topology.ui.ApogyCommonTopologyUIFactory;
import org.eclipse.apogy.common.topology.ui.GraphicsContext;
import org.eclipse.apogy.common.topology.ui.GraphicsContextAdapter;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphicsContextXYZAdapter
implements GraphicsContextAdapter {
    private static final Logger Logger = LoggerFactory.getLogger(GraphicsContextXYZAdapter.class);
    public static final String SUPPORTED_EXTENSION = "xyz";

    public boolean isAdapterFor(Object obj) {
        boolean ok = false;
        if (obj instanceof IFile) {
            IFile file = (IFile)obj;
            ok = file.getName().endsWith(".xyz");
        }
        return ok;
    }

    public GraphicsContext getAdapter(Object obj, Object context) {
        GraphicsContext ctx = null;
        if (this.isAdapterFor(obj)) {
            NullProgressMonitor monitor = new NullProgressMonitor();
            if (context instanceof IProgressMonitor) {
                monitor = (IProgressMonitor)context;
            }
            IFile file = (IFile)obj;
            try {
                CartesianCoordinatesSet points = Data3DIO.INSTANCE.loadXYZ(file.getLocation().toOSString());
                AggregateGroupNode root = ApogyCommonTopologyFactory.eINSTANCE.createAggregateGroupNode();
                ContentNode content = ApogyCommonTopologyFacade.INSTANCE.createContentNode((Object)points);
                root.getChildren().add((Object)content);
                ctx = ApogyCommonTopologyUIFactory.eINSTANCE.createGraphicsContext();
                ctx.setTopology((Node)root);
            }
            catch (IOException e) {
                Logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return ctx;
    }

    public Class<?> getAdaptedClass() {
        return IFile.class;
    }
}

