/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.topology.addons.primitives.ui.wizards;

import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.math.ApogyCommonMathFactory;
import org.eclipse.apogy.common.math.ApogyCommonMathPackage;
import org.eclipse.apogy.common.math.Tuple3d;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ColorWizardPage
extends WizardPage {
    private static final String WIZARD_PAGE_ID = "org.eclipse.apogy.common.topology.addons.primitives.ui.wizards.ColorWizardPage";
    private final Tuple3d color;

    public ColorWizardPage(Tuple3d color) {
        super(WIZARD_PAGE_ID);
        this.color = color;
        this.setTitle("Color");
        this.setDescription("Select the color.");
    }

    public void createControl(Composite parent) {
        Composite top = new Composite(parent, 0);
        top.setLayout((Layout)new GridLayout(2, false));
        this.setControl((Control)top);
        Label lblColor = new Label(top, 0);
        lblColor.setText("Color:");
        final ColorSelector colorSelector = new ColorSelector(top);
        colorSelector.getButton().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                RGB rgb = colorSelector.getColorValue();
                Tuple3d tmp = ColorWizardPage.this.fromRGB(rgb);
                if (ColorWizardPage.this.color != null) {
                    ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)ColorWizardPage.this.color, (EStructuralFeature)ApogyCommonMathPackage.Literals.TUPLE3D__X, (Object)tmp.getX(), true);
                    ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)ColorWizardPage.this.color, (EStructuralFeature)ApogyCommonMathPackage.Literals.TUPLE3D__Y, (Object)tmp.getY(), true);
                    ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)ColorWizardPage.this.color, (EStructuralFeature)ApogyCommonMathPackage.Literals.TUPLE3D__Z, (Object)tmp.getZ(), true);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    protected Tuple3d fromRGB(RGB rgb) {
        Tuple3d color = ApogyCommonMathFactory.eINSTANCE.createTuple3d();
        color.setX(1.0 * (double)rgb.red / 255.0);
        color.setY(1.0 * (double)rgb.green / 255.0);
        color.setZ(1.0 * (double)rgb.blue / 255.0);
        return color;
    }

    protected RGB fromTuple3d(Tuple3d tuple3d) {
        int blue;
        int green;
        int red = (int)Math.round(tuple3d.getX() * 255.0);
        if (red > 255) {
            red = 255;
        }
        if ((green = (int)Math.round(tuple3d.getY() * 255.0)) > 255) {
            green = 255;
        }
        if ((blue = (int)Math.round(tuple3d.getZ() * 255.0)) > 255) {
            blue = 255;
        }
        return new RGB(red, green, blue);
    }
}

