/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.topology.ui.jme3;

import com.jme3.math.Quaternion;
import com.jme3.math.Transform;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Spatial;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.vecmath.Point3d;
import org.eclipse.apogy.common.math.ApogyCommonMathFactory;
import org.eclipse.apogy.common.math.Tuple3d;
import org.eclipse.apogy.common.topology.AbstractViewPoint;
import org.eclipse.apogy.common.topology.Node;
import org.eclipse.apogy.common.topology.ui.ApogyCommonTopologyUIFacade;
import org.eclipse.apogy.common.topology.ui.NodePresentation;
import org.eclipse.apogy.common.topology.ui.SceneObject;
import org.eclipse.apogy.common.topology.ui.TopologyPresentationSet;
import org.eclipse.apogy.common.topology.ui.jme3.Activator;
import org.eclipse.apogy.common.topology.ui.jme3.JME3Adapter;
import org.eclipse.apogy.common.topology.ui.jme3.JME3Application;
import org.eclipse.apogy.common.topology.ui.jme3.JME3SceneObject;
import org.eclipse.apogy.common.topology.ui.viewer.IRenderEngineDelegate;
import org.eclipse.apogy.common.topology.ui.viewer.ITopologyViewer;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JME3RenderEngineDelegate
implements IRenderEngineDelegate {
    private static final Logger Logger = LoggerFactory.getLogger(JME3RenderEngineDelegate.class);
    private ITopologyViewer topologyViewer;
    private JME3Application jme3Application = null;
    private Map<Node, JME3SceneObject> nodeToJME3SceneObjectMap = null;
    private Map<JME3SceneObject, Node> jme3SceneObjectToNodeMap = null;
    private AbstractViewPoint activeAbstractViewPoint;
    private Adapter activeViewPointAdapter;

    public Composite createRenderComposite(ITopologyViewer topologyViewer, Composite parent) {
        this.topologyViewer = topologyViewer;
        Composite top = new Composite(parent, 0);
        top.setLayout((Layout)new FillLayout());
        this.jme3Application = this.createJME3Application(top);
        return top;
    }

    public void add(NodePresentation nodePresentation) {
        if (nodePresentation != null && nodePresentation.getNode() != null) {
            Node node = nodePresentation.getNode();
            JME3Adapter jme3Adapter = (JME3Adapter)Activator.getDefault().getJME3AdapterFactory().getAdapterFor((Object)node);
            if (jme3Adapter != null) {
                JME3SceneObject jme3SceneObject = (JME3SceneObject)jme3Adapter.getAdapter(nodePresentation.getNode(), this);
                if (jme3SceneObject != null) {
                    nodePresentation.setSceneObject((SceneObject)jme3SceneObject);
                    this.getNodeToJME3SceneObjectMap().put(node, jme3SceneObject);
                    this.getJME3SceneObjectToNodeMap().put(jme3SceneObject, node);
                    try {
                        final JME3SceneObject parent = this.getSceneObject(node.getParent());
                        final JME3SceneObject child = jme3SceneObject;
                        this.jme3Application.enqueue(new Callable<Object>(){

                            @Override
                            public Object call() throws Exception {
                                if (parent != null) {
                                    Logger.debug("Added " + child);
                                    parent.getAttachmentNode().attachChild((Spatial)child.getRoot());
                                } else {
                                    Logger.debug("Added at ROOT " + child);
                                    JME3RenderEngineDelegate.this.jme3Application.getSceneRoot().attachChild((Spatial)child.getRoot());
                                }
                                return null;
                            }
                        });
                    }
                    catch (Throwable t) {
                        Logger.error(t.getMessage(), t);
                    }
                }
            } else {
                Logger.warn("Could not find JME3Adapter for Node <" + nodePresentation.getNode() + ">.");
            }
        }
    }

    public synchronized void add(List<NodePresentation> nodePresentationList) {
        final HashMap<NodePresentation, JME3SceneObject> toAdd = new HashMap<NodePresentation, JME3SceneObject>();
        for (NodePresentation nodePresentation : nodePresentationList) {
            JME3SceneObject jme3SceneObject;
            Node node = nodePresentation.getNode();
            JME3Adapter jme3Adapter = (JME3Adapter)Activator.getDefault().getJME3AdapterFactory().getAdapterFor((Object)node);
            if (jme3Adapter == null || (jme3SceneObject = (JME3SceneObject)jme3Adapter.getAdapter(nodePresentation.getNode(), this)) == null) continue;
            nodePresentation.setSceneObject((SceneObject)jme3SceneObject);
            toAdd.put(nodePresentation, jme3SceneObject);
            this.getNodeToJME3SceneObjectMap().put(node, jme3SceneObject);
            this.getJME3SceneObjectToNodeMap().put(jme3SceneObject, node);
        }
        try {
            this.jme3Application.enqueue(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    for (NodePresentation nodePresentation : toAdd.keySet()) {
                        Node node = nodePresentation.getNode();
                        JME3SceneObject child = (JME3SceneObject)toAdd.get(nodePresentation);
                        JME3SceneObject parent = JME3RenderEngineDelegate.this.getSceneObject(node.getParent());
                        if (parent != null) {
                            Logger.debug("Added " + child);
                            parent.getAttachmentNode().attachChild((Spatial)child.getRoot());
                            continue;
                        }
                        Logger.debug("Added at ROOT " + child);
                        JME3RenderEngineDelegate.this.jme3Application.getSceneRoot().attachChild((Spatial)child.getRoot());
                    }
                    return null;
                }
            });
        }
        catch (Throwable t) {
            Logger.error(t.getMessage(), t);
        }
    }

    public void remove(NodePresentation nodePresentation) {
        if (nodePresentation != null) {
            Node node = nodePresentation.getNode();
            JME3SceneObject jme3SceneObject = this.getSceneObject(nodePresentation.getNode());
            if (jme3SceneObject != null) {
                try {
                    Logger.debug("Removing " + jme3SceneObject);
                    jme3SceneObject.dispose();
                    this.getNodeToJME3SceneObjectMap().remove(node);
                    this.getJME3SceneObjectToNodeMap().remove(jme3SceneObject);
                }
                catch (Throwable t) {
                    Logger.error(t.getMessage(), t);
                }
            }
        }
    }

    public synchronized void remove(List<NodePresentation> nodePresentationList) {
        final ArrayList<JME3SceneObject> toRemove = new ArrayList<JME3SceneObject>();
        for (NodePresentation nodePresentation : nodePresentationList) {
            Node node = nodePresentation.getNode();
            JME3SceneObject jme3SceneObject = this.getSceneObject(nodePresentation.getNode());
            if (jme3SceneObject != null) {
                toRemove.add(jme3SceneObject);
                this.getJME3SceneObjectToNodeMap().remove(jme3SceneObject);
            }
            if (node == null) continue;
            this.getNodeToJME3SceneObjectMap().remove(jme3SceneObject);
        }
        Future future = this.jme3Application.enqueue(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                for (JME3SceneObject jme3SceneObject : toRemove) {
                    try {
                        Logger.debug("Removing " + jme3SceneObject);
                        jme3SceneObject.dispose();
                    }
                    catch (Throwable t) {
                        Logger.error(t.getMessage(), t);
                    }
                }
                return Boolean.TRUE;
            }
        });
        try {
            future.get();
        }
        catch (InterruptedException e) {
            Logger.error(e.getMessage(), (Throwable)e);
        }
        catch (ExecutionException e) {
            Logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void setMaximumFrameRate(int maximumFrameRate) {
        this.jme3Application.setMaximumFrameRate(maximumFrameRate);
    }

    public void setAmbientLightEnabled(boolean enable) {
        this.jme3Application.setSkyLightEnabled(enable);
    }

    public void setAmbientLightColor(int red, int green, int blue) {
        this.jme3Application.setSkyLightColor(red, green, blue);
    }

    public void setAmbienbLightDirection(float x, float y, float z) {
        this.jme3Application.setSkyLightDirection(x, y, z);
    }

    public void setAntiAliasing(boolean enable) {
        this.jme3Application.setAntiAliasing(enable);
    }

    public void setShowStatisticsEnabled(boolean enable) {
        this.jme3Application.setShowStatisticsEnabled(enable);
    }

    public void zoomToFit(TopologyPresentationSet topologyPresentationSet) {
        try {
            Tuple3d min = ApogyCommonMathFactory.eINSTANCE.createTuple3d();
            Tuple3d max = ApogyCommonMathFactory.eINSTANCE.createTuple3d();
            ApogyCommonTopologyUIFacade.INSTANCE.findExtent(topologyPresentationSet.getGraphicsContext().getTopology(), topologyPresentationSet, min, max);
            Point3d center = new Point3d((max.getX() + min.getX()) / 2.0, (max.getY() + min.getY()) / 2.0, (max.getZ() + min.getZ()) / 2.0);
            Vector3f centerVector = new Vector3f((float)center.x, (float)center.y, (float)center.z);
            Transform t = new Transform(centerVector, Quaternion.IDENTITY);
            Vector3f minVector = new Vector3f();
            Vector3f maxVector = new Vector3f();
            minVector = t.transformInverseVector(new Vector3f((float)min.getX(), (float)min.getY(), (float)min.getZ()), minVector);
            maxVector = t.transformInverseVector(new Vector3f((float)max.getX(), (float)max.getY(), (float)max.getZ()), maxVector);
            float hFOV = (float)Math.toRadians(45.0) / 2.0f;
            float distanceY = 0.0f;
            distanceY = Math.abs(minVector.getY()) > Math.abs(maxVector.getY()) ? (float)((double)Math.abs(minVector.getY()) / Math.tan(hFOV)) : (float)((double)Math.abs(maxVector.getY()) / Math.tan(hFOV));
            float distanceX = 0.0f;
            distanceX = Math.abs(minVector.getX()) > Math.abs(maxVector.getX()) ? (float)((double)Math.abs(minVector.getX()) / Math.tan(hFOV)) : (float)((double)Math.abs(maxVector.getX()) / Math.tan(hFOV));
            float distance = 0.0f;
            distance = distanceX > distanceY ? distanceX : distanceY;
            Vector3f delta = new Vector3f(0.0f, 0.0f, 1.0f);
            delta = this.jme3Application.getArbitraryViewPointRotation().mult(delta);
            delta.normalizeLocal();
            delta.multLocal(distance);
            delta.negateLocal();
            Vector3f newLocation = centerVector.add(delta);
            if (Float.isNaN(newLocation.x) || Float.isNaN(newLocation.y) || Float.isNaN(newLocation.z)) {
                newLocation.x = 0.0f;
                newLocation.y = 0.0f;
                newLocation.z = 0.0f;
            }
            this.jme3Application.setArbitraryViewPointLocation(newLocation);
        }
        catch (Throwable t) {
            this.jme3Application.setArbitraryViewPointLocation(new Vector3f(0.0f, 0.0f, 0.0f));
        }
    }

    public BufferedImage takeScreenshot() {
        return this.jme3Application.takeScreenshot();
    }

    public void levelViewPoint() {
        this.jme3Application.levelViewPoint();
    }

    public void setHighSpeedMotionEnabled(boolean highSpeedMotionEnabled) {
        this.jme3Application.setHighSpeedMotionEnabled(highSpeedMotionEnabled);
    }

    public void setPickingModeEnabled(boolean pickingModeEnabled) {
        this.jme3Application.setPickingModeEnabled(pickingModeEnabled);
    }

    public void dispose() {
        this.getNodeToJME3SceneObjectMap().clear();
        this.getJME3SceneObjectToNodeMap().clear();
        if (this.activeAbstractViewPoint != null) {
            this.activeAbstractViewPoint.eAdapters().remove((Object)this.getActiveViewPointAdapter());
        }
        this.jme3Application.dispose();
        this.topologyViewer = null;
    }

    public JME3Application getJME3Application() {
        return this.jme3Application;
    }

    public Node getTopologyNode(Geometry geometry) {
        Node node = null;
        ArrayList<JME3SceneObject> sceneObjectList = new ArrayList<JME3SceneObject>(this.getJME3SceneObjectToNodeMap().keySet());
        Iterator it = sceneObjectList.iterator();
        while (node == null && it.hasNext()) {
            JME3SceneObject jme3SceneObject = (JME3SceneObject)it.next();
            if (!jme3SceneObject.getGeometries().contains(geometry)) continue;
            node = jme3SceneObject.getTopologyNode();
        }
        return node;
    }

    public void setActiveViewPoint(AbstractViewPoint abstractViewPoint) {
        if (this.activeAbstractViewPoint != null) {
            this.activeAbstractViewPoint.eAdapters().remove((Object)this.getActiveViewPointAdapter());
        }
        this.activeAbstractViewPoint = abstractViewPoint;
        if (abstractViewPoint != null) {
            this.jme3Application.attachViewPoint(abstractViewPoint);
            abstractViewPoint.eAdapters().add((Object)this.getActiveViewPointAdapter());
        }
    }

    public Node getTopologyNode(Object sceneGraphObject) {
        if (sceneGraphObject instanceof Geometry) {
            return this.getTopologyNode((Geometry)sceneGraphObject);
        }
        return null;
    }

    public ITopologyViewer getTopologyViewer() {
        return this.topologyViewer;
    }

    protected JME3Application createJME3Application(Composite parent) {
        JME3Application app = new JME3Application(parent);
        app.setJMERenderEngineDelegate(this);
        return app;
    }

    protected Map<Node, JME3SceneObject> getNodeToJME3SceneObjectMap() {
        if (this.nodeToJME3SceneObjectMap == null) {
            this.nodeToJME3SceneObjectMap = new HashMap<Node, JME3SceneObject>();
        }
        return this.nodeToJME3SceneObjectMap;
    }

    protected Map<JME3SceneObject, Node> getJME3SceneObjectToNodeMap() {
        if (this.jme3SceneObjectToNodeMap == null) {
            this.jme3SceneObjectToNodeMap = new HashMap<JME3SceneObject, Node>();
        }
        return this.jme3SceneObjectToNodeMap;
    }

    protected JME3SceneObject getSceneObject(Node node) {
        if (node == null) {
            return null;
        }
        return this.getNodeToJME3SceneObjectMap().get(node);
    }

    protected Adapter getActiveViewPointAdapter() {
        if (this.activeViewPointAdapter == null) {
            this.activeViewPointAdapter = new EContentAdapter(){

                public void notifyChanged(Notification msg) {
                    JME3RenderEngineDelegate.this.jme3Application.attachViewPoint(JME3RenderEngineDelegate.this.activeAbstractViewPoint);
                    super.notifyChanged(msg);
                }
            };
        }
        return this.activeViewPointAdapter;
    }
}

