/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.earth.surface.ui.databindings;

import java.text.NumberFormat;
import java.util.Date;
import org.eclipse.apogy.core.environment.earth.GeographicCoordinates;
import org.eclipse.apogy.core.environment.earth.HorizontalCoordinates;
import org.eclipse.apogy.core.environment.earth.surface.AstronomyUtils;
import org.eclipse.core.databinding.conversion.Converter;

public class DateToMoonHorizontalCoordinatesStringConverter
extends Converter {
    private NumberFormat numberFormat = null;
    private GeographicCoordinates geographicCoordinates = null;
    private Coords coords = Coords.ALTITUDE;

    public DateToMoonHorizontalCoordinatesStringConverter() {
        super(Date.class, String.class);
    }

    public DateToMoonHorizontalCoordinatesStringConverter(NumberFormat numberFormat, GeographicCoordinates geographicCoordinates, Coords coords) {
        super(Date.class, String.class);
        this.setNumberFormat(numberFormat);
        this.setGeographicCoordinates(geographicCoordinates);
        this.setCoords(coords);
    }

    public NumberFormat getNumberFormat() {
        return this.numberFormat;
    }

    public void setNumberFormat(NumberFormat numberFormat) {
        this.numberFormat = numberFormat;
    }

    public GeographicCoordinates getGeographicCoordinates() {
        return this.geographicCoordinates;
    }

    public void setGeographicCoordinates(GeographicCoordinates geographicCoordinates) {
        this.geographicCoordinates = geographicCoordinates;
    }

    public Coords getCoords() {
        return this.coords;
    }

    public void setCoords(Coords coords) {
        this.coords = coords;
    }

    public Object convert(Object fromObject) {
        Date date = (Date)fromObject;
        HorizontalCoordinates moonCoordinates = AstronomyUtils.INSTANCE.getHorizontalMoonPosition(date, this.getGeographicCoordinates().getLongitude(), this.getGeographicCoordinates().getLatitude());
        Double value = new Double(0.0);
        value = this.getCoords() == Coords.ALTITUDE ? Double.valueOf(Math.toDegrees(moonCoordinates.getAltitude())) : Double.valueOf(Math.toDegrees(moonCoordinates.getAzimuth()));
        if (this.getNumberFormat() != null) {
            return this.getNumberFormat().format(value);
        }
        return value.toString();
    }

    public static enum Coords {
        ALTITUDE,
        AZIMUTH;

    }
}

