/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.earth.surface.impl;

import java.util.Date;
import javax.vecmath.Matrix3d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import org.eclipse.apogy.common.math.ApogyCommonMathFacade;
import org.eclipse.apogy.common.topology.TransformNode;
import org.eclipse.apogy.core.environment.Moon;
import org.eclipse.apogy.core.environment.Sky;
import org.eclipse.apogy.core.environment.StarField;
import org.eclipse.apogy.core.environment.Sun;
import org.eclipse.apogy.core.environment.earth.EarthWorksite;
import org.eclipse.apogy.core.environment.earth.HorizontalCoordinates;
import org.eclipse.apogy.core.environment.earth.surface.AstronomyUtils;
import org.eclipse.apogy.core.environment.earth.surface.EarthSky;
import org.eclipse.apogy.core.environment.earth.surface.impl.EarthSkyNodeImpl;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;

public class EarthSkyNodeCustomImpl
extends EarthSkyNodeImpl {
    private Adapter earthSkyAdapter = null;

    public void setSky(Sky newSky) {
        if (this.getSky() != null) {
            this.getSky().eAdapters().remove((Object)this.getEarthSkyAdapter());
        }
        if (newSky != null) {
            newSky.eAdapters().add((Object)this.getEarthSkyAdapter());
        }
        super.setSky(newSky);
    }

    protected Adapter getEarthSkyAdapter() {
        if (this.earthSkyAdapter == null) {
            this.earthSkyAdapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (msg.getNotifier() instanceof EarthSky) {
                        Date newTime;
                        EarthSky earthSky = (EarthSky)msg.getNotifier();
                        if (msg.getFeatureID(EarthSky.class) == 5) {
                            HorizontalCoordinates sunHorizontalCoordinates = (HorizontalCoordinates)msg.getNewValue();
                            Sun sun = earthSky.getSun();
                            Point3d sunPosition = AstronomyUtils.INSTANCE.convertFromHorizontalCoordinatesToHorizontalRectangular(sunHorizontalCoordinates);
                            if (sun != null) {
                                TransformNode sunTransformNode = (TransformNode)sun.getParent();
                                sunTransformNode.setPosition(ApogyCommonMathFacade.INSTANCE.createTuple3d((Tuple3d)sunPosition));
                            }
                        } else if (msg.getFeatureID(EarthSky.class) == 7) {
                            HorizontalCoordinates moonHorizontalCoordinates = (HorizontalCoordinates)msg.getNewValue();
                            Moon moon = earthSky.getMoon();
                            Point3d moonPosition = AstronomyUtils.INSTANCE.convertFromHorizontalCoordinatesToHorizontalRectangular(moonHorizontalCoordinates);
                            if (moon != null) {
                                TransformNode moonTransformNode = (TransformNode)moon.getParent();
                                moonTransformNode.setPosition(ApogyCommonMathFacade.INSTANCE.createTuple3d((Tuple3d)moonPosition));
                            }
                        } else if (msg.getFeatureID(EarthSky.class) == 0 && (newTime = (Date)msg.getNewValue()) != null) {
                            StarField starField = earthSky.getStarField();
                            EarthWorksite worksite = (EarthWorksite)earthSky.getWorksite();
                            Matrix3d m = EarthSkyNodeCustomImpl.this.updateStarsRotationMatrix(worksite, newTime.getTime());
                            if (starField != null) {
                                TransformNode starFieldTransformNode = (TransformNode)starField.getParent();
                                starFieldTransformNode.setRotationMatrix(ApogyCommonMathFacade.INSTANCE.createMatrix3x3(m));
                            }
                        }
                    }
                }
            };
        }
        return this.earthSkyAdapter;
    }

    private Matrix3d updateStarsRotationMatrix(EarthWorksite worksite, long newTime) {
        Date date = new Date(newTime);
        double observerLongitude = 0.0;
        double observerLatitude = 0.0;
        if (worksite.getGeographicalCoordinates() != null) {
            observerLongitude = worksite.getGeographicalCoordinates().getLongitude();
            observerLatitude = worksite.getGeographicalCoordinates().getLatitude();
        }
        Matrix3d earthRotationAxisMatrix = new Matrix3d();
        earthRotationAxisMatrix.rotY(Math.toRadians(90.0) - observerLatitude);
        double localSideralTime = AstronomyUtils.INSTANCE.getLocalSideralTime(date, observerLongitude);
        Matrix3d earthRotationMatrix = new Matrix3d();
        earthRotationMatrix.rotZ(-localSideralTime + Math.toRadians(180.0));
        Matrix3d m = new Matrix3d();
        m.mul(earthRotationAxisMatrix, earthRotationMatrix);
        return m;
    }
}

