/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.earth.surface.impl;

import java.util.Date;
import org.eclipse.apogy.common.math.ApogyCommonMathFactory;
import org.eclipse.apogy.common.math.Tuple3d;
import org.eclipse.apogy.core.environment.Sky;
import org.eclipse.apogy.core.environment.Worksite;
import org.eclipse.apogy.core.environment.WorksiteNode;
import org.eclipse.apogy.core.environment.earth.ApogyCoreEnvironmentEarthFacade;
import org.eclipse.apogy.core.environment.earth.GeographicCoordinates;
import org.eclipse.apogy.core.environment.earth.HorizontalCoordinates;
import org.eclipse.apogy.core.environment.earth.surface.ApogyEarthSurfaceEnvironmentFactory;
import org.eclipse.apogy.core.environment.earth.surface.AstronomyUtils;
import org.eclipse.apogy.core.environment.earth.surface.AtmosphereUtils;
import org.eclipse.apogy.core.environment.earth.surface.EarthSky;
import org.eclipse.apogy.core.environment.earth.surface.EarthSurfaceWorksiteNode;
import org.eclipse.apogy.core.environment.earth.surface.impl.EarthSurfaceWorksiteImpl;
import org.gavaghan.geodesy.Ellipsoid;
import org.gavaghan.geodesy.GeodeticCalculator;
import org.gavaghan.geodesy.GeodeticCurve;
import org.gavaghan.geodesy.GlobalCoordinates;

public class EarthSurfaceWorksiteCustomImpl
extends EarthSurfaceWorksiteImpl {
    @Override
    public EarthSky getEarthSky() {
        EarthSky es = super.getEarthSky();
        if (es == null) {
            es = ApogyEarthSurfaceEnvironmentFactory.eINSTANCE.createEarthSky();
            this.setSky(es);
        }
        return es;
    }

    @Override
    public EarthSky basicGetEarthSky() {
        return (EarthSky)super.getSky();
    }

    @Override
    public void setEarthSky(EarthSky newEarthSky) {
        super.setSky((Sky)newEarthSky);
    }

    public void setSky(Sky newSky) {
        EarthSurfaceWorksiteNode earthSurfaceWorksiteNode;
        if (this.getSky() != null && this.getWorksiteNode() instanceof EarthSurfaceWorksiteNode) {
            earthSurfaceWorksiteNode = (EarthSurfaceWorksiteNode)this.getWorksiteNode();
            earthSurfaceWorksiteNode.getSkyTransformNode().getChildren().remove((Object)this.getSky().getSkyNode());
            earthSurfaceWorksiteNode.getChildren().remove((Object)this.getSky().getSkyNode());
        }
        super.setSky(newSky);
        if (newSky != null && this.getWorksiteNode() instanceof EarthSurfaceWorksiteNode) {
            earthSurfaceWorksiteNode = (EarthSurfaceWorksiteNode)this.getWorksiteNode();
            earthSurfaceWorksiteNode.getSkyTransformNode().getChildren().add((Object)newSky.getSkyNode());
        }
    }

    public WorksiteNode getWorksiteNode() {
        if (!(super.getWorksiteNode() instanceof EarthSurfaceWorksiteNode)) {
            this.worksiteNode = ApogyEarthSurfaceEnvironmentFactory.eINSTANCE.createEarthSurfaceWorksiteNode();
            this.worksiteNode.setWorksite((Worksite)this);
            this.worksiteNode.setNodeId(this.getName().replaceAll(" ", "_"));
            this.worksiteNode.setDescription("Root Node of the Worksite");
        }
        return this.worksiteNode;
    }

    @Override
    public GeographicCoordinates convertToGeographicCoordinates(Tuple3d position) {
        GlobalCoordinates origin = new GlobalCoordinates(Math.toDegrees(this.getGeographicalCoordinates().getLatitude()), Math.toDegrees(this.getGeographicalCoordinates().getLongitude()));
        Ellipsoid reference = Ellipsoid.WGS84;
        double distance = Math.sqrt(position.getX() * position.getX() + position.getY() * position.getY());
        double angleInWorksiteFrame = Math.atan2(position.getY(), position.getX());
        double startBearing = -Math.toDegrees(angleInWorksiteFrame + this.getXAxisAzimuth());
        GeodeticCalculator geoCalc = new GeodeticCalculator();
        GlobalCoordinates endGlobalCoordinates = geoCalc.calculateEndingGlobalCoordinates(reference, origin, startBearing, distance);
        double latitude = Math.toRadians(endGlobalCoordinates.getLatitude());
        double longitude = Math.toRadians(endGlobalCoordinates.getLongitude());
        double elevation = this.getGeographicalCoordinates().getElevation() + position.getZ();
        GeographicCoordinates result = ApogyCoreEnvironmentEarthFacade.INSTANCE.createGeographicCoordinates(longitude, latitude, elevation);
        return result;
    }

    @Override
    public Tuple3d convertToXYZPosition(GeographicCoordinates geographicalCoordinates) {
        Tuple3d result = ApogyCommonMathFactory.eINSTANCE.createTuple3d();
        GlobalCoordinates origin = new GlobalCoordinates(Math.toDegrees(this.getGeographicalCoordinates().getLatitude()), Math.toDegrees(this.getGeographicalCoordinates().getLongitude()));
        GlobalCoordinates coordinates = new GlobalCoordinates(Math.toDegrees(geographicalCoordinates.getLatitude()), Math.toDegrees(geographicalCoordinates.getLongitude()));
        GeodeticCalculator geoCalc = new GeodeticCalculator();
        Ellipsoid reference = Ellipsoid.WGS84;
        GeodeticCurve geoCurve = geoCalc.calculateGeodeticCurve(reference, origin, coordinates);
        double x = 0.0;
        double y = 0.0;
        if (geoCurve.getEllipsoidalDistance() != 0.0) {
            double northEastAngle = Math.PI - this.getXAxisAzimuth();
            double DN = -geoCurve.getEllipsoidalDistance() * Math.cos(Math.toRadians(geoCurve.getAzimuth()));
            double DE = -geoCurve.getEllipsoidalDistance() * Math.sin(Math.toRadians(geoCurve.getAzimuth()));
            x = DN * Math.cos(northEastAngle) + DE * Math.sin(northEastAngle);
            y = -1.0 * (-DN * Math.sin(northEastAngle) + DE * Math.cos(northEastAngle));
        }
        double z = geographicalCoordinates.getElevation() - this.getGeographicalCoordinates().getElevation();
        result.setX(x);
        result.setY(y);
        result.setZ(z);
        return result;
    }

    public void setTime(Date newTime) {
        super.setTime(newTime);
        this.updateSunIntensity(newTime);
    }

    private void updateSunIntensity(Date newTime) {
        if (this.getGeographicalCoordinates() != null && this.getEarthSky() != null) {
            HorizontalCoordinates sunCoordinates = AstronomyUtils.INSTANCE.getHorizontalSunPosition(newTime, this.getGeographicalCoordinates().getLongitude(), this.getGeographicalCoordinates().getLatitude());
            Double value = AtmosphereUtils.INSTANCE.getDirectSunIntensity(sunCoordinates.getAltitude(), this.getGeographicalCoordinates().getElevation());
            this.setSunIntensity(value);
        }
    }
}

