/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.surface.impl;

import org.eclipse.apogy.common.images.AbstractEImage;
import org.eclipse.apogy.common.math.ApogyCommonMathFacade;
import org.eclipse.apogy.common.math.Matrix4x4;
import org.eclipse.apogy.core.environment.surface.ApogySurfaceEnvironmentFactory;
import org.eclipse.apogy.core.environment.surface.RectangularRegion;
import org.eclipse.apogy.core.environment.surface.impl.ImageMapLayerImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public abstract class ImageMapLayerCustomImpl
extends ImageMapLayerImpl {
    @Override
    public double getResolution() {
        this.resolution = -1.0;
        if (this.getImage() != null) {
            double hResolution = this.getWidth() / (double)this.getImage().getWidth();
            double vResolution = this.getHeight() / (double)this.getImage().getHeight();
            this.resolution = (hResolution + vResolution) / 2.0;
        }
        return this.resolution;
    }

    @Override
    public RectangularRegion getImageMapLayerRegion() {
        RectangularRegion rectangularRegion = ApogySurfaceEnvironmentFactory.eINSTANCE.createRectangularRegion();
        rectangularRegion.setTransformation(ApogyCommonMathFacade.INSTANCE.createIdentityMatrix4x4());
        if (this.getMap() != null && this.getMap().getTransformation() != null) {
            Matrix4x4 copy = (Matrix4x4)EcoreUtil.copy((EObject)this.getMap().getTransformation());
            rectangularRegion.setTransformation(copy);
        }
        rectangularRegion.setXMin(0.0);
        rectangularRegion.setXMax(this.getWidth());
        rectangularRegion.setYMin(0.0);
        rectangularRegion.setYMax(this.getHeight());
        return rectangularRegion;
    }

    @Override
    public AbstractEImage getRegionImage() {
        return this.getImage();
    }

    @Override
    public RectangularRegion getRegion() {
        return this.getImageMapLayerRegion();
    }
}

