/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.ui.composites;

import java.text.SimpleDateFormat;
import java.util.Date;
import javax.inject.Named;
import org.eclipse.apogy.common.emf.Timed;
import org.eclipse.apogy.common.emf.edit.utils.ApogyCommonEMFEditUtilsFacade;
import org.eclipse.apogy.common.math.ApogyCommonMathFacade;
import org.eclipse.apogy.common.math.Tuple3d;
import org.eclipse.apogy.core.OperationCallPositionedResult;
import org.eclipse.apogy.core.invocator.Context;
import org.eclipse.apogy.core.invocator.DataProductsList;
import org.eclipse.apogy.core.invocator.DataProductsListsContainer;
import org.eclipse.apogy.core.invocator.OperationCallResult;
import org.eclipse.apogy.core.invocator.OperationCallResultsList;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.PlatformUI;

public class DataProductsListsContainerComposite
extends Composite {
    private DataBindingContext m_currentDataBindings;
    private final ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
    private TreeViewer treeViewer;
    private DataProductsListsContainer dataProductsListsContainer;
    private ISelectionChangedListener treeViewerSelectionChangedListener;

    public DataProductsListsContainerComposite(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(1, true));
        this.treeViewer = new TreeViewer((Composite)this, 2564);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.treeViewer, (int)2);
        Tree tree = this.treeViewer.getTree();
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        tree.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        TreeViewerColumn treeViewerColumnItem_Name = new TreeViewerColumn(this.treeViewer, 0);
        TreeColumn trclmnItem = treeViewerColumnItem_Name.getColumn();
        trclmnItem.setWidth(350);
        trclmnItem.setText("Name");
        TreeViewerColumn treeViewerColumnItem_Time = new TreeViewerColumn(this.treeViewer, 0);
        TreeColumn trclmnTime = treeViewerColumnItem_Time.getColumn();
        trclmnTime.setWidth(200);
        trclmnTime.setText("Time");
        TreeViewerColumn treeViewerColumnItem_Context = new TreeViewerColumn(this.treeViewer, 0);
        TreeColumn trclmnContext = treeViewerColumnItem_Context.getColumn();
        trclmnContext.setWidth(100);
        trclmnContext.setText("Context");
        TreeViewerColumn treeViewerColumnItem_Position = new TreeViewerColumn(this.treeViewer, 0);
        TreeColumn trclmnPosition = treeViewerColumnItem_Position.getColumn();
        trclmnPosition.setWidth(150);
        trclmnPosition.setText("Position");
        TreeViewerColumn treeViewerColumnItem_Orientation = new TreeViewerColumn(this.treeViewer, 0);
        TreeColumn trclmnOrientation = treeViewerColumnItem_Orientation.getColumn();
        trclmnOrientation.setWidth(150);
        trclmnOrientation.setText("Orientation");
        TreeViewerColumn treeViewerColumnItem_Exception = new TreeViewerColumn(this.treeViewer, 0);
        TreeColumn trclmnException = treeViewerColumnItem_Exception.getColumn();
        trclmnException.setWidth(120);
        trclmnException.setText("Value");
        this.treeViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)this.adapterFactory){

            public Object[] getChildren(Object object) {
                if (object instanceof DataProductsListsContainer || object instanceof DataProductsList || object instanceof OperationCallResultsList) {
                    return super.getChildren(object);
                }
                return null;
            }

            public boolean hasChildren(Object object) {
                if (object instanceof DataProductsListsContainer || object instanceof DataProductsList || object instanceof OperationCallResultsList) {
                    return super.hasChildren(object);
                }
                return false;
            }
        });
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new DataProductsListsContainerLabelProvider((AdapterFactory)this.adapterFactory));
        this.treeViewer.addSelectionChangedListener(this.getTreeViewerSelectionChangedListener());
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (DataProductsListsContainerComposite.this.m_currentDataBindings != null) {
                    DataProductsListsContainerComposite.this.m_currentDataBindings.dispose();
                }
                DataProductsListsContainerComposite.this.treeViewer.removeSelectionChangedListener(DataProductsListsContainerComposite.this.getTreeViewerSelectionChangedListener());
            }
        });
    }

    private ISelectionChangedListener getTreeViewerSelectionChangedListener() {
        if (this.treeViewerSelectionChangedListener == null) {
            this.treeViewerSelectionChangedListener = new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    DataProductsListsContainerComposite.this.newSelection(event.getSelection());
                }
            };
        }
        return this.treeViewerSelectionChangedListener;
    }

    protected void newSelection(ISelection selection) {
    }

    public void setDataProductsListsContainer(DataProductsListsContainer dataProductsListsContainer) {
        this.dataProductsListsContainer = dataProductsListsContainer;
        if (dataProductsListsContainer != null) {
            if (this.m_currentDataBindings != null) {
                this.m_currentDataBindings.dispose();
            }
            this.m_currentDataBindings = this.initDataBindings();
        }
    }

    protected DataBindingContext initDataBindings() {
        return this.initDataBindingsCustom();
    }

    protected DataBindingContext initDataBindingsCustom() {
        DataBindingContext bindingContext = new DataBindingContext();
        if (this.dataProductsListsContainer != null && !this.treeViewer.getTree().isDisposed()) {
            this.treeViewer.setInput((Object)this.dataProductsListsContainer);
            this.treeViewer.expandAll();
        }
        return bindingContext;
    }

    private class DataProductsListsContainerLabelProvider
    extends AdapterFactoryLabelProvider
    implements ITableLabelProvider,
    ITableColorProvider {
        private static final int NAME_COLUMN_ID = 0;
        private static final int TIME_COLUMN_ID = 1;
        private static final int CONTEXT_COLUMN_ID = 2;
        private static final int POSITION_COLUMN_ID = 3;
        private static final int ORIENTATION_COLUMN_ID = 4;
        private static final int VALUE_COLUMN_ID = 5;

        public DataProductsListsContainerLabelProvider(AdapterFactory adapterFactory) {
            super(adapterFactory);
        }

        public String getColumnText(Object object, int columnIndex) {
            String str = "<undefined>";
            switch (columnIndex) {
                case 0: {
                    if (object instanceof Named) {
                        str = ApogyCommonEMFEditUtilsFacade.INSTANCE.getText(object);
                        break;
                    }
                    if (!(object instanceof OperationCallResult)) break;
                    OperationCallResult result = (OperationCallResult)object;
                    str = ApogyCommonEMFEditUtilsFacade.INSTANCE.getText((Object)result.getOperationCall());
                    break;
                }
                case 1: {
                    str = "";
                    if (!(object instanceof Timed)) break;
                    Date date = ((Timed)object).getTime();
                    str = date == null ? "N/A." : new SimpleDateFormat("MM/dd/yyyy HH:mm:ss.SSS").format(((Timed)object).getTime());
                    break;
                }
                case 2: {
                    str = "";
                    if (!(object instanceof OperationCallResult)) break;
                    Context context = ((OperationCallResult)object).getContext();
                    str = ApogyCommonEMFEditUtilsFacade.INSTANCE.getText((Object)context);
                    break;
                }
                case 3: {
                    str = "";
                    if (!(object instanceof OperationCallResult)) break;
                    if (object instanceof OperationCallPositionedResult) {
                        OperationCallPositionedResult result = (OperationCallPositionedResult)object;
                        if (result.getPose() == null) {
                            str = "Null";
                            break;
                        }
                        Tuple3d position = ApogyCommonMathFacade.INSTANCE.extractPosition(result.getPose());
                        str = ApogyCommonEMFEditUtilsFacade.INSTANCE.getText((Object)position);
                        break;
                    }
                    str = "N/A.";
                    break;
                }
                case 4: {
                    str = "";
                    if (!(object instanceof OperationCallResult)) break;
                    if (object instanceof OperationCallPositionedResult) {
                        OperationCallPositionedResult result = (OperationCallPositionedResult)object;
                        if (result.getPose() == null) {
                            str = "Null";
                            break;
                        }
                        Tuple3d orientation = ApogyCommonMathFacade.INSTANCE.extractOrientation(result.getPose());
                        orientation.setX(Math.toDegrees(orientation.getX()));
                        orientation.setY(Math.toDegrees(orientation.getY()));
                        orientation.setZ(Math.toDegrees(orientation.getZ()));
                        str = ApogyCommonEMFEditUtilsFacade.INSTANCE.getText((Object)orientation);
                        break;
                    }
                    str = "N/A.";
                    break;
                }
                case 5: {
                    str = "";
                    if (!(object instanceof OperationCallResult)) break;
                    OperationCallResult result = (OperationCallResult)object;
                    if (result.getExceptionContainer() != null && result.getExceptionContainer().getException() != null) {
                        str = result.getExceptionContainer().getException().getMessage();
                        break;
                    }
                    str = result.getResultValue() == null ? "Null" : ApogyCommonEMFEditUtilsFacade.INSTANCE.getText((Object)result.getResultValue());
                    break;
                }
            }
            return str;
        }

        public Image getColumnImage(Object object, int columnIndex) {
            return null;
        }

        public Color getBackground(Object object, int columnIndex) {
            OperationCallResult opResult;
            Color color = super.getBackground(object, columnIndex);
            if (object instanceof OperationCallResult && (opResult = (OperationCallResult)object).getExceptionContainer() != null && opResult.getExceptionContainer().getException() != null) {
                color = PlatformUI.getWorkbench().getDisplay().getSystemColor(3);
            }
            return color;
        }
    }
}

