/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.ui.impl;

import org.eclipse.apogy.core.ui.Activator;
import org.eclipse.apogy.core.ui.ResultNodeSceneObject;
import org.eclipse.apogy.core.ui.impl.ResultNodePresentationImpl;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class ResultNodePresentationCustomImpl
extends ResultNodePresentationImpl {
    protected IPropertyChangeListener preferencesListener = null;

    protected ResultNodePresentationCustomImpl() {
        this.applyPreferences();
        Activator.getDefault().getPreferenceStore().addPropertyChangeListener(this.getPreferencesListener());
    }

    protected void initialSceneObject() {
        ResultNodeSceneObject j3DObject = (ResultNodeSceneObject)this.sceneObject;
        j3DObject.setFlagPoleHeight(this.getPoleHeight());
        j3DObject.setFlagVisible(this.isFlagVisible());
        super.initialSceneObject();
    }

    protected void applyPreferences() {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        this.setFlagVisible(store.getBoolean("DEFAULT_RESULT_NODE_FLAG_VISIBILITY_ID"));
        this.setPoleHeight(store.getFloat("DEFAULT_RESULT_NODE_FLAG_POLE_HEIGHT_ID"));
        super.applyPreferences();
    }

    protected void updateSceneObject(Notification notification) {
        ResultNodeSceneObject resultNodeSceneObject = (ResultNodeSceneObject)this.sceneObject;
        if (notification.getNotifier() instanceof ResultNodePresentationCustomImpl) {
            int featureId = notification.getFeatureID(ResultNodePresentationCustomImpl.class);
            switch (featureId) {
                case 19: {
                    resultNodeSceneObject.setFlagVisible(this.isFlagVisible());
                    break;
                }
                case 18: {
                    resultNodeSceneObject.setFlagPoleHeight(this.getPoleHeight());
                    break;
                }
            }
        }
        super.updateSceneObject(notification);
    }

    private IPropertyChangeListener getPreferencesListener() {
        if (this.preferencesListener == null) {
            this.preferencesListener = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    ResultNodePresentationCustomImpl.this.applyPreferences();
                }
            };
        }
        return this.preferencesListener;
    }
}

