/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.vecmath.Matrix4d;
import org.eclipse.apogy.common.math.Matrix4x4;
import org.eclipse.apogy.common.topology.ApogyCommonTopologyFacade;
import org.eclipse.apogy.common.topology.GroupNode;
import org.eclipse.apogy.common.topology.TransformNode;
import org.eclipse.apogy.core.ApogyCoreFacade;
import org.eclipse.apogy.core.Positioned;
import org.eclipse.apogy.core.PositionedResult;
import org.eclipse.apogy.core.ResultNode;
import org.eclipse.apogy.core.impl.ResultsListNodeImpl;
import org.eclipse.apogy.core.invocator.AbstractResult;
import org.eclipse.apogy.core.invocator.ResultsList;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultsListNodeCustomImpl
extends ResultsListNodeImpl {
    private static final Logger Logger = LoggerFactory.getLogger(ResultsListNodeImpl.class);
    private Adapter adapter;
    private Adapter positionnedAdapter;
    private final Map<PositionedResult, ResultNode> resultToNodeMap = new HashMap<PositionedResult, ResultNode>();

    @Override
    public void setResultsList(ResultsList newResultsList) {
        ResultsList oldResultsList = this.getResultsList();
        super.setResultsList(newResultsList);
        this.updateResultsList(oldResultsList, newResultsList);
    }

    private void updateResultsList(ResultsList oldResultsList, ResultsList newResultsList) {
        this.clearTopology();
        if (oldResultsList != null) {
            oldResultsList.eAdapters().remove((Object)this.getAdapter());
        }
        if (newResultsList != null) {
            newResultsList.eAdapters().add((Object)this.getAdapter());
            for (AbstractResult abstractResult : newResultsList.getResults()) {
                this.addResult(abstractResult);
            }
        }
    }

    private void clearTopology() {
        this.getChildren().clear();
        this.resultToNodeMap.clear();
    }

    private void addResult(AbstractResult abstractResult) {
        if (abstractResult instanceof PositionedResult) {
            PositionedResult positionedResult = (PositionedResult)abstractResult;
            ResultNode resultNode = ApogyCoreFacade.INSTANCE.createResultNode(positionedResult);
            Matrix4d pose = null;
            if (positionedResult.getPose() != null) {
                pose = positionedResult.getPose().asMatrix4d();
            } else {
                pose = new Matrix4d();
                pose.setIdentity();
            }
            TransformNode transform = ApogyCommonTopologyFacade.INSTANCE.createTransformNode(pose);
            if (positionedResult.getTime() != null) {
                String id = "RESULT_TRANSFORM_" + positionedResult.getTime().toString();
                transform.setNodeId(id);
                transform.setDescription("Transform positionning result <" + resultNode.getNodeId() + ">");
            }
            transform.getChildren().add((Object)resultNode);
            this.getChildren().add((Object)transform);
            this.resultToNodeMap.put(positionedResult, resultNode);
            positionedResult.eAdapters().add((Object)this.getPositionnedAdapter());
            if (positionedResult.getPose() != null) {
                positionedResult.getPose().eAdapters().add((Object)this.getPositionnedAdapter());
            }
            Logger.info("Added PositionResult time tagged <" + positionedResult.getTime() + ">.");
        }
    }

    private void removeResult(AbstractResult abstractResult) {
        PositionedResult positionedResult;
        ResultNode resultNode;
        if (abstractResult instanceof PositionedResult && (resultNode = this.resultToNodeMap.get(positionedResult = (PositionedResult)abstractResult)) != null) {
            GroupNode parent = (GroupNode)resultNode.getParent();
            parent.getChildren().remove((Object)resultNode);
            this.getChildren().remove((Object)parent);
            positionedResult.eAdapters().remove((Object)this.getPositionnedAdapter());
            if (positionedResult.getPose() != null) {
                positionedResult.getPose().eAdapters().remove((Object)this.getPositionnedAdapter());
            }
            Logger.info("Removed PositionResult time tagged <" + positionedResult.getTime() + ">.");
        }
    }

    private void updateResultPosition(PositionedResult abstractResult, Matrix4x4 newPose) {
        ResultNode resultNode;
        if (newPose != null && (resultNode = this.resultToNodeMap.get(abstractResult)) != null && resultNode.getParent() instanceof TransformNode) {
            TransformNode transformNode = (TransformNode)resultNode.getParent();
            transformNode.setTransformation(newPose.asMatrix4d());
        }
    }

    private Adapter getAdapter() {
        if (this.adapter == null) {
            this.adapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (msg.getNotifier() instanceof ResultsList && msg.getFeatureID(ResultsList.class) == 3) {
                        switch (msg.getEventType()) {
                            case 3: {
                                AbstractResult resultAdded = (AbstractResult)msg.getNewValue();
                                ResultsListNodeCustomImpl.this.addResult(resultAdded);
                                break;
                            }
                            case 5: {
                                Collection resultsAdded = (Collection)msg.getNewValue();
                                for (AbstractResult abstractMapLayer : resultsAdded) {
                                    ResultsListNodeCustomImpl.this.addResult(abstractMapLayer);
                                }
                                break;
                            }
                            case 4: {
                                AbstractResult resultRemoved = (AbstractResult)msg.getOldValue();
                                ResultsListNodeCustomImpl.this.removeResult(resultRemoved);
                                break;
                            }
                            case 6: {
                                Collection resultsRemoved = (Collection)msg.getOldValue();
                                for (AbstractResult abstractMapLayer : resultsRemoved) {
                                    ResultsListNodeCustomImpl.this.removeResult(abstractMapLayer);
                                }
                                break;
                            }
                        }
                    }
                }
            };
        }
        return this.adapter;
    }

    private Adapter getPositionnedAdapter() {
        if (this.positionnedAdapter == null) {
            this.positionnedAdapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    Matrix4x4 matrix;
                    if (msg.getNotifier() instanceof PositionedResult) {
                        PositionedResult positionedResult = (PositionedResult)msg.getNotifier();
                        int featureID = msg.getFeatureID(Positioned.class);
                        if (featureID == 6) {
                            if (msg.getOldValue() instanceof Matrix4x4) {
                                Matrix4x4 oldMatrix = (Matrix4x4)msg.getOldValue();
                                oldMatrix.eAdapters().remove((Object)ResultsListNodeCustomImpl.this.getPositionnedAdapter());
                            }
                            if (msg.getNewValue() instanceof Matrix4x4) {
                                Matrix4x4 newMatrix = (Matrix4x4)msg.getNewValue();
                                newMatrix.eAdapters().add((Object)ResultsListNodeCustomImpl.this.getPositionnedAdapter());
                                ResultsListNodeCustomImpl.this.updateResultPosition(positionedResult, newMatrix);
                            }
                        }
                    } else if (msg.getNotifier() instanceof Matrix4x4 && (matrix = (Matrix4x4)msg.getNotifier()).eContainer() instanceof PositionedResult) {
                        PositionedResult positionedResult = (PositionedResult)matrix.eContainer();
                        ResultsListNodeCustomImpl.this.updateResultPosition(positionedResult, matrix);
                    }
                }
            };
        }
        return this.positionnedAdapter;
    }
}

