/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.examples.mobile_platform.impl;

import org.eclipse.apogy.examples.mobile_platform.ApogyExamplesMobilePlatformFactory;
import org.eclipse.apogy.examples.mobile_platform.Position;
import org.eclipse.apogy.examples.mobile_platform.impl.MobilePlatformSimulatedCustomImpl;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MobilePlatformSimulatedMoveJob
extends Job {
    private static final Logger Logger = LoggerFactory.getLogger(MobilePlatformSimulatedMoveJob.class);
    private static final double DELTA_T = 0.1;
    private final MobilePlatformSimulatedCustomImpl platform;

    protected MobilePlatformSimulatedMoveJob(MobilePlatformSimulatedCustomImpl platform, String name) {
        super(name);
        this.platform = platform;
    }

    protected IStatus run(IProgressMonitor monitor) {
        while (!monitor.isCanceled()) {
            this.platform.lock.lock();
            if (!(this.platform.doingMoveTo || this.platform.getLinearVelocity() == 0.0 && this.platform.getAngularVelocity() == 0.0)) {
                double linVel = this.platform.getLinearVelocity();
                double angVel = this.platform.getAngularVelocity();
                double newX = this.platform.getPosition().getX();
                double newY = this.platform.getPosition().getY();
                double newTheta = this.platform.getPosition().getTheta();
                double newLeftWheelPos = this.platform.getLeftWheelPosition();
                double newRightWheelPos = this.platform.getRightWheelPosition();
                double newPosError = this.platform.getPositionError();
                double displacement = linVel * 0.1;
                newPosError += Math.abs(displacement) * 0.05;
                newX += displacement * Math.cos(newTheta += angVel * 0.1);
                newY += displacement * Math.sin(newTheta);
                double rightWheelVel = angVel * 0.32 + linVel;
                double leftWheelVel = 2.0 * linVel - rightWheelVel;
                double rightWheelAngVel = rightWheelVel / 0.25;
                double leftWheelAngVel = leftWheelVel / 0.25;
                newLeftWheelPos += 0.1 * leftWheelAngVel;
                newRightWheelPos += 0.1 * rightWheelAngVel;
                Position newPosition = ApogyExamplesMobilePlatformFactory.eINSTANCE.createPosition();
                newPosition.setX(newX);
                newPosition.setY(newY);
                newPosition.setTheta(newTheta);
                this.platform.setPosition(newPosition);
                this.platform.setPositionError(newPosError);
                this.platform.setLeftWheelPosition(newLeftWheelPos);
                this.platform.setRightWheelPosition(newRightWheelPos);
            }
            this.platform.lock.unlock();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return Status.OK_STATUS;
    }
}

