/*
 * Decompiled with CFR 0.152.
 */
package org.ros.internal.transport;

import com.google.common.collect.Lists;
import java.net.InetSocketAddress;
import java.util.List;
import org.ros.address.AdvertiseAddress;

public class ProtocolDescription {
    private final String name;
    private final AdvertiseAddress address;

    public ProtocolDescription(String name, AdvertiseAddress address) {
        this.name = name;
        this.address = address;
    }

    public String getName() {
        return this.name;
    }

    public AdvertiseAddress getAdverstiseAddress() {
        return this.address;
    }

    public InetSocketAddress getAddress() {
        return this.address.toInetSocketAddress();
    }

    public List<Object> toList() {
        return Lists.newArrayList((Object[])new Object[]{this.name, this.address.getHost(), this.address.getPort()});
    }

    public String toString() {
        return "Protocol<" + this.name + ", " + this.getAdverstiseAddress() + ">";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.address == null ? 0 : this.address.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProtocolDescription other = (ProtocolDescription)obj;
        if (this.address == null ? other.address != null : !this.address.equals(other.address)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

