/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.sensors.fov.ui.jme3.scene_objects;

import com.jme3.asset.AssetManager;
import com.jme3.asset.plugins.FileLocator;
import com.jme3.material.Material;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.Control;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.eclipse.apogy.addons.sensors.fov.DistanceRange;
import org.eclipse.apogy.addons.sensors.fov.RectangularFrustrumFieldOfView;
import org.eclipse.apogy.addons.sensors.fov.ui.jme3.scene_objects.AbstractFieldOfViewJME3Object;
import org.eclipse.apogy.addons.sensors.fov.ui.jme3.utils.AbstractFieldOfViewImageProjectorControl;
import org.eclipse.apogy.addons.sensors.fov.ui.jme3.utils.JME3FovUtilities;
import org.eclipse.apogy.addons.sensors.fov.ui.jme3.utils.RectangularFrustrumFieldOfViewImageProjectorControl;
import org.eclipse.apogy.addons.sensors.fov.ui.scene_objects.RectangularFrustrumFieldOfViewSceneObject;
import org.eclipse.apogy.common.topology.ui.MeshPresentationMode;
import org.eclipse.apogy.common.topology.ui.jme3.JME3RenderEngineDelegate;
import org.eclipse.apogy.common.topology.ui.jme3.JME3Utilities;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.swt.graphics.RGBA;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RectangularFrustumFieldOfViewJME3Object
extends AbstractFieldOfViewJME3Object<RectangularFrustrumFieldOfView>
implements RectangularFrustrumFieldOfViewSceneObject {
    private static final Logger Logger = LoggerFactory.getLogger(RectangularFrustumFieldOfViewJME3Object.class);
    public static ColorRGBA DEFAULT_CIRCULAR_SECTOR_FOV_COLOR = new ColorRGBA(0.0f, 1.0f, 0.0f, 1.0f);
    public static float DEFAULT_ANGLE_INCREMENT = (float)Math.toRadians(10.0);
    private float previousAxisLength = 1.0f;
    private boolean axisVisible = true;
    private MeshPresentationMode meshPresentationMode = MeshPresentationMode.WIREFRAME;
    private Adapter fovAdapter;
    private Adapter rangeAdapter;
    private AssetManager assetManager = this.jme3Application.getAssetManager();
    private Geometry fovGeometry = null;
    private Geometry axisGeometry = null;
    private RectangularFrustrumFieldOfViewImageProjectorControl rectangularFrustrumFieldOfViewImageProjectorControl;

    public RectangularFrustumFieldOfViewJME3Object(final RectangularFrustrumFieldOfView node, JME3RenderEngineDelegate jme3RenderEngineDelegate) {
        super(node, jme3RenderEngineDelegate);
        this.assetManager.registerLocator("/", FileLocator.class);
        this.axisGeometry = JME3Utilities.createAxis3D((float)1.0f, (AssetManager)this.assetManager);
        this.jme3Application.enqueue((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                RectangularFrustumFieldOfViewJME3Object.this.requestUpdate();
                node.eAdapters().add((Object)RectangularFrustumFieldOfViewJME3Object.this.getFOVAdapter());
                if (node.getRange() != null) {
                    node.getRange().eAdapters().add((Object)RectangularFrustumFieldOfViewJME3Object.this.getRangeAdapter());
                }
                return null;
            }
        });
    }

    public void updateGeometry(float tpf) {
        if (this.fovGeometry != null) {
            this.getFovNode().detachChild((Spatial)this.fovGeometry);
        }
        int numberOfDivision = 5;
        numberOfDivision = ((RectangularFrustrumFieldOfView)this.getTopologyNode()).getHorizontalFieldOfViewAngle() > (double)(5.0f * DEFAULT_ANGLE_INCREMENT) ? (int)Math.round(((RectangularFrustrumFieldOfView)this.getTopologyNode()).getHorizontalFieldOfViewAngle() / (double)DEFAULT_ANGLE_INCREMENT) : 5;
        Mesh mesh = JME3FovUtilities.createRectangularFrustum((RectangularFrustrumFieldOfView)this.getTopologyNode(), numberOfDivision, numberOfDivision);
        this.fovGeometry = ((RectangularFrustrumFieldOfView)this.getTopologyNode()).getNodeId() != null ? new Geometry(((RectangularFrustrumFieldOfView)this.getTopologyNode()).getNodeId(), mesh) : new Geometry("?", mesh);
        this.fovGeometry.setMaterial(this.createMaterial());
        this.getFovNode().attachChild((Spatial)this.fovGeometry);
        this.internalSetPresentationMode(this.meshPresentationMode);
        this.getAttachmentNode().addControl((Control)this.getRectangularFrustrumFieldOfViewImageProjectorControl());
    }

    public void dispose() {
        if (this.getTopologyNode() != null) {
            ((RectangularFrustrumFieldOfView)this.getTopologyNode()).eAdapters().remove((Object)this.getFOVAdapter());
            if (((RectangularFrustrumFieldOfView)this.getTopologyNode()).getRange() != null) {
                ((RectangularFrustrumFieldOfView)this.getTopologyNode()).getRange().eAdapters().remove((Object)this.getRangeAdapter());
            }
        }
        if (this.rectangularFrustrumFieldOfViewImageProjectorControl != null) {
            this.rectangularFrustrumFieldOfViewImageProjectorControl.dispose();
            this.rectangularFrustrumFieldOfViewImageProjectorControl = null;
        }
        super.dispose();
    }

    public List<Geometry> getGeometries() {
        ArrayList<Geometry> geometries = new ArrayList<Geometry>();
        geometries.add(this.fovGeometry);
        if (this.axisGeometry != null) {
            geometries.add(this.axisGeometry);
        }
        return geometries;
    }

    @Override
    public void setColor(RGBA rgb) {
        Logger.info("Set Color <" + rgb + ").");
        super.setColor(rgb);
        try {
            if (this.fovGeometry != null) {
                final Material mat = this.createMaterial();
                mat.setColor("Diffuse", this.fovColor);
                mat.setColor("Ambient", this.fovColor);
                mat.setColor("Specular", this.fovColor);
                this.jme3Application.enqueue((Callable)new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        RectangularFrustumFieldOfViewJME3Object.this.fovGeometry.setMaterial(mat);
                        return null;
                    }
                });
            }
        }
        catch (Throwable t) {
            Logger.error("Failed to set color to <" + rgb + ">.", t);
        }
    }

    public void setPresentationMode(final MeshPresentationMode mode) {
        Logger.info("setPresentationMode(" + mode + ").");
        this.meshPresentationMode = mode;
        if (this.fovGeometry != null && this.fovGeometry.getMaterial() != null) {
            this.jme3Application.enqueue((Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    RectangularFrustumFieldOfViewJME3Object.this.internalSetPresentationMode(mode);
                    return null;
                }
            });
        }
    }

    public void setShowProjection(final boolean showProjection) {
        Logger.info("setShowProjection(" + showProjection + ")");
        this.jme3Application.enqueue((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                RectangularFrustumFieldOfViewJME3Object.this.getRectangularFrustrumFieldOfViewImageProjectorControl().setEnabled(showProjection);
                return null;
            }
        });
        this.showProjection = showProjection;
    }

    public void setShowOutlineOnly(boolean showOutlineOnly) {
    }

    @Override
    public AbstractFieldOfViewImageProjectorControl<RectangularFrustrumFieldOfView> getAbstractFieldOfViewImageProjectorControl() {
        return this.getRectangularFrustrumFieldOfViewImageProjectorControl();
    }

    public void setAxisVisible(boolean visible) {
        Logger.info("Setting axis visible to <" + visible + ">.");
        this.axisVisible = visible;
        this.jme3Application.enqueue((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                if (RectangularFrustumFieldOfViewJME3Object.this.axisVisible) {
                    RectangularFrustumFieldOfViewJME3Object.this.getAttachmentNode().attachChild((Spatial)RectangularFrustumFieldOfViewJME3Object.this.axisGeometry);
                } else {
                    RectangularFrustumFieldOfViewJME3Object.this.getAttachmentNode().detachChild((Spatial)RectangularFrustumFieldOfViewJME3Object.this.axisGeometry);
                }
                return null;
            }
        });
    }

    public void setAxisLength(final double length) {
        if (length > 0.0) {
            Logger.info("Setting axis length to <" + length + ">.");
            this.jme3Application.enqueue((Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    try {
                        float scale = (float)Math.abs(length) / RectangularFrustumFieldOfViewJME3Object.this.previousAxisLength;
                        if (RectangularFrustumFieldOfViewJME3Object.this.axisGeometry != null) {
                            RectangularFrustumFieldOfViewJME3Object.this.axisGeometry.scale(scale);
                        }
                        RectangularFrustumFieldOfViewJME3Object.this.previousAxisLength = (float)length;
                    }
                    catch (Throwable t) {
                        Logger.error("Failed to setAxisLength(" + length + ").", t);
                    }
                    return null;
                }
            });
        } else {
            Logger.error("Setting axis length to <" + length + "> failed : Length must be greater than zero.");
        }
    }

    private void internalSetPresentationMode(MeshPresentationMode mode) {
        if (this.fovGeometry != null && this.fovGeometry.getMesh() != null) {
            Mesh mesh = this.fovGeometry.getMesh();
            switch (mode.getValue()) {
                case 1: {
                    this.fovGeometry.getMaterial().getAdditionalRenderState().setWireframe(false);
                    if (mesh == null) break;
                    mesh.setMode(Mesh.Mode.Triangles);
                    break;
                }
                case 2: {
                    this.fovGeometry.getMaterial().getAdditionalRenderState().setWireframe(true);
                    if (mesh == null) break;
                    mesh.setMode(Mesh.Mode.Triangles);
                    break;
                }
                case 0: {
                    this.fovGeometry.getMaterial().getAdditionalRenderState().setWireframe(false);
                    if (mesh == null) break;
                    mesh.setMode(Mesh.Mode.Points);
                    break;
                }
            }
        }
    }

    private Material createMaterial() {
        Material mat = new Material(this.assetManager, "Common/MatDefs/Light/Lighting.j3md");
        if (this.getColor() != null) {
            mat.setColor("Diffuse", JME3Utilities.convertToColorRGBA((RGBA)this.getColor()));
            mat.setColor("Ambient", JME3Utilities.convertToColorRGBA((RGBA)this.getColor()));
            mat.setColor("Specular", JME3Utilities.convertToColorRGBA((RGBA)this.getColor()));
        } else {
            mat.setColor("Diffuse", DEFAULT_CIRCULAR_SECTOR_FOV_COLOR.clone());
            mat.setColor("Ambient", DEFAULT_CIRCULAR_SECTOR_FOV_COLOR.clone());
            mat.setColor("Specular", DEFAULT_CIRCULAR_SECTOR_FOV_COLOR.clone());
        }
        mat.setFloat("Shininess", 64.0f);
        mat.setBoolean("UseMaterialColors", true);
        mat.getAdditionalRenderState().setFaceCullMode(RenderState.FaceCullMode.Off);
        return mat;
    }

    private Adapter getFOVAdapter() {
        if (this.fovAdapter == null) {
            this.fovAdapter = new AdapterImpl(){

                public void notifyChanged(Notification notification) {
                    if (notification.getNotifier() instanceof RectangularFrustrumFieldOfView) {
                        int featureId = notification.getFeatureID(RectangularFrustrumFieldOfView.class);
                        if (featureId == 4 || featureId == 5) {
                            RectangularFrustumFieldOfViewJME3Object.this.requestUpdate();
                            RectangularFrustumFieldOfViewJME3Object.this.getRectangularFrustrumFieldOfViewImageProjectorControl().updateProjectorFOVSettings();
                        } else if (featureId == 3) {
                            if (notification.getOldValue() instanceof DistanceRange) {
                                DistanceRange oldDistanceRange = (DistanceRange)notification.getOldValue();
                                oldDistanceRange.eAdapters().remove((Object)RectangularFrustumFieldOfViewJME3Object.this.getRangeAdapter());
                            }
                            RectangularFrustumFieldOfViewJME3Object.this.requestUpdate();
                            if (notification.getNewValue() instanceof DistanceRange) {
                                DistanceRange newDistanceRange = (DistanceRange)notification.getNewValue();
                                newDistanceRange.eAdapters().add((Object)RectangularFrustumFieldOfViewJME3Object.this.getRangeAdapter());
                            }
                        }
                    }
                }
            };
        }
        return this.fovAdapter;
    }

    private Adapter getRangeAdapter() {
        if (this.rangeAdapter == null) {
            this.rangeAdapter = new AdapterImpl(){

                public void notifyChanged(Notification notification) {
                    int featureId;
                    if (notification.getNotifier() instanceof DistanceRange && ((featureId = notification.getFeatureID(DistanceRange.class)) == 1 || featureId == 1)) {
                        RectangularFrustumFieldOfViewJME3Object.this.requestUpdate();
                    }
                }
            };
        }
        return this.rangeAdapter;
    }

    private RectangularFrustrumFieldOfViewImageProjectorControl getRectangularFrustrumFieldOfViewImageProjectorControl() {
        if (this.rectangularFrustrumFieldOfViewImageProjectorControl == null) {
            this.rectangularFrustrumFieldOfViewImageProjectorControl = new RectangularFrustrumFieldOfViewImageProjectorControl(this.jme3Application, (RectangularFrustrumFieldOfView)this.getTopologyNode());
        }
        return this.rectangularFrustrumFieldOfViewImageProjectorControl;
    }
}

