/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.sensors.imaging.camera.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.apogy.addons.sensors.imaging.AbstractCamera;
import org.eclipse.apogy.addons.sensors.imaging.camera.ApogyAddonsSensorsImagingCameraFactory;
import org.eclipse.apogy.addons.sensors.imaging.camera.ApogyAddonsSensorsImagingCameraPackage;
import org.eclipse.apogy.addons.sensors.imaging.camera.CameraImageAnnotation;
import org.eclipse.apogy.addons.sensors.imaging.camera.CameraOverlayList;
import org.eclipse.apogy.addons.sensors.imaging.camera.CameraTool;
import org.eclipse.apogy.addons.sensors.imaging.camera.CameraToolList;
import org.eclipse.apogy.addons.sensors.imaging.camera.FilterList;
import org.eclipse.apogy.addons.sensors.imaging.camera.impl.CameraViewConfigurationImpl;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.apogy.core.invocator.ApogyCoreInvocatorFacade;
import org.eclipse.apogy.core.invocator.Variable;
import org.eclipse.apogy.core.invocator.VariableFeatureReference;
import org.eclipse.apogy.core.invocator.listeners.AbstractVariableFeatureReferenceListener;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CameraViewConfigurationCustomImpl
extends CameraViewConfigurationImpl {
    private static final Logger Logger = LoggerFactory.getLogger(CameraViewConfigurationImpl.class);
    private AbstractVariableFeatureReferenceListener abstractVariableFeatureReferenceListener = null;
    protected static final String IMAGE_AUTO_SAVE_FOLDER_PATH_EDEFAULT = System.getProperty("java.io.tmpdir");

    public void setVariable(Variable newVariable) {
        super.setVariable(newVariable);
        this.getAbstractVariableFeatureReferenceListener().setVariableFeatureReference((VariableFeatureReference)this);
    }

    @Override
    public void setCamera(AbstractCamera newCamera) {
        super.setCamera(newCamera);
        if (this.getToolList() != null && !this.getToolList().getTools().isEmpty()) {
            for (CameraTool cameraTool : this.getToolList().getTools()) {
                cameraTool.initializeCamera(newCamera);
            }
        }
    }

    @Override
    public CameraOverlayList getOverlayList() {
        CameraOverlayList tmp = super.getOverlayList();
        if (tmp == null) {
            tmp = ApogyAddonsSensorsImagingCameraFactory.eINSTANCE.createCameraOverlayList();
            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsSensorsImagingCameraPackage.Literals.CAMERA_VIEW_CONFIGURATION__OVERLAY_LIST, (Object)tmp);
        }
        return tmp;
    }

    @Override
    public CameraToolList getToolList() {
        CameraToolList tmp = super.getToolList();
        if (tmp == null) {
            tmp = ApogyAddonsSensorsImagingCameraFactory.eINSTANCE.createCameraToolList();
            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsSensorsImagingCameraPackage.Literals.CAMERA_VIEW_CONFIGURATION__TOOL_LIST, (Object)tmp);
        }
        return tmp;
    }

    @Override
    public FilterList getFilterList() {
        FilterList tmp = super.getFilterList();
        if (tmp == null) {
            tmp = ApogyAddonsSensorsImagingCameraFactory.eINSTANCE.createFilterList();
            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsSensorsImagingCameraPackage.Literals.CAMERA_VIEW_CONFIGURATION__FILTER_LIST, (Object)tmp);
        }
        return tmp;
    }

    @Override
    public List<CameraImageAnnotation> getCameraImageAnnotations() {
        ArrayList<CameraImageAnnotation> list = new ArrayList<CameraImageAnnotation>();
        list.addAll((Collection<CameraImageAnnotation>)this.getOverlayList().getOverlays());
        list.addAll((Collection<CameraImageAnnotation>)this.getToolList().getTools());
        return list;
    }

    private AbstractCamera resolveCamera() {
        AbstractCamera cam = null;
        try {
            EObject instance = ApogyCoreInvocatorFacade.INSTANCE.getInstance((VariableFeatureReference)this);
            if (instance instanceof AbstractCamera) {
                cam = (AbstractCamera)instance;
            }
        }
        catch (Throwable t) {
            Logger.error("Failed to resolve camera!", t);
        }
        return cam;
    }

    private AbstractVariableFeatureReferenceListener getAbstractVariableFeatureReferenceListener() {
        if (this.abstractVariableFeatureReferenceListener == null) {
            this.abstractVariableFeatureReferenceListener = new AbstractVariableFeatureReferenceListener(this){

                protected void instanceChanged(EObject oldInstance, EObject newInstance) {
                    if (oldInstance != null || newInstance != null) {
                        CameraViewConfigurationCustomImpl.this.setCamera(CameraViewConfigurationCustomImpl.this.resolveCamera());
                    }
                }
            };
        }
        return this.abstractVariableFeatureReferenceListener;
    }
}

