/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.sensors.imaging.camera.impl;

import javax.measure.unit.Unit;
import org.eclipse.apogy.addons.sensors.imaging.AbstractCamera;
import org.eclipse.apogy.addons.sensors.imaging.camera.OverlayAlignment;
import org.eclipse.apogy.addons.sensors.imaging.camera.impl.EMFFeatureAzimuthElevationFOVOverlayImpl;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFacade;
import org.eclipse.apogy.common.images.AbstractEImage;
import org.eclipse.apogy.core.invocator.ApogyCoreInvocatorFacade;
import org.eclipse.apogy.core.invocator.VariableFeatureReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;

public class EMFFeatureAzimuthElevationFOVOverlayCustomImpl
extends EMFFeatureAzimuthElevationFOVOverlayImpl {
    private final Unit<?> degreeUnits = Unit.valueOf((CharSequence)"\u00b0");

    @Override
    public AbstractEImage applyOverlay(AbstractCamera camera, AbstractEImage cameraImage, OverlayAlignment overlayAlignment, int overlayWidth, int overlayHeight) {
        try {
            this.changeAzimuth(this.getAzimuth());
            this.changeElevation(this.getElevation());
            return super.applyOverlay(camera, cameraImage, overlayAlignment, overlayWidth, overlayHeight);
        }
        catch (Throwable t) {
            return cameraImage;
        }
    }

    protected double getAzimuth() {
        return this.getValue(this.getAzimuthFeatureReference());
    }

    protected double getElevation() {
        return this.getValue(this.getElevationFeatureReference());
    }

    protected double getValue(VariableFeatureReference variableFeatureReference) {
        Number featureValue = (Number)ApogyCoreInvocatorFacade.INSTANCE.getEMFFeatureValue(variableFeatureReference);
        EStructuralFeature eTypedElement = ApogyCommonEMFFacade.INSTANCE.getLastFeature(variableFeatureReference.getFeaturePath());
        Unit units = ApogyCommonEMFFacade.INSTANCE.getEngineeringUnits((ETypedElement)eTypedElement);
        double value = featureValue.doubleValue();
        if (units != null) {
            value = units.getConverterTo(this.getDegreesUnits()).convert(value);
        }
        return value;
    }

    protected Unit<?> getDegreesUnits() {
        return this.degreeUnits;
    }
}

