/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.vehicle.impl;

import org.eclipse.apogy.addons.geometry.paths.ApogyAddonsGeometryPathsFactory;
import org.eclipse.apogy.addons.geometry.paths.WayPointPath;
import org.eclipse.apogy.addons.geometry.paths.WayPointPathBinding;
import org.eclipse.apogy.addons.vehicle.PathPlannerTool;
import org.eclipse.apogy.addons.vehicle.impl.PathPlannerToolNodeImpl;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.notify.impl.AdapterImpl;

public class PathPlannerToolNodeCustomImpl
extends PathPlannerToolNodeImpl {
    private Adapter adapter = null;
    private WayPointPath plannedPathLocal = null;
    private WayPointPathBinding binding = null;

    @Override
    public NotificationChain basicSetPathPlannerTool(PathPlannerTool newPathPlannerTool, NotificationChain msgs) {
        this.internalUpdatePathPlannerTool(this.pathPlannerTool, newPathPlannerTool);
        return super.basicSetPathPlannerTool(newPathPlannerTool, msgs);
    }

    @Override
    public void setPathPlannerTool(PathPlannerTool newPathPlannerTool) {
        this.internalUpdatePathPlannerTool(this.pathPlannerTool, newPathPlannerTool);
        super.setPathPlannerTool(newPathPlannerTool);
    }

    private void internalUpdatePathPlannerTool(PathPlannerTool oldPathPlannerTool, PathPlannerTool newPathPlannerTool) {
        if (oldPathPlannerTool != null) {
            oldPathPlannerTool.eAdapters().remove((Object)this.getAdapter());
            this.updateWayPointPath(null);
        }
        this.getChildren().clear();
        if (newPathPlannerTool != null) {
            newPathPlannerTool.eAdapters().add((Object)this.getAdapter());
            this.updateWayPointPath(newPathPlannerTool.getPlannedPath());
        }
    }

    protected void updateWayPointPath(WayPointPath newWayPointPath) {
        if (this.plannedPathLocal != null) {
            this.getChildren().remove((Object)this.plannedPathLocal);
        }
        if (this.binding != null) {
            this.binding.setTargetWayPointPath(null);
            this.binding.setSourceWayPointPath(null);
        }
        if (newWayPointPath != null) {
            this.plannedPathLocal = ApogyAddonsGeometryPathsFactory.eINSTANCE.createWayPointPath();
            this.plannedPathLocal.setNodeId(newWayPointPath.getNodeId());
            this.plannedPathLocal.setDescription(newWayPointPath.getDescription());
            this.binding = new WayPointPathBinding(newWayPointPath, this.plannedPathLocal);
            this.getChildren().add((Object)this.plannedPathLocal);
        }
    }

    protected Adapter getAdapter() {
        if (this.adapter == null) {
            this.adapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (msg.getNotifier() instanceof PathPlannerTool) {
                        int featureId = msg.getFeatureID(PathPlannerTool.class);
                        switch (featureId) {
                            case 23: {
                                PathPlannerToolNodeCustomImpl.this.updateWayPointPath((WayPointPath)msg.getNewValue());
                                break;
                            }
                        }
                    }
                }
            };
        }
        return this.adapter;
    }
}

