/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.emf.ui.emfforms.wizards;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFacade;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFactory;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.emf.ENamedElementReferencesList;
import org.eclipse.apogy.common.emf.ui.EClassSettings;
import org.eclipse.apogy.common.emf.ui.WizardPagesProvider;
import org.eclipse.apogy.common.emf.ui.WizardPagesProviderRegistry;
import org.eclipse.apogy.common.emf.ui.emfforms.wizards.AbstractWizard;
import org.eclipse.apogy.common.emf.ui.emfforms.wizards.EMFFormsWizardPage;
import org.eclipse.apogy.common.emf.ui.emfforms.wizards.ENamedDescribedElementWizardPage;
import org.eclipse.apogy.common.emf.ui.emfforms.wizards.ENamedElementsListWizardPage;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EObjectWizard<RootEObject extends EObject, ResolvedEObject extends EObject, ItemEObject extends EObject>
extends AbstractWizard<RootEObject, ResolvedEObject, ItemEObject> {
    private static final Logger Logger = LoggerFactory.getLogger(EObjectWizard.class);
    public static final String EREFERENCES_LIST_PAGE_ID = "org.eclipse.apogy.common.emf.ui.emfforms.wizards.EObjectWizard.EReferencesListWizardPage";
    public static final String ECLASSES_LIST_PAGE_ID = "org.eclipse.apogy.common.emf.ui.emfforms.wizards.EObjectWizard.EClassesListWizardPage";
    private EClass filterEClass = null;
    private EClass selectedEClass = null;
    private ENamedElementsListWizardPage<ENamedElementReferencesList<EReference>, EReference> eReferencesListWizardPage;
    private ENamedElementsListWizardPage<ENamedElementReferencesList<EClass>, EClass> eClassesListWizardPage;
    private WizardPagesProvider pagesProvider;
    private int firstContributedPageIndex = 0;
    private EReference eReference;

    public EObjectWizard(RootEObject rootEObject) {
        this(rootEObject, null, null, null, null);
    }

    public EObjectWizard(RootEObject rootEObject, EClassSettings settings) {
        this(rootEObject, null, null, null, settings);
    }

    public EObjectWizard(RootEObject rootEObject, FeaturePath featurePath, EReference eReference) {
        this(rootEObject, featurePath, eReference, null, null);
    }

    public EObjectWizard(RootEObject rootEObject, FeaturePath featurePath, EReference eReference, EClassSettings settings) {
        this(rootEObject, featurePath, eReference, null, settings);
    }

    public EObjectWizard(RootEObject rootEObject, FeaturePath featurePath, EReference eReference, EClass eClass, EClassSettings settings) {
        super(rootEObject, featurePath, (EStructuralFeature)eReference, settings);
        this.filterEClass = eClass;
        this.eReference = eReference;
    }

    public EReference getEReference() {
        return this.eReference;
    }

    public void addPages() {
        List<EClass> compatibleEClasses;
        if (this.eReference == null) {
            EList eAllReferences = this.getResolvedEObject().eClass().getEAllReferences();
            ArrayList<EReference> eReferences = new ArrayList<EReference>();
            for (EReference eReference : eAllReferences) {
                if (!eReference.isContainment()) continue;
                eReferences.add(eReference);
            }
            if (eReferences != null && eReferences.size() == 1) {
                this.eReference = (EReference)eReferences.get(0);
            } else {
                this.eReferencesListWizardPage = new ENamedElementsListWizardPage<ENamedElementReferencesList<EReference>, EReference>(null, null){

                    @Override
                    protected void configurePage() {
                        super.configurePage();
                        this.setTitle("Feature Selection");
                        this.setDescription("Please select the feature that will contain the instance to create");
                    }

                    @Override
                    protected void selectionChanged(IStructuredSelection currentSelection) {
                        if (!this.getSelectedItemObjects().isEmpty()) {
                            EObjectWizard.this.eReference = (EReference)this.getSelectedItemObjects().get(0);
                        }
                    }
                };
                ENamedElementReferencesList list = ApogyCommonEMFFactory.eINSTANCE.createENamedElementReferencesList();
                list.getElements().addAll(eReferences);
                this.eReferencesListWizardPage.setRootEObject(list);
                this.addPage((IWizardPage)this.eReferencesListWizardPage);
                this.selectedEClass = null;
            }
        }
        if ((compatibleEClasses = this.getCompatibleSubEClasses()) != null && compatibleEClasses.size() == 1) {
            this.selectedEClass = compatibleEClasses.get(0);
        } else {
            this.eClassesListWizardPage = new ENamedElementsListWizardPage<ENamedElementReferencesList<EClass>, EClass>(null, null){

                @Override
                protected void configurePage() {
                    super.configurePage();
                    this.setTitle("EClass Selection");
                    this.setDescription("Please select the class to instantiate.");
                }

                public void setVisible(boolean visible) {
                    if (visible) {
                        List subEClasses = EObjectWizard.this.getCompatibleSubEClasses();
                        ENamedElementReferencesList list = ApogyCommonEMFFactory.eINSTANCE.createENamedElementReferencesList();
                        list.getElements().addAll((Collection)ApogyCommonEMFFacade.INSTANCE.sortAlphabetically(subEClasses));
                        EObjectWizard.this.eClassesListWizardPage.setRootEObject(list);
                    }
                    super.setVisible(visible);
                }

                @Override
                protected void selectionChanged(IStructuredSelection currentSelection) {
                    if (!this.getSelectedItemObjects().isEmpty()) {
                        EObjectWizard.this.addContributedPages((EClass)this.getSelectedItemObjects().get(0));
                    }
                }
            };
            this.addPage((IWizardPage)this.eClassesListWizardPage);
        }
        if (this.getPages().length == 0 && this.selectedEClass != null) {
            this.addContributedPages(this.selectedEClass);
        }
        if (this.getPages().length == 0 || this.getPages().length == 1 && this.getPages()[0].getClass() == ENamedDescribedElementWizardPage.class) {
            Logger.warn("There is no wizard page for :\n" + this.getResolvedEObject() + "\nDefault page is provided.");
            this.addPage((IWizardPage)new EMFFormsWizardPage(this.getRootEObject(), this.getFeaturePath(), (EStructuralFeature)this.getEReference()));
        }
    }

    private List<EClass> getCompatibleSubEClasses() {
        if (this.filterEClass == null && this.eReference != null) {
            this.filterEClass = this.eReference.getEReferenceType();
        }
        List compatibleEClasses = ApogyCommonEMFFacade.INSTANCE.getAllSubEClasses(this.filterEClass);
        return compatibleEClasses;
    }

    private void addContributedPages(EClass eClass) {
        this.pagesProvider = WizardPagesProviderRegistry.INSTANCE.getProvider(eClass);
        EList pages = this.pagesProvider.getPages(eClass, this.getEClassSettings());
        this.firstContributedPageIndex = this.getPageCount();
        for (WizardPage page : pages) {
            this.addPage((IWizardPage)page);
        }
    }

    public IWizardPage getNextPage(IWizardPage page) {
        List subEClasses;
        IWizardPage nextPage = super.getNextPage(page);
        if (page == this.eReferencesListWizardPage && this.eReference != null && (subEClasses = ApogyCommonEMFFacade.INSTANCE.getAllSubEClasses(this.eReference.getEReferenceType())).size() == 1) {
            this.selectedEClass = (EClass)subEClasses.get(0);
            this.addContributedPages(this.selectedEClass);
            if (this.firstContributedPageIndex != 0) {
                nextPage = this.getPages()[this.firstContributedPageIndex];
            }
        }
        if (page == this.eClassesListWizardPage && this.firstContributedPageIndex != 0) {
            nextPage = this.getPages()[this.firstContributedPageIndex];
        }
        return nextPage;
    }

    public EObject getCreatedEObject() {
        return this.pagesProvider == null ? null : this.pagesProvider.getEObject();
    }

    public boolean performFinish() {
        String errorMessage = "";
        Exception exception = null;
        if (this.eReference.isMany()) {
            try {
                ApogyCommonTransactionFacade.INSTANCE.basicAdd(this.getResolvedEObject(), (EStructuralFeature)this.eReference, (Object)this.getCreatedEObject(), true);
            }
            catch (Exception e) {
                errorMessage = "Unable to add the object:\n";
                exception = e;
            }
        } else {
            try {
                ApogyCommonTransactionFacade.INSTANCE.basicSet(this.getResolvedEObject(), (EStructuralFeature)this.eReference, (Object)this.getCreatedEObject(), true);
            }
            catch (Exception e) {
                errorMessage = "Unable to set the object:\n";
                exception = e;
            }
        }
        if (!errorMessage.isEmpty()) {
            errorMessage = String.valueOf(errorMessage) + "\t-Container: " + this.getResolvedEObject() + "\n" + "\t-Feature  : " + this.eReference.getName() + "\n" + "\t-Object   : " + this.getCreatedEObject();
            Logger.error(errorMessage, (Throwable)exception);
            MessageDialog.openError((Shell)this.getShell(), (String)"New Object Error", (String)errorMessage);
        }
        return errorMessage.isEmpty();
    }

    public boolean canFinish() {
        boolean result = true;
        if (this.eReferencesListWizardPage != null && !this.eReferencesListWizardPage.isPageComplete()) {
            result = false;
        }
        if (this.eClassesListWizardPage != null && !this.eClassesListWizardPage.isPageComplete()) {
            result = false;
        }
        int i = this.firstContributedPageIndex;
        while (i < this.getPageCount()) {
            if (!this.getPages()[i].isPageComplete()) {
                result = false;
            }
            ++i;
        }
        return result;
    }
}

