/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.emf.ui.composites;

import org.eclipse.apogy.common.emf.ApogyCommonEMFFacade;
import org.eclipse.apogy.common.emf.ui.ApogyCommonEMFUIFactory;
import org.eclipse.apogy.common.emf.ui.EObjectCompositeSettings;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEObjectComposite<RootEObject extends EObject, ResolvedEObject extends EObject, ItemObject>
extends Composite {
    private final FormToolkit formToolkit = new FormToolkit(Display.getCurrent());
    private static final Logger Logger = LoggerFactory.getLogger(AbstractEObjectComposite.class);
    private WritableValue<RootEObject> rootEObjectWritableValue;
    private WritableValue<ResolvedEObject> resolvedEObjectWritableValue;
    private WritableValue<ItemObject> itemObjectWritableValue;
    private FeaturePath featurePath;
    private EStructuralFeature eStructuralFeature;
    private DataBindingContext dataBindingContext = new DataBindingContext();
    protected Composite parentComposite;
    private ScrolledComposite contentCompositeWrapper;
    private Composite contentComposite;
    private FillLayout contentCompositeWrapperLayout;
    private EObjectCompositeSettings settings;
    private Adapter resolveObjectAdapter = null;

    public AbstractEObjectComposite(Composite parent, int style) {
        this(parent, style, null, null, null);
    }

    public AbstractEObjectComposite(Composite parent, int style, FeaturePath featurePath) {
        this(parent, style, featurePath, null, null);
    }

    public AbstractEObjectComposite(Composite parent, int style, FeaturePath featurePath, EStructuralFeature eStructuralFeature) {
        this(parent, style, featurePath, eStructuralFeature, null);
    }

    public AbstractEObjectComposite(Composite parent, int style, FeaturePath featurePath, EStructuralFeature eStructuralFeature, EObjectCompositeSettings settings) {
        super(parent, style);
        this.rootEObjectWritableValue = new WritableValue();
        this.resolvedEObjectWritableValue = new WritableValue();
        this.itemObjectWritableValue = new WritableValue();
        this.featurePath = featurePath;
        this.eStructuralFeature = eStructuralFeature;
        this.settings = settings;
        if (settings == null) {
            this.settings = this.createDefaultSettings();
        }
        this.addListener(12, e -> {
            this.getFormToolkit().dispose();
            this.getDataBindingContext().dispose();
        });
        this.parentComposite = parent;
        this.setLayout((Layout)new FillLayout());
        this.contentCompositeWrapper = new ScrolledComposite((Composite)this, 768);
        this.contentCompositeWrapper.setAlwaysShowScrollBars(false);
        this.contentCompositeWrapper.setExpandVertical(true);
        this.contentCompositeWrapper.setExpandHorizontal(true);
        this.contentCompositeWrapperLayout = new FillLayout();
        this.contentCompositeWrapperLayout.marginHeight = 0;
        this.contentCompositeWrapperLayout.marginWidth = 0;
        this.contentCompositeWrapper.setLayout((Layout)new FillLayout());
        this.contentComposite = this.createContentComposite((Composite)this.contentCompositeWrapper, 0);
        this.contentCompositeWrapper.setContent((Control)this.contentComposite);
        this.rootEObjectWritableValue.addValueChangeListener(s -> {
            this.updateResolvedEObject(this.getRootEObject());
            this.internalRootEObjectChanged(this.getRootEObject(), this.getResolvedEObject());
            this.rootEObjectChanged(this.getRootEObject());
        });
        this.resolvedEObjectWritableValue.addValueChangeListener(s -> {
            this.resolvedEObjectChanged((EObject)this.resolvedEObjectWritableValue.getValue());
            this.updateItemObject((EObject)this.resolvedEObjectWritableValue.getValue());
        });
        this.itemObjectWritableValue.addValueChangeListener(s -> this.itemObjectChanged(this.itemObjectWritableValue.getValue()));
    }

    private void updateItemObject(ResolvedEObject resolvedObject) {
        Object itemObject = null;
        if (resolvedObject != null) {
            itemObject = null;
            itemObject = ApogyCommonEMFFacade.INSTANCE.resolveValue(this.getRootEObject(), this.getFeaturePath(), this.getEStructuralFeature());
            if (itemObject == null) {
                Logger.error(String.format("%s: RUNTIME ERROR!!! Unable to resolve:\n-ResolvedObject: %s\n-EStructuralFeature: %s.", ((Object)((Object)this)).getClass().getName(), this.getResolvedEObject(), this.getEStructuralFeature() == null ? "undefined" : this.getEStructuralFeature().toString()));
            }
            this.itemObjectWritableValue.setValue(itemObject);
        }
    }

    protected void resolvedEObjectChanged(ResolvedEObject value) {
    }

    protected abstract Composite createContentComposite(Composite var1, int var2);

    public final WritableValue<RootEObject> getRootEObjectWritableValue() {
        return this.rootEObjectWritableValue;
    }

    public final RootEObject getRootEObject() {
        return (RootEObject)((EObject)this.rootEObjectWritableValue.getValue());
    }

    public void setRootEObject(RootEObject rootEObject) {
        this.getDisplay().asyncExec(() -> this.rootEObjectWritableValue.setValue((Object)rootEObject));
    }

    public final FeaturePath getFeaturePath() {
        return this.featurePath;
    }

    public final EStructuralFeature getEStructuralFeature() {
        return this.eStructuralFeature;
    }

    public final EObjectCompositeSettings getCompositeSettings() {
        return this.settings != null ? this.settings : this.createDefaultSettings();
    }

    protected EObjectCompositeSettings createDefaultSettings() {
        return ApogyCommonEMFUIFactory.eINSTANCE.createEObjectCompositeSettings();
    }

    public final DataBindingContext getDataBindingContext() {
        return this.dataBindingContext;
    }

    private void updateResolvedEObject(RootEObject rootEObject) {
        if (this.getResolvedEObject() != null) {
            this.getResolvedEObject().eAdapters().remove((Object)this.getResolvedObjectAdapter());
        }
        Object resolvedEObject = null;
        if (rootEObject != null) {
            resolvedEObject = null;
            resolvedEObject = this.processResolvedEObject(rootEObject, this.getFeaturePath());
            if (resolvedEObject == null) {
                Logger.error(String.format("%s: RUNTIME ERROR!!! Unable to resolve:\n-RootObject: %s\n-FeaturePath: %s.", ((Object)((Object)this)).getClass().getName(), rootEObject, this.getFeaturePath()));
            } else {
                resolvedEObject.eAdapters().add((Object)this.getResolvedObjectAdapter());
            }
            this.resolvedEObjectWritableValue.setValue(resolvedEObject);
        }
    }

    protected ResolvedEObject processResolvedEObject(RootEObject rootEObject, FeaturePath featurePath) {
        return (ResolvedEObject)ApogyCommonEMFFacade.INSTANCE.resolveOwner(rootEObject, featurePath);
    }

    public WritableValue<ResolvedEObject> getResolvedEObjectWritableValue() {
        return this.resolvedEObjectWritableValue;
    }

    public ResolvedEObject getResolvedEObject() {
        return (ResolvedEObject)((EObject)this.getResolvedEObjectWritableValue().getValue());
    }

    public WritableValue<ItemObject> getItemObjectWritableValue() {
        return this.itemObjectWritableValue;
    }

    public ItemObject getItemObject() {
        return (ItemObject)this.itemObjectWritableValue.getValue();
    }

    public void fireItemObjectChanged() {
        this.itemObjectChanged(this.getItemObject());
    }

    protected void itemObjectChanged(ItemObject itemObject) {
    }

    protected void internalRootEObjectChanged(RootEObject rootObject, ResolvedEObject resolvedEObject) {
    }

    protected void rootEObjectChanged(RootEObject rootEObject) {
    }

    public FormToolkit getFormToolkit() {
        return this.formToolkit;
    }

    protected Adapter getResolvedObjectAdapter() {
        if (this.resolveObjectAdapter == null) {
            this.resolveObjectAdapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (msg.getFeature() == AbstractEObjectComposite.this.getEStructuralFeature()) {
                        AbstractEObjectComposite.this.updateItemObject(AbstractEObjectComposite.this.getResolvedEObject());
                    }
                }
            };
        }
        return this.resolveObjectAdapter;
    }
}

