/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.emf.ui.preferences;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.apogy.common.emf.ui.Activator;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateListStrategy;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class NativeDecimalFormatComposite
extends Composite {
    private DataBindingContext bindingContext;
    private final Text doubleText;
    private final Text floatText;
    private final Text byteText;
    private final Text shortText;
    private final Text intText;
    private final Text longText;
    private final List<Text> textList;

    public NativeDecimalFormatComposite(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(2, false));
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (NativeDecimalFormatComposite.this.bindingContext != null) {
                    NativeDecimalFormatComposite.this.bindingContext.dispose();
                }
            }
        });
        this.textList = new ArrayList<Text>();
        Button infoButton = new Button((Composite)this, 0);
        infoButton.setLayoutData((Object)new GridData(131072, 4, false, true, 2, 1));
        ImageDescriptor image = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.jface", (String)"/icons/full/message_info.png");
        infoButton.setImage(image.createImage());
        infoButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String message = "0\trepresents a digit\n#\trepresents a digit, zero shows as absent\n.\trepresents a placeholder for decimal separator\n,\trepresents a placeholder for grouping separator\n\nExamples with input 123123.123:\n\t- 000000000.000000 : " + new DecimalFormat("000000000.000000").format(123123.123) + "\n\t- #########.###### : " + new DecimalFormat("#########.######").format(123123.123) + "\n\t- ###,###.### : " + new DecimalFormat("###,###.###").format(123123.123);
                MessageDialog.openInformation((Shell)NativeDecimalFormatComposite.this.getShell(), (String)"Synthax", (String)message);
            }
        });
        Label doubleLabel = new Label((Composite)this, 0);
        doubleLabel.setText("Double float :");
        doubleLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.doubleText = new Text((Composite)this, 2048);
        this.doubleText.setText(" ");
        this.doubleText.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.textList.add(this.doubleText);
        Label floatLabel = new Label((Composite)this, 0);
        floatLabel.setText("Floating point :");
        floatLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.floatText = new Text((Composite)this, 2048);
        this.floatText.setText(" ");
        this.floatText.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.textList.add(this.floatText);
        Label byteLabel = new Label((Composite)this, 0);
        byteLabel.setText("Byte :");
        byteLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.byteText = new Text((Composite)this, 2048);
        this.byteText.setText(" ");
        this.byteText.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.textList.add(this.byteText);
        Label shortLabel = new Label((Composite)this, 0);
        shortLabel.setText("Short integer :");
        shortLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.shortText = new Text((Composite)this, 2048);
        this.shortText.setText(" ");
        this.shortText.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.textList.add(this.shortText);
        Label intLabel = new Label((Composite)this, 0);
        intLabel.setText("Integer :");
        intLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.intText = new Text((Composite)this, 2048);
        this.intText.setText(" ");
        this.intText.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.textList.add(this.intText);
        Label longLabel = new Label((Composite)this, 0);
        longLabel.setText("Long integer :");
        longLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.longText = new Text((Composite)this, 2048);
        this.longText.setText(" ");
        this.longText.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.textList.add(this.longText);
        this.updateTexts();
        this.initDataBindings();
    }

    public void updateTexts() {
        this.doubleText.setText(Activator.getDefault().getPreferenceStore().getString("NATIVE_FORMAT_DOUBLE_ID"));
        this.floatText.setText(Activator.getDefault().getPreferenceStore().getString("NATIVE_FORMAT_FLOAT_ID"));
        this.byteText.setText(Activator.getDefault().getPreferenceStore().getString("NATIVE_FORMAT_BYTE_ID"));
        this.shortText.setText(Activator.getDefault().getPreferenceStore().getString("NATIVE_FORMAT_SHORT_ID"));
        this.intText.setText(Activator.getDefault().getPreferenceStore().getString("NATIVE_FORMAT_INT_ID"));
        this.longText.setText(Activator.getDefault().getPreferenceStore().getString("NATIVE_FORMAT_LONG_ID"));
    }

    private void initDataBindings() {
        if (this.bindingContext != null) {
            this.bindingContext.dispose();
        }
        this.bindingContext = new DataBindingContext();
        UpdateValueStrategy policyNever = new UpdateValueStrategy(UpdateListStrategy.POLICY_NEVER);
        UpdateValueStrategy validFormatUpdateStrategy = new UpdateValueStrategy(UpdateListStrategy.POLICY_UPDATE).setConverter((IConverter)new Converter(String.class, Color.class){

            public Object convert(Object fromObject) {
                if (fromObject != null && NativeDecimalFormatComposite.this.isValid((String)fromObject)) {
                    return NativeDecimalFormatComposite.this.getDisplay().getSystemColor(37);
                }
                return NativeDecimalFormatComposite.this.getDisplay().getSystemColor(3);
            }
        });
        for (Text text : this.textList) {
            ISWTObservableValue textText = WidgetProperties.text((int)24).observe((Widget)text);
            ISWTObservableValue backgroundText = WidgetProperties.background().observe((Widget)text);
            this.bindingContext.bindValue((IObservableValue)backgroundText, (IObservableValue)textText, policyNever, validFormatUpdateStrategy);
        }
    }

    public void savePreferences() {
        if (this.isValid(this.doubleText.getText())) {
            Activator.getDefault().getPreferenceStore().setValue("NATIVE_FORMAT_DOUBLE_ID", this.doubleText.getText());
        }
        if (this.isValid(this.floatText.getText())) {
            Activator.getDefault().getPreferenceStore().setValue("NATIVE_FORMAT_FLOAT_ID", this.floatText.getText());
        }
        if (this.isValid(this.byteText.getText())) {
            Activator.getDefault().getPreferenceStore().setValue("NATIVE_FORMAT_BYTE_ID", this.byteText.getText());
        }
        if (this.isValid(this.shortText.getText())) {
            Activator.getDefault().getPreferenceStore().setValue("NATIVE_FORMAT_SHORT_ID", this.shortText.getText());
        }
        if (this.isValid(this.intText.getText())) {
            Activator.getDefault().getPreferenceStore().setValue("NATIVE_FORMAT_INT_ID", this.intText.getText());
        }
        if (this.isValid(this.longText.getText())) {
            Activator.getDefault().getPreferenceStore().setValue("NATIVE_FORMAT_LONG_ID", this.longText.getText());
        }
    }

    private boolean isValid(String str) {
        if ("".equals(str)) {
            return false;
        }
        int i = 0;
        while (i < str.length()) {
            char character = str.charAt(i);
            if (character != '0' && character != '.' && character != '#' && character != ',') {
                return false;
            }
            ++i;
        }
        try {
            new DecimalFormat(str);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

