/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.emf.impl;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.measure.unit.Unit;
import org.eclipse.apogy.common.emf.AbstractFeatureListNode;
import org.eclipse.apogy.common.emf.AbstractFeatureNode;
import org.eclipse.apogy.common.emf.AbstractFeatureSpecifier;
import org.eclipse.apogy.common.emf.AbstractFeatureTreeNode;
import org.eclipse.apogy.common.emf.AbstractRootNode;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFacade;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFactory;
import org.eclipse.apogy.common.emf.ApogyCommonEMFPackage;
import org.eclipse.apogy.common.emf.ApogyCommonEMFPreferences;
import org.eclipse.apogy.common.emf.ApogyPreferencesManager;
import org.eclipse.apogy.common.emf.EClassFilter;
import org.eclipse.apogy.common.emf.ListFeatureNode;
import org.eclipse.apogy.common.emf.ListRootNode;
import org.eclipse.apogy.common.emf.Named;
import org.eclipse.apogy.common.emf.Ranges;
import org.eclipse.apogy.common.emf.Startable;
import org.eclipse.apogy.common.emf.TimeInterval;
import org.eclipse.apogy.common.emf.Timed;
import org.eclipse.apogy.common.emf.TreeFeatureNode;
import org.eclipse.apogy.common.emf.impl.ApogyCommonEMFFacadeImpl;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApogyCommonEMFFacadeCustomImpl
extends ApogyCommonEMFFacadeImpl {
    private static final Logger Logger = LoggerFactory.getLogger(ApogyCommonEMFFacadeImpl.class);
    private ApogyCommonEMFPreferences prefs;
    private SimpleDateFormat simpleDateFormat = null;
    private static List<EClass> availableTypes = null;

    @Override
    public EStructuralFeature getLastFeature(FeaturePath featurePath) {
        return featurePath == null || featurePath.getFeaturePath().length == 0 ? null : featurePath.getFeaturePath()[featurePath.getFeaturePath().length - 1];
    }

    @Override
    public String toString(FeaturePath featurePath) {
        StringBuffer result = new StringBuffer();
        if (featurePath != null) {
            EStructuralFeature[] eStructuralFeatureArray = featurePath.getFeaturePath();
            int n = eStructuralFeatureArray.length;
            int n2 = 0;
            while (n2 < n) {
                EStructuralFeature eStructuralFeature = eStructuralFeatureArray[n2];
                if (eStructuralFeature != null) {
                    result.append(EcoreUtil.getURI((EObject)eStructuralFeature).toString());
                    if (eStructuralFeature != featurePath.getFeaturePath()[featurePath.getFeaturePath().length - 1]) {
                        result.append(this.getESTRUCTURAL_FEATURE__SEPARATOR());
                    }
                }
                ++n2;
            }
        }
        return result.toString();
    }

    @Override
    public FeaturePath getFeaturePath(String value) {
        EStructuralFeature[] eStructuralFeatures = null;
        if (value != null && !value.isEmpty()) {
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            String[] uris = value.split(this.getESTRUCTURAL_FEATURE__SEPARATOR());
            eStructuralFeatures = new EStructuralFeature[uris.length];
            int i = 0;
            while (i < uris.length) {
                eStructuralFeatures[i] = (EStructuralFeature)resourceSet.getEObject(URI.createURI((String)uris[i]), false);
                ++i;
            }
        }
        return eStructuralFeatures == null ? null : FeaturePath.fromList(eStructuralFeatures);
    }

    @Override
    public ApogyCommonEMFPreferences getApogyCommonEMFPreferences() {
        if (this.prefs == null) {
            this.prefs = (ApogyCommonEMFPreferences)ApogyPreferencesManager.INSTANCE.getPreferences(ApogyCommonEMFPackage.Literals.APOGY_COMMON_EMF_PREFERENCES);
            this.prefs.eAdapters().add((Object)new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    ApogyCommonEMFFacadeCustomImpl.this.simpleDateFormat = null;
                }
            });
        }
        return this.prefs;
    }

    @Override
    public List<EClass> getAllAvailableEClasses() {
        try {
            if (availableTypes == null) {
                availableTypes = new ArrayList<EClass>();
                ArrayList<EPackage> ePackages = new ArrayList<EPackage>();
                ArrayList<String> ePackagesDescriptor = new ArrayList<String>();
                Set packageSet = EPackage.Registry.INSTANCE.entrySet();
                for (Map.Entry mp_entry : packageSet) {
                    Object val = mp_entry.getValue();
                    if (val instanceof EPackage) {
                        ePackages.add((EPackage)val);
                        continue;
                    }
                    if (!(val instanceof EPackage.Descriptor)) continue;
                    ePackagesDescriptor.add((String)mp_entry.getKey());
                }
                for (String description : ePackagesDescriptor) {
                    try {
                        if (description == null) continue;
                        Logger.debug("Loading EPackage : " + description);
                        EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage(description);
                        ePackages.add(ePackage);
                    }
                    catch (Throwable t) {
                        Logger.error(t.getMessage(), t);
                    }
                }
                for (EPackage iPackage : ePackages) {
                    if (iPackage == null) continue;
                    for (EObject eObj : iPackage.eContents()) {
                        if (!(eObj instanceof EClass)) continue;
                        EClass eClass = (EClass)eObj;
                        availableTypes.add(eClass);
                    }
                }
            }
        }
        catch (Exception e) {
            Logger.error(e.getMessage(), (Throwable)e);
        }
        return availableTypes;
    }

    @Override
    public List<EClass> getAllSubEClasses(final EClass superClass) {
        List<EClass> classes = null;
        if (superClass != null) {
            EClassFilter filter = new EClassFilter(){

                @Override
                public boolean filter(EClass eClass) {
                    boolean result = superClass.isSuperTypeOf(eClass) && !eClass.isInterface() && !eClass.isAbstract();
                    return result;
                }
            };
            List<EClass> list = ApogyCommonEMFFacade.INSTANCE.getAllAvailableEClasses();
            classes = ApogyCommonEMFFacade.INSTANCE.filterEClasses(list, filter);
        }
        return classes;
    }

    @Override
    public SortedSet<EClass> sortAlphabetically(List<EClass> eClasses) {
        TreeSet<EClass> sortedTypes = new TreeSet<EClass>(new Comparator<EClass>(){

            @Override
            public int compare(EClass o1, EClass o2) {
                try {
                    if (o1.getName().compareTo(o2.getName()) == 0) {
                        return o1.getInstanceClassName().compareTo(o2.getInstanceClassName());
                    }
                    return o1.getName().compareTo(o2.getName());
                }
                catch (Exception e) {
                    Logger.error(e.getMessage(), (Throwable)e);
                    return -1;
                }
            }
        });
        for (EClass eClass : eClasses) {
            if (eClass == null || eClass.getName() == null || eClass.getInstanceClassName() == null) continue;
            sortedTypes.add(eClass);
        }
        return sortedTypes;
    }

    @Override
    public List<EOperation> getAllAvailableEOperations(EClass eClass) {
        return eClass.getEAllOperations();
    }

    @Override
    public SortedSet<EOperation> sortEOperationsAlphabetically(List<EOperation> eOperations) {
        TreeSet<EOperation> sortedTypes = new TreeSet<EOperation>(new Comparator<EOperation>(){

            @Override
            public int compare(EOperation o1, EOperation o2) {
                try {
                    return o1.getName().compareTo(o2.getName());
                }
                catch (Exception e) {
                    Logger.error(e.getMessage(), (Throwable)e);
                    return -1;
                }
            }
        });
        for (EOperation eOperation : eOperations) {
            if (eOperation == null || eOperation.getName() == null) continue;
            sortedTypes.add(eOperation);
        }
        return sortedTypes;
    }

    @Override
    public String getDocumentation(EAnnotation eAnnotation) {
        String rawDocumentation;
        EMap map;
        if (eAnnotation != null && (map = eAnnotation.getDetails()) != null && (rawDocumentation = (String)map.get((Object)"documentation")) != null) {
            return this.stripCommentDelimiters(rawDocumentation);
        }
        return null;
    }

    @Override
    public String getDocumentation(EModelElement eModelElement) {
        String documentation = this.stripCommentDelimiters(this.getEAnnotationDetailValue(this.getGenModelEAnnotation(eModelElement), "documentation"));
        if (documentation == null || documentation.isEmpty()) {
            ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
            IItemLabelProvider provider = (IItemLabelProvider)adapterFactory.adapt((Notifier)eModelElement.eContainer(), IItemLabelProvider.class);
            documentation = provider.getText((Object)eModelElement.eContainer());
        }
        return this.stripCommentDelimiters(this.getEAnnotationDetailValue(this.getGenModelEAnnotation(eModelElement), "documentation"));
    }

    @Override
    public String getDocumentation(EParameter eParameter) {
        String fullDocumentation = "";
        String name = "Name : " + eParameter.getName();
        String type = "Type : " + eParameter.getEType().getName();
        String description = this.stripCommentDelimiters(this.getEAnnotationDetailValue(this.getGenModelEAnnotation((EModelElement)eParameter), "documentation"));
        description = description == null || description.length() == 0 ? "Description : N/A" : "Description : " + description;
        String units = "" + ApogyCommonEMFFacade.INSTANCE.getEngineeringUnits((ETypedElement)eParameter);
        units = units == null || units.length() == 0 ? "Units : None" : "Units : " + units;
        Number oorMin = ApogyCommonEMFFacade.INSTANCE.getOutOfRangeMinValue((ETypedElement)eParameter);
        Number oorMax = ApogyCommonEMFFacade.INSTANCE.getOutOfRangeMaxValue((ETypedElement)eParameter);
        String oorLimits = "Out Of Range Limits : " + this.getRangeString(oorMin, oorMax);
        Number alarmMin = ApogyCommonEMFFacade.INSTANCE.getAlarmMinValue((ETypedElement)eParameter);
        Number alarmMax = ApogyCommonEMFFacade.INSTANCE.getAlarmMaxValue((ETypedElement)eParameter);
        String alarmsLimits = "Alarms Limits : " + this.getRangeString(alarmMin, alarmMax);
        Number warningMin = ApogyCommonEMFFacade.INSTANCE.getWarningMinValue((ETypedElement)eParameter);
        Number warningMax = ApogyCommonEMFFacade.INSTANCE.getWarningMaxValue((ETypedElement)eParameter);
        String warningLimits = "Warning Limits : " + this.getRangeString(warningMin, warningMax);
        fullDocumentation = String.valueOf(fullDocumentation) + name + "\n";
        fullDocumentation = String.valueOf(fullDocumentation) + type + "\n";
        fullDocumentation = String.valueOf(fullDocumentation) + description + "\n";
        fullDocumentation = String.valueOf(fullDocumentation) + units + "\n";
        fullDocumentation = String.valueOf(fullDocumentation) + oorLimits + "\n";
        fullDocumentation = String.valueOf(fullDocumentation) + alarmsLimits + "\n";
        fullDocumentation = String.valueOf(fullDocumentation) + warningLimits + "\n";
        return fullDocumentation;
    }

    @Override
    public Unit<?> getEngineeringUnits(ETypedElement eTypedElement) {
        Unit unit = null;
        String unitsAsString = this.getEngineeringUnitsAsString(eTypedElement);
        if (unitsAsString != null) {
            try {
                unit = Unit.valueOf((CharSequence)unitsAsString);
            }
            catch (Throwable t) {
                Logger.warn("No units found for <" + unitsAsString + "> !", t);
            }
        }
        return unit;
    }

    @Override
    public String getEngineeringUnitsAsString(ETypedElement eTypedElement) {
        return this.getEAnnotationDetailValue(this.getApogyEAnnotation((EModelElement)eTypedElement), "units");
    }

    @Override
    public Double getValueUpdateRate(ETypedElement eTypedElement) {
        Number number = this.getEAnnotationDetailNumberValue(this.getApogyEAnnotation((EModelElement)eTypedElement), "rate");
        return number == null ? -1.0 : number.doubleValue();
    }

    @Override
    public String getWarningOCLExpression(ETypedElement eTypedElement) {
        return this.getEAnnotationDetailValue(this.getApogyEAnnotation((EModelElement)eTypedElement), "warning.ocl");
    }

    @Override
    public String getAlarmOCLExpression(ETypedElement eTypedElement) {
        return this.getEAnnotationDetailValue(this.getApogyEAnnotation((EModelElement)eTypedElement), "alarm.ocl");
    }

    @Override
    public String getOutOfRangeOCLExpression(ETypedElement eTypedElement) {
        return this.getEAnnotationDetailValue(this.getApogyEAnnotation((EModelElement)eTypedElement), "outside.ocl");
    }

    @Override
    public Number getWarningMinValue(ETypedElement eTypedElement) {
        return this.getEAnnotationDetailNumberValue(this.getApogyEAnnotation((EModelElement)eTypedElement), "warning.min");
    }

    @Override
    public Number getWarningMaxValue(ETypedElement eTypedElement) {
        return this.getEAnnotationDetailNumberValue(this.getApogyEAnnotation((EModelElement)eTypedElement), "warning.max");
    }

    @Override
    public Number getAlarmMinValue(ETypedElement eTypedElement) {
        return this.getEAnnotationDetailNumberValue(this.getApogyEAnnotation((EModelElement)eTypedElement), "alarm.min");
    }

    @Override
    public Number getAlarmMaxValue(ETypedElement eTypedElement) {
        return this.getEAnnotationDetailNumberValue(this.getApogyEAnnotation((EModelElement)eTypedElement), "alarm.max");
    }

    @Override
    public Number getOutOfRangeMinValue(ETypedElement eTypedElement) {
        return this.getEAnnotationDetailNumberValue(this.getApogyEAnnotation((EModelElement)eTypedElement), "outside.min");
    }

    @Override
    public Number getOutOfRangeMaxValue(ETypedElement eTypedElement) {
        return this.getEAnnotationDetailNumberValue(this.getApogyEAnnotation((EModelElement)eTypedElement), "outside.max");
    }

    @Override
    public Ranges getRange(ETypedElement eTypedElement, Object value) {
        if (value instanceof Number) {
            Number number = (Number)value;
            Number outOfRangeMin = this.getOutOfRangeMinValue(eTypedElement);
            if (outOfRangeMin != null && number.doubleValue() <= outOfRangeMin.doubleValue()) {
                return Ranges.OUT_OF_RANGE;
            }
            Number alarmMin = this.getAlarmMinValue(eTypedElement);
            if (alarmMin != null && number.doubleValue() <= alarmMin.doubleValue()) {
                return Ranges.ALARM;
            }
            Number warningMin = this.getWarningMinValue(eTypedElement);
            if (warningMin != null && number.doubleValue() <= warningMin.doubleValue()) {
                return Ranges.WARNING;
            }
            Number outOfRangeMax = this.getOutOfRangeMaxValue(eTypedElement);
            if (outOfRangeMax != null && number.doubleValue() >= outOfRangeMax.doubleValue()) {
                return Ranges.OUT_OF_RANGE;
            }
            Number alarmMax = this.getAlarmMaxValue(eTypedElement);
            if (alarmMax != null && number.doubleValue() >= alarmMax.doubleValue()) {
                return Ranges.ALARM;
            }
            Number warningMax = this.getWarningMaxValue(eTypedElement);
            if (warningMax != null && number.doubleValue() >= warningMax.doubleValue()) {
                return Ranges.WARNING;
            }
            if (warningMin != null || warningMax != null || alarmMin != null || alarmMax != null || outOfRangeMin != null || outOfRangeMax != null) {
                return Ranges.NOMINAL;
            }
            return Ranges.UNKNOWN;
        }
        return Ranges.UNKNOWN;
    }

    @Override
    public String getFullDescription(ETypedElement eTypedElement) {
        String fullDocumentation = "";
        String description = "Description : " + ApogyCommonEMFFacade.INSTANCE.getDocumentation((EModelElement)eTypedElement);
        String units = "Units : " + ApogyCommonEMFFacade.INSTANCE.getEngineeringUnits(eTypedElement);
        Number oorMin = ApogyCommonEMFFacade.INSTANCE.getOutOfRangeMinValue(eTypedElement);
        Number oorMax = ApogyCommonEMFFacade.INSTANCE.getOutOfRangeMaxValue(eTypedElement);
        String oorLimits = "Out Of Range Limits : " + this.getRangeString(oorMin, oorMax);
        Number alarmMin = ApogyCommonEMFFacade.INSTANCE.getAlarmMinValue(eTypedElement);
        Number alarmMax = ApogyCommonEMFFacade.INSTANCE.getAlarmMaxValue(eTypedElement);
        String alarmsLimits = "Alarms Limits : " + this.getRangeString(alarmMin, alarmMax);
        Number warningMin = ApogyCommonEMFFacade.INSTANCE.getWarningMinValue(eTypedElement);
        Number warningMax = ApogyCommonEMFFacade.INSTANCE.getWarningMaxValue(eTypedElement);
        String warningLimits = "Warning Limits : " + this.getRangeString(warningMin, warningMax);
        fullDocumentation = String.valueOf(fullDocumentation) + description + "\n";
        fullDocumentation = String.valueOf(fullDocumentation) + units + "\n";
        fullDocumentation = String.valueOf(fullDocumentation) + oorLimits + "\n";
        fullDocumentation = String.valueOf(fullDocumentation) + alarmsLimits + "\n";
        fullDocumentation = String.valueOf(fullDocumentation) + warningLimits + "\n";
        return fullDocumentation;
    }

    private String getRangeString(Number min, Number max) {
        String rangeString = "";
        rangeString = min != null && max != null ? String.valueOf(min.toString()) + " > value > " + max.toString() : (min != null && max == null ? String.valueOf(min.toString()) + " > value" : (min == null && max != null ? "value > " + max.toString() : "N/A"));
        return rangeString;
    }

    @Override
    public String getAncestriesString(AbstractFeatureNode abstractFeatureNode) {
        String result = "";
        List<AbstractFeatureNode> ancestries = this.getAncestries(abstractFeatureNode);
        Iterator<AbstractFeatureNode> it = ancestries.iterator();
        while (it.hasNext()) {
            AbstractFeatureSpecifier abstractFeatureSpecifier;
            AbstractFeatureNode node = it.next();
            if (!(node instanceof AbstractFeatureSpecifier) || (abstractFeatureSpecifier = (AbstractFeatureSpecifier)((Object)node)).getStructuralFeature() == null) continue;
            result = String.valueOf(result) + abstractFeatureSpecifier.getStructuralFeature().getName();
            if (abstractFeatureSpecifier.isMultiValued()) {
                result = String.valueOf(result) + "[" + abstractFeatureSpecifier.getIndex() + "]";
            }
            if (!it.hasNext()) continue;
            result = String.valueOf(result) + ".";
        }
        return result;
    }

    @Override
    public AbstractRootNode getFeatureRoot(AbstractFeatureNode abstractFeatureNode) {
        if (abstractFeatureNode instanceof AbstractRootNode) {
            return (AbstractRootNode)((Object)abstractFeatureNode);
        }
        AbstractRootNode root = null;
        AbstractFeatureNode node = abstractFeatureNode;
        while (root == null && node != null) {
            if (node instanceof AbstractRootNode) {
                root = (AbstractRootNode)((Object)node);
                continue;
            }
            if (node instanceof ListFeatureNode) {
                node = ((ListFeatureNode)node).getParent();
                continue;
            }
            if (!(node instanceof TreeFeatureNode)) continue;
            node = ((TreeFeatureNode)node).getParent();
        }
        return root;
    }

    @Override
    public List<AbstractFeatureNode> getAncestries(AbstractFeatureNode abstractFeatureNode) {
        ArrayList<AbstractFeatureNode> ancestries = new ArrayList<AbstractFeatureNode>();
        AbstractFeatureNode feature = abstractFeatureNode;
        while (feature != null) {
            ancestries.add(0, feature);
            if (feature instanceof ListFeatureNode) {
                feature = ((ListFeatureNode)feature).getParent();
                continue;
            }
            if (feature instanceof TreeFeatureNode) {
                feature = ((TreeFeatureNode)feature).getParent();
                continue;
            }
            if (!(feature instanceof AbstractRootNode)) continue;
            feature = null;
        }
        return ancestries;
    }

    @Override
    public List<AbstractFeatureNode> getDescendants(AbstractFeatureNode abstractFeatureNode) {
        ArrayList<AbstractFeatureNode> descendants = new ArrayList<AbstractFeatureNode>();
        AbstractFeatureNode node = abstractFeatureNode;
        if (node instanceof AbstractFeatureTreeNode) {
            this.getDescendants((AbstractFeatureTreeNode)node, descendants);
        } else if (node instanceof AbstractFeatureListNode) {
            AbstractFeatureListNode abstractFeatureListNode = (AbstractFeatureListNode)node;
            this.getDescendants(abstractFeatureListNode, descendants);
        }
        return descendants;
    }

    private void getDescendants(AbstractFeatureTreeNode abstractFeatureTreeNode, List<AbstractFeatureNode> descendants) {
        descendants.addAll((Collection<AbstractFeatureNode>)abstractFeatureTreeNode.getChildren());
        for (AbstractFeatureTreeNode child : abstractFeatureTreeNode.getChildren()) {
            this.getDescendants(child, descendants);
        }
    }

    private void getDescendants(AbstractFeatureListNode abstractFeatureListNode, List<AbstractFeatureNode> descendants) {
        if (abstractFeatureListNode.getChild() != null) {
            descendants.add(abstractFeatureListNode.getChild());
            this.getDescendants(abstractFeatureListNode.getChild());
        }
    }

    @Override
    public List<EStructuralFeature> getChildEStructuralFeatures(AbstractFeatureNode abstractFeatureNode) {
        AbstractFeatureSpecifier abstractFeatureSpecifier;
        EStructuralFeature eStructuralFeature;
        ArrayList<EStructuralFeature> features = new ArrayList<EStructuralFeature>();
        if (abstractFeatureNode instanceof AbstractRootNode) {
            AbstractRootNode abstractRootNode = (AbstractRootNode)((Object)abstractFeatureNode);
            if (abstractRootNode.getSourceClass() instanceof EClass) {
                EClass eClass = abstractRootNode.getSourceClass();
                features.addAll((Collection<EStructuralFeature>)eClass.getEAllStructuralFeatures());
            }
        } else if (abstractFeatureNode instanceof AbstractFeatureSpecifier && (eStructuralFeature = (abstractFeatureSpecifier = (AbstractFeatureSpecifier)((Object)abstractFeatureNode)).getStructuralFeature()) != null && eStructuralFeature.getEType() instanceof EClass) {
            EClass eClass = (EClass)eStructuralFeature.getEType();
            features.addAll((Collection<EStructuralFeature>)eClass.getEAllStructuralFeatures());
        }
        return features;
    }

    @Override
    public Object resolve(EObject sourceObject, EStructuralFeature eStructuralFeature) {
        return sourceObject != null && eStructuralFeature != null ? sourceObject.eGet(eStructuralFeature) : null;
    }

    @Override
    public Object resolve(EObject sourceObject, AbstractFeatureNode abstractFeatureNode) {
        AbstractRootNode featureRoot = this.getFeatureRoot(abstractFeatureNode);
        Object result = null;
        if (featureRoot.getSourceClass().isSuperTypeOf(sourceObject.eClass())) {
            List<AbstractFeatureNode> ancestries = this.getAncestries(abstractFeatureNode);
            EObject eObject = sourceObject;
            Iterator<AbstractFeatureNode> it = ancestries.iterator();
            while (it.hasNext() && eObject != null) {
                AbstractFeatureNode node = it.next();
                if (!(node instanceof AbstractFeatureSpecifier)) continue;
                AbstractFeatureSpecifier featureSpecifier = (AbstractFeatureSpecifier)((Object)node);
                Object object = null;
                if (featureSpecifier.isMultiValued()) {
                    BasicEList list = (BasicEList)eObject.eGet(featureSpecifier.getStructuralFeature());
                    object = featureSpecifier.getIndex() >= 0 && featureSpecifier.getIndex() < list.size() ? list.get(featureSpecifier.getIndex()) : null;
                } else {
                    object = eObject.eGet(featureSpecifier.getStructuralFeature());
                }
                if (it.hasNext()) {
                    if (object instanceof EObject) {
                        eObject = (EObject)object;
                        continue;
                    }
                    eObject = null;
                    continue;
                }
                result = object;
            }
            return result;
        }
        return null;
    }

    @Override
    public void setValue(EObject sourceObject, AbstractFeatureNode abstractFeatureNode, Object value) {
        if (abstractFeatureNode instanceof AbstractFeatureSpecifier) {
            List<AbstractFeatureNode> ancestries = this.getAncestries(abstractFeatureNode);
            ancestries.remove(abstractFeatureNode);
            EObject eObject = sourceObject;
            for (AbstractFeatureNode node : ancestries) {
                if (!(node instanceof AbstractFeatureSpecifier)) continue;
                AbstractFeatureSpecifier specifier = (AbstractFeatureSpecifier)((Object)node);
                eObject = (EObject)eObject.eGet(specifier.getStructuralFeature());
            }
            if (eObject != null) {
                AbstractFeatureSpecifier s = (AbstractFeatureSpecifier)((Object)abstractFeatureNode);
                eObject.eSet(s.getStructuralFeature(), value);
            }
        }
    }

    @Override
    public boolean isResolved(EObject sourceObject, AbstractFeatureNode abstractFeatureNode) {
        boolean result = true;
        AbstractRootNode featureRoot = this.getFeatureRoot(abstractFeatureNode);
        if (featureRoot.getSourceClass().isSuperTypeOf(sourceObject.eClass())) {
            List<AbstractFeatureNode> ancestries = this.getAncestries(abstractFeatureNode);
            EObject eObject = sourceObject;
            Iterator<AbstractFeatureNode> it = ancestries.iterator();
            while (it.hasNext() && eObject != null && result) {
                AbstractFeatureNode node = it.next();
                if (!(node instanceof AbstractFeatureSpecifier)) continue;
                AbstractFeatureSpecifier featureSpecifier = (AbstractFeatureSpecifier)((Object)node);
                Object object = null;
                if (featureSpecifier.isMultiValued()) {
                    BasicEList list = (BasicEList)eObject.eGet(featureSpecifier.getStructuralFeature());
                    if (featureSpecifier.getIndex() >= 0 && featureSpecifier.getIndex() < list.size()) {
                        object = list.get(featureSpecifier.getIndex());
                    } else {
                        object = null;
                        result = false;
                    }
                } else {
                    object = eObject.eGet(featureSpecifier.getStructuralFeature());
                }
                if (!it.hasNext()) continue;
                if (object instanceof EObject) {
                    eObject = (EObject)object;
                    continue;
                }
                result = false;
            }
        } else {
            result = false;
        }
        return result;
    }

    @Override
    public AbstractFeatureListNode getLeaf(ListRootNode listRootNode) {
        AbstractFeatureListNode node = listRootNode;
        if (node != null) {
            while (node.getChild() != null) {
                node = node.getChild();
            }
        }
        return node;
    }

    @Override
    public IFile getFile(Resource resource) {
        if (resource != null) {
            URI uri = resource.getURI();
            uri = resource.getResourceSet().getURIConverter().normalize(uri);
            String scheme = uri.scheme();
            if ("platform".equals(scheme) && uri.segmentCount() > 1 && "resource".equals(uri.segment(0))) {
                StringBuffer platformResourcePath = new StringBuffer();
                int j = 1;
                int size = uri.segmentCount();
                while (j < size) {
                    platformResourcePath.append('/');
                    platformResourcePath.append(uri.segment(j));
                    ++j;
                }
                return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(platformResourcePath.toString()));
            }
        }
        return null;
    }

    @Override
    public EList<EObject> getContent(URI uri) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
        Resource resource = resourceSet.getResource(uri, true);
        return resource.getContents();
    }

    @Override
    public SortedSet<Timed> sortTimed(Collection<Timed> timedCollection) {
        TreeSet<Timed> sorted = new TreeSet<Timed>(new TimedComparator());
        sorted.addAll(timedCollection);
        return sorted;
    }

    @Override
    public double getTimeSpan(Collection<Timed> timedCollection) {
        double span = 0.0;
        SortedSet<Timed> sorted = this.sortTimed(timedCollection);
        if (sorted.size() > 1) {
            Timed earliest = sorted.first();
            Timed latest = sorted.last();
            span = (double)(latest.getTime().getTime() - earliest.getTime().getTime()) * 0.001;
        }
        return span;
    }

    @Override
    public String getID(EObject eObject) {
        String id = null;
        if (eObject != null && eObject.eResource() instanceof XMIResource) {
            id = ((XMIResource)eObject.eResource()).getID(eObject);
        }
        return id;
    }

    @Override
    public EObject getEObjectById(ResourceSet resourceSet, String id) {
        EObject result = null;
        TreeIterator objects = EcoreUtil.getAllContents((ResourceSet)resourceSet, (boolean)true);
        while (objects.hasNext() && result == null) {
            EObject eObject;
            Object object = objects.next();
            if (!(object instanceof EObject) || !this.getID(eObject = (EObject)object).equals(id)) continue;
            result = eObject;
        }
        return result;
    }

    @Override
    public List<EObject> getEObjectsByType(EObject rootContainer, EClass eClass) {
        ArrayList<EObject> list = new ArrayList<EObject>();
        TreeIterator objects = EcoreUtil.getAllContents((EObject)rootContainer, (boolean)true);
        while (objects.hasNext()) {
            EObject eObject;
            Object object = objects.next();
            if (!(object instanceof EObject) || !eClass.isSuperTypeOf((eObject = (EObject)object).eClass())) continue;
            list.add(eObject);
        }
        return list;
    }

    @Override
    public String getDefaultName(EObject eContainer, EObject eObject, ETypedElement typedElement) {
        String name = "";
        name = eObject != null ? eObject.eClass().getName() : typedElement.getEType().getName();
        if (typedElement.isMany()) {
            int j = 1;
            int i = 0;
            while (i < eContainer.eContents().size()) {
                ENamedElement named;
                if (eContainer.eContents().get(i) instanceof ENamedElement && (named = (ENamedElement)eContainer.eContents().get(i)).getName() != null && named.getName().equals(String.valueOf(name) + "_" + Integer.toString(j))) {
                    ++j;
                    i = 0;
                }
                ++i;
            }
            return String.valueOf(name) + "_" + Integer.toString(j);
        }
        return name;
    }

    @Override
    public List<EClass> getChildEClasses(final EClass parentEClass) {
        List<EClass> classes = null;
        if (parentEClass != null) {
            EClassFilter filter = new EClassFilter(){

                @Override
                public boolean filter(EClass eClass) {
                    boolean result = false;
                    EList childReferences = parentEClass.getEAllContainments();
                    int i = 0;
                    while (i < childReferences.size()) {
                        if (((EReference)childReferences.get(i)).getEReferenceType() == eClass) {
                            result = true;
                            break;
                        }
                        ++i;
                    }
                    return result && !eClass.isInterface() && !eClass.isAbstract();
                }
            };
            List<EClass> list = ApogyCommonEMFFacade.INSTANCE.getAllAvailableEClasses();
            classes = ApogyCommonEMFFacade.INSTANCE.filterEClasses(list, filter);
        }
        return classes;
    }

    @Override
    public EList<EReference> getSettableEReferences(EObject eObject) {
        BasicEList structuralFeatures = new BasicEList();
        structuralFeatures.addAll((Collection)eObject.eClass().getEAllContainments());
        Iterator ite = structuralFeatures.iterator();
        while (ite.hasNext()) {
            EReference eReference = (EReference)ite.next();
            Object value = eObject.eGet((EStructuralFeature)eReference);
            if (value == null || value instanceof List) continue;
            ite.remove();
        }
        return structuralFeatures;
    }

    @Override
    public String toString(List<? extends Named> nameds, String separator) {
        String message = "";
        Iterator<? extends Named> items = nameds.iterator();
        while (items.hasNext()) {
            Named named = items.next();
            message = String.valueOf(message) + named.getName();
            if (!items.hasNext()) continue;
            message = String.valueOf(message) + separator;
        }
        return message;
    }

    @Override
    public String format(Date date) {
        return date == null ? "Null" : this.getSimpleDateFormat().format(date);
    }

    @Override
    public Date parse(String dateString) throws Exception {
        return this.getSimpleDateFormat().parse(dateString);
    }

    @Override
    public void stopAllStartables(EObject root) {
        if (root instanceof Startable && ((Startable)root).isStarted()) {
            TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)root);
            if (domain != null) {
                SetCommand command = new SetCommand((EditingDomain)domain, root, (EStructuralFeature)ApogyCommonEMFPackage.Literals.STARTABLE__STARTED, (Object)false);
                domain.getCommandStack().execute((Command)command);
            } else {
                ((Startable)root).setStarted(false);
            }
        }
        if (root.eContents() != null) {
            for (EObject eObject : root.eContents()) {
                this.stopAllStartables(eObject);
            }
        }
    }

    @Override
    public String serializeEObject(EObject eObject, String uriID) {
        EObject copyEObject = EcoreUtil.copy((EObject)eObject);
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource childResource = resourceSet.createResource(URI.createURI((String)uriID));
        childResource.getContents().add((Object)copyEObject);
        StringWriter stringWriter = new StringWriter();
        URIConverter.WriteableOutputStream os = new URIConverter.WriteableOutputStream((Writer)stringWriter, "ENCODING");
        try {
            childResource.save((OutputStream)os, Collections.EMPTY_MAP);
        }
        catch (Throwable t) {
            Logger.error("Failed to serialize : " + eObject, t);
        }
        return stringWriter.getBuffer().toString();
    }

    @Override
    public EObject deserializeString(String str, String uriID) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource childResource = resourceSet.createResource(URI.createURI((String)uriID));
        StringReader reader = new StringReader(str);
        URIConverter.ReadableInputStream is = new URIConverter.ReadableInputStream((Reader)reader);
        try {
            childResource.load((InputStream)is, Collections.EMPTY_MAP);
            if (childResource.getContents().size() > 0) {
                return (EObject)childResource.getContents().get(0);
            }
        }
        catch (Throwable t) {
            Logger.error("Failed to deserialize : " + uriID);
        }
        return null;
    }

    @Override
    public EAnnotation getGenModelEAnnotation(EModelElement eModelElement) {
        EAnnotation eAnnotation = null;
        if (eModelElement != null) {
            eAnnotation = eModelElement.getEAnnotation("http://www.eclipse.org/emf/2002/GenModel");
        }
        return eAnnotation;
    }

    @Override
    public EAnnotation getApogyEAnnotation(EModelElement eModelElement) {
        EAnnotation eAnnotation = null;
        if (eModelElement != null) {
            eAnnotation = eModelElement.getEAnnotation("http://www.eclipse.org/apogy");
        }
        return eAnnotation;
    }

    @Override
    public String getEAnnotationDetailValue(EAnnotation eAnnotation, String key) {
        EMap eAnnotationDetailsMap;
        String value = null;
        if (eAnnotation != null && (eAnnotationDetailsMap = eAnnotation.getDetails()) != null) {
            value = (String)eAnnotationDetailsMap.get((Object)key);
        }
        return value;
    }

    @Override
    public boolean isTrue(EAnnotation eAnnotation, String key) {
        boolean result = false;
        String value = this.getEAnnotationDetailValue(eAnnotation, key);
        if (value != null) {
            result = Boolean.parseBoolean(value);
        }
        return result;
    }

    @Override
    public Number getEAnnotationDetailNumberValue(EAnnotation eAnnotation, String key) {
        Double number = null;
        String value = this.getEAnnotationDetailValue(eAnnotation, key);
        if (value != null) {
            try {
                number = Double.valueOf(value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return number;
    }

    @Override
    public List<EClass> filterEClasses(List<EClass> eClasses, EClassFilter filter) {
        ArrayList<EClassFilter> filters = new ArrayList<EClassFilter>();
        filters.add(filter);
        return this.filterEClasses(eClasses, filters);
    }

    @Override
    public List<EClass> filterEClasses(List<EClass> eClasses, List<EClassFilter> filters) {
        ArrayList<EClass> output = new ArrayList<EClass>();
        for (EClass eClass : eClasses) {
            boolean keep = true;
            Iterator<EClassFilter> it = filters.iterator();
            while (it.hasNext() && keep) {
                EClassFilter filter = it.next();
                keep = filter.filter(eClass);
            }
            if (!keep) continue;
            output.add(eClass);
        }
        return output;
    }

    @Override
    public EClass findClosestMatch(EClass eClass, List<EClass> eClasses) {
        TreeSet<EClass> treeSet = new TreeSet<EClass>(new Comparator<EClass>(){

            @Override
            public int compare(EClass o1, EClass o2) {
                if (o1 == o2) {
                    return 0;
                }
                return o1.isSuperTypeOf(o2) ? 1 : -1;
            }
        });
        treeSet.addAll(eClasses);
        return treeSet.contains(eClass) ? eClass : treeSet.higher(eClass);
    }

    @Override
    public EClass getEClass(String str) {
        EClass result = null;
        Iterator<EClass> classes = this.getAllAvailableEClasses().iterator();
        while (result == null && classes.hasNext()) {
            EClass clazz = classes.next();
            if (clazz.getInstanceTypeName() == null || !clazz.getInstanceTypeName().equals(str)) continue;
            result = clazz;
        }
        return result;
    }

    protected boolean validateDateFormatString(String formatString) {
        return formatString != null && formatString.length() != 0;
    }

    protected String stripCommentDelimiters(String commentString) {
        String result = "";
        if (commentString != null) {
            String[] lines;
            String[] stringArray = lines = commentString.split("\n");
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                if ((line = line.trim()).compareTo("*") != 0) {
                    if (line.startsWith("*")) {
                        line = line.replace('*', ' ');
                    }
                    result = String.valueOf(result) + line + "\n";
                }
                ++n2;
            }
        }
        return result;
    }

    @Override
    public long getDuration(Date fromDate, Date toDate) {
        return Math.abs(toDate.getTime() - fromDate.getTime());
    }

    @Override
    public long getDuration(TimeInterval timeInterval) {
        return this.getDuration(timeInterval.getFromDate(), timeInterval.getToDate());
    }

    @Override
    public List<TimeInterval> getTimeIntervalInterstices(TimeInterval originalTimeInterval, Collection<TimeInterval> intervals) {
        ArrayList<TimeInterval> mergedIntervals = new ArrayList<TimeInterval>();
        for (TimeInterval timeInterval : intervals) {
            boolean timeIntervalMerged = false;
            if (!this.doTimeIntervalOverlap(timeInterval, originalTimeInterval) || this.getDuration(timeInterval) <= 0L) continue;
            if (mergedIntervals.isEmpty()) {
                mergedIntervals.add(timeInterval);
                continue;
            }
            for (TimeInterval merged : mergedIntervals) {
                if (this.dateFallsInTimeInterval(timeInterval.getFromDate(), merged)) {
                    if (this.dateFallsInTimeInterval(timeInterval.getToDate(), merged)) {
                        timeIntervalMerged = true;
                        continue;
                    }
                    if (timeInterval.getToDate().getTime() < originalTimeInterval.getToDate().getTime()) {
                        merged.setToDate(timeInterval.getToDate());
                    } else {
                        merged.setToDate(timeInterval.getToDate());
                    }
                    timeIntervalMerged = true;
                    continue;
                }
                if (!this.dateFallsInTimeInterval(timeInterval.getToDate(), merged)) continue;
                if (timeInterval.getFromDate().getTime() > originalTimeInterval.getFromDate().getTime()) {
                    merged.setFromDate(timeInterval.getFromDate());
                } else {
                    merged.setFromDate(originalTimeInterval.getFromDate());
                }
                timeIntervalMerged = true;
            }
            if (!timeIntervalMerged) {
                mergedIntervals.add(timeInterval);
            }
            timeIntervalMerged = false;
        }
        TreeSet<TimeInterval> sortedMergedIntervals = new TreeSet<TimeInterval>(new TimeIntervalStatTimeComparator());
        sortedMergedIntervals.addAll(mergedIntervals);
        ArrayList<TimeInterval> results = new ArrayList<TimeInterval>();
        if (sortedMergedIntervals.isEmpty()) {
            results.add(originalTimeInterval);
        } else {
            Date startDate = originalTimeInterval.getFromDate();
            Iterator it = sortedMergedIntervals.iterator();
            while (it.hasNext()) {
                TimeInterval next = (TimeInterval)it.next();
                TimeInterval t = ApogyCommonEMFFactory.eINSTANCE.createTimeInterval();
                t.setFromDate(startDate);
                t.setToDate(next.getFromDate());
                startDate = next.getToDate();
                results.add(t);
                if (it.hasNext()) continue;
                TimeInterval last = ApogyCommonEMFFactory.eINSTANCE.createTimeInterval();
                last.setFromDate(startDate);
                last.setToDate(originalTimeInterval.getToDate());
                results.add(last);
            }
        }
        return results;
    }

    private boolean dateFallsInTimeInterval(Date date, TimeInterval timeInterval) {
        long dateTme = date.getTime();
        return dateTme >= timeInterval.getFromDate().getTime() && dateTme <= timeInterval.getToDate().getTime();
    }

    private boolean doTimeIntervalOverlap(TimeInterval timeInterval1, TimeInterval timeInterval2) {
        return timeInterval1.getFromDate().getTime() <= timeInterval2.getToDate().getTime() || timeInterval1.getToDate().getTime() >= timeInterval2.getFromDate().getTime();
    }

    @Override
    public boolean isDateInValidRange(TimeInterval timeInterval, Date date) {
        return date.getTime() <= timeInterval.getToDate().getTime() && date.getTime() >= timeInterval.getFromDate().getTime();
    }

    @Override
    public EStructuralFeature getEStructuralFeature(FeaturePath featurePath) {
        EStructuralFeature[] features;
        EStructuralFeature result = null;
        if (featurePath != null && (features = featurePath.getFeaturePath()).length > 0) {
            result = features[features.length - 1];
        }
        return result;
    }

    @Override
    public EObject resolveOwner(EObject root, FeaturePath featurePath) {
        EObject result = null;
        Object currentObject = root;
        if (root != null) {
            if (featurePath == null || featurePath.getFeaturePath().length == 0) {
                result = root;
            } else {
                int i = 0;
                EStructuralFeature[] features = featurePath.getFeaturePath();
                boolean isConsistent = true;
                while (i < features.length && isConsistent) {
                    Object object;
                    isConsistent = false;
                    EStructuralFeature currentFeature = features[i];
                    if (currentObject != null && currentObject instanceof EObject && (object = currentObject.eGet(currentFeature, true)) instanceof EObject) {
                        currentObject = object;
                        isConsistent = true;
                    }
                    if (++i != features.length || !isConsistent || !(currentObject instanceof EObject)) continue;
                    result = currentObject;
                }
            }
        }
        return result;
    }

    @Override
    public Object resolveValue(EObject eObject, FeaturePath featurePath, EStructuralFeature eStructuralFeature) {
        Object result = null;
        EObject owner = this.resolveOwner(eObject, featurePath);
        if (owner != null) {
            result = eStructuralFeature == null ? owner : owner.eGet(eStructuralFeature);
        }
        return result;
    }

    @Override
    public FeaturePath append(FeaturePath featurePath, EStructuralFeature eStructuralFeature) {
        assert (featurePath != null) : "Specified FeaturePath is null.";
        assert (featurePath != null) : "Specified EStructuralFeature is null.";
        ArrayList<EStructuralFeature> featuresList = new ArrayList<EStructuralFeature>(Arrays.asList(featurePath.getFeaturePath()));
        featuresList.add(eStructuralFeature);
        return FeaturePath.fromList((EStructuralFeature[])((EStructuralFeature[])featuresList.toArray()));
    }

    private SimpleDateFormat getSimpleDateFormat() {
        if (this.simpleDateFormat == null) {
            this.simpleDateFormat = new SimpleDateFormat(this.getApogyCommonEMFPreferences().getDateFormatString());
            this.simpleDateFormat.setTimeZone(this.getApogyCommonEMFPreferences().getTimeZone());
        }
        return this.simpleDateFormat;
    }

    private class TimeIntervalStatTimeComparator
    implements Comparator<TimeInterval> {
        private TimeIntervalStatTimeComparator() {
        }

        @Override
        public int compare(TimeInterval o1, TimeInterval o2) {
            long o2StartTime;
            long o1StartTime = o1.getFromDate().getTime();
            if (o1StartTime > (o2StartTime = o2.getFromDate().getTime())) {
                return 1;
            }
            if (o1StartTime < o2StartTime) {
                return -1;
            }
            return 0;
        }
    }

    protected class TimedComparator
    implements Comparator<Timed> {
        protected TimedComparator() {
        }

        @Override
        public int compare(Timed o1, Timed o2) {
            long time2;
            long time1 = o1.getTime().getTime();
            if (time1 < (time2 = o2.getTime().getTime())) {
                return -1;
            }
            if (time1 > time2) {
                return 1;
            }
            return 0;
        }
    }
}

