/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.geometry.data.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.apogy.common.geometry.data.Coordinates;
import org.eclipse.apogy.common.geometry.data.CoordinatesSamplingShape;
import org.eclipse.apogy.common.geometry.data.Mesh;
import org.eclipse.apogy.common.geometry.data.Polygon;
import org.eclipse.apogy.common.geometry.data.PolygonSamplingMode;
import org.eclipse.apogy.common.geometry.data.ShapeSamplingMode;
import org.eclipse.apogy.common.geometry.data.impl.MeshCoordinatesShapesSamplerImpl;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;

public abstract class MeshCoordinatesShapesSamplerCustomImpl<CoordinatesType extends Coordinates, PolygonType extends Polygon<CoordinatesType>>
extends MeshCoordinatesShapesSamplerImpl<CoordinatesType, PolygonType> {
    public Mesh<CoordinatesType, PolygonType> doProcess(Mesh<CoordinatesType, PolygonType> input, IProgressMonitor monitor) throws Exception {
        monitor.beginTask("Sampling using " + this.getCoordinatesSamplingShapes().size() + " sampling shapes. ", input.getPoints().size());
        Mesh sampledMesh = this.createMesh();
        ArrayList<Coordinates> pointsKept = new ArrayList<Coordinates>();
        for (Coordinates point : input.getPoints()) {
            if (!this.isPointInside(point)) continue;
            pointsKept.add(point);
        }
        ArrayList<Polygon> polygonsKept = new ArrayList<Polygon>();
        for (Coordinates point : pointsKept) {
            Iterator polygonsSharingPoint = input.getPolygonsSharingPoint(point);
            Iterator iterator = polygonsSharingPoint.iterator();
            while (iterator.hasNext()) {
                Polygon polygon = (Polygon)iterator.next();
                if (polygonsKept.contains(polygon)) continue;
                EList vertices = polygon.getVertices();
                if (this.getPolygonSamplingMode() == PolygonSamplingMode.AT_LEAST_ONE_VERTEX) {
                    polygonsKept.add(polygon);
                    continue;
                }
                if (this.getPolygonSamplingMode() != PolygonSamplingMode.ALL_VERTEX || !pointsKept.containsAll((Collection<?>)vertices)) continue;
                polygonsKept.add(polygon);
            }
        }
        HashMap<Coordinates, Coordinates> originalToNewPointMap = new HashMap<Coordinates, Coordinates>();
        for (Coordinates point : pointsKept) {
            originalToNewPointMap.put(point, this.copyCoordinates(point));
        }
        sampledMesh.getPoints().addAll(originalToNewPointMap.values());
        ArrayList polygonCopies = new ArrayList();
        for (Polygon polygon : polygonsKept) {
            Object newPolygon = this.createPolygon();
            for (Coordinates originalpoint : polygon.getVertices()) {
                Coordinates newPoint = (Coordinates)originalToNewPointMap.get(originalpoint);
                if (newPoint == null) {
                    newPoint = this.copyCoordinates(originalpoint);
                    originalToNewPointMap.put(originalpoint, newPoint);
                    sampledMesh.getPoints().add((Object)newPoint);
                }
                newPolygon.getVertices().add((Object)newPoint);
            }
            polygonCopies.add(newPolygon);
        }
        sampledMesh.getPolygons().addAll(polygonCopies);
        monitor.done();
        return sampledMesh;
    }

    private boolean isPointInside(CoordinatesType point) {
        boolean inside;
        block3: {
            block2: {
                inside = false;
                if (this.getShapeSamplingMode() != ShapeSamplingMode.UNION) break block2;
                inside = false;
                int j = 0;
                while (j < this.getCoordinatesSamplingShapes().size() && !inside) {
                    CoordinatesSamplingShape samplingShape = (CoordinatesSamplingShape)this.getCoordinatesSamplingShapes().get(j);
                    inside |= samplingShape.isInside(point);
                    ++j;
                }
                break block3;
            }
            if (this.getShapeSamplingMode() != ShapeSamplingMode.INTERSECTION) break block3;
            inside = true;
            int j = 0;
            while (j < this.getCoordinatesSamplingShapes().size() && inside) {
                CoordinatesSamplingShape samplingShape = (CoordinatesSamplingShape)this.getCoordinatesSamplingShapes().get(j);
                inside &= samplingShape.isInside(point);
                ++j;
            }
        }
        return inside;
    }
}

