/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.math.quickhull3d;

import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.eclipse.apogy.common.math.quickhull3d.FaceList;
import org.eclipse.apogy.common.math.quickhull3d.HalfEdge;
import org.eclipse.apogy.common.math.quickhull3d.InternalErrorException;
import org.eclipse.apogy.common.math.quickhull3d.Vertex;

class Face {
    HalfEdge he0;
    private final Vector3d normal = new Vector3d();
    double area;
    private final Vector3d centroid = new Vector3d();
    double planeOffset;
    int index;
    int numVerts;
    Face next;
    static final int VISIBLE = 1;
    static final int NON_CONVEX = 2;
    static final int DELETED = 3;
    int mark = 1;
    Vertex outside;

    public void computeCentroid(Vector3d centroid) {
        centroid.x = 0.0;
        centroid.y = 0.0;
        centroid.z = 0.0;
        HalfEdge he = this.he0;
        do {
            centroid.add((Tuple3d)he.head().pnt);
        } while ((he = he.next) != this.he0);
        centroid.scale(1.0 / (double)this.numVerts);
    }

    public void computeNormal(Vector3d normal, double minArea) {
        this.computeNormal(normal);
        if (this.area < minArea) {
            HalfEdge hedgeMax = null;
            double lenSqrMax = 0.0;
            HalfEdge hedge = this.he0;
            do {
                double lenSqr;
                if (!((lenSqr = hedge.lengthSquared()) > lenSqrMax)) continue;
                hedgeMax = hedge;
                lenSqrMax = lenSqr;
            } while ((hedge = hedge.next) != this.he0);
            Vector3d p2 = hedgeMax.head().pnt;
            Vector3d p1 = hedgeMax.tail().pnt;
            double lenMax = Math.sqrt(lenSqrMax);
            double ux = (p2.x - p1.x) / lenMax;
            double uy = (p2.y - p1.y) / lenMax;
            double uz = (p2.z - p1.z) / lenMax;
            double dot = normal.x * ux + normal.y * uy + normal.z * uz;
            normal.x -= dot * ux;
            normal.y -= dot * uy;
            normal.z -= dot * uz;
            normal.normalize();
        }
    }

    public void computeNormal(Vector3d normal) {
        HalfEdge he1 = this.he0.next;
        HalfEdge he2 = he1.next;
        Vector3d p0 = this.he0.head().pnt;
        Vector3d p2 = he1.head().pnt;
        double d2x = p2.x - p0.x;
        double d2y = p2.y - p0.y;
        double d2z = p2.z - p0.z;
        normal.x = 0.0;
        normal.y = 0.0;
        normal.z = 0.0;
        this.numVerts = 2;
        while (he2 != this.he0) {
            double d1x = d2x;
            double d1y = d2y;
            double d1z = d2z;
            p2 = he2.head().pnt;
            d2x = p2.x - p0.x;
            d2y = p2.y - p0.y;
            d2z = p2.z - p0.z;
            normal.x += d1y * d2z - d1z * d2y;
            normal.y += d1z * d2x - d1x * d2z;
            normal.z += d1x * d2y - d1y * d2x;
            he1 = he2;
            he2 = he2.next;
            ++this.numVerts;
        }
        this.area = normal.length();
        normal.scale(1.0 / this.area);
    }

    private void computeNormalAndCentroid() {
        this.computeNormal(this.normal);
        this.computeCentroid(this.centroid);
        this.planeOffset = this.normal.dot(new Vector3d(this.centroid));
        int numv = 0;
        HalfEdge he = this.he0;
        do {
            ++numv;
        } while ((he = he.next) != this.he0);
        if (numv != this.numVerts) {
            throw new InternalErrorException("face " + this.getVertexString() + " numVerts=" + this.numVerts + " should be " + numv);
        }
    }

    private void computeNormalAndCentroid(double minArea) {
        this.computeNormal(this.normal, minArea);
        this.computeCentroid(this.centroid);
        this.planeOffset = this.normal.dot(new Vector3d(this.centroid));
    }

    public static Face createTriangle(Vertex v0, Vertex v1, Vertex v2) {
        return Face.createTriangle(v0, v1, v2, 0.0);
    }

    public static Face createTriangle(Vertex v0, Vertex v1, Vertex v2, double minArea) {
        HalfEdge he2;
        Face face = new Face();
        HalfEdge he0 = new HalfEdge(v0, face);
        HalfEdge he1 = new HalfEdge(v1, face);
        he0.prev = he2 = new HalfEdge(v2, face);
        he0.next = he1;
        he1.prev = he0;
        he1.next = he2;
        he2.prev = he1;
        he2.next = he0;
        face.he0 = he0;
        face.computeNormalAndCentroid(minArea);
        return face;
    }

    public static Face create(Vertex[] vtxArray, int[] indices) {
        Face face = new Face();
        HalfEdge hePrev = null;
        int i = 0;
        while (i < indices.length) {
            HalfEdge he = new HalfEdge(vtxArray[indices[i]], face);
            if (hePrev != null) {
                he.setPrev(hePrev);
                hePrev.setNext(he);
            } else {
                face.he0 = he;
            }
            hePrev = he;
            ++i;
        }
        face.he0.setPrev(hePrev);
        hePrev.setNext(face.he0);
        face.computeNormalAndCentroid();
        return face;
    }

    public HalfEdge getEdge(int i) {
        HalfEdge he = this.he0;
        while (i > 0) {
            he = he.next;
            --i;
        }
        while (i < 0) {
            he = he.prev;
            ++i;
        }
        return he;
    }

    public HalfEdge getFirstEdge() {
        return this.he0;
    }

    public HalfEdge findEdge(Vertex vt, Vertex vh) {
        HalfEdge he = this.he0;
        do {
            if (he.head() != vh || he.tail() != vt) continue;
            return he;
        } while ((he = he.next) != this.he0);
        return null;
    }

    public double distanceToPlane(Vector3d p) {
        return this.normal.x * p.x + this.normal.y * p.y + this.normal.z * p.z - this.planeOffset;
    }

    public Vector3d getNormal() {
        return this.normal;
    }

    public Vector3d getCentroid() {
        return this.centroid;
    }

    public int numVertices() {
        return this.numVerts;
    }

    public String getVertexString() {
        String s = null;
        HalfEdge he = this.he0;
        do {
            s = s == null ? "" + he.head().index : String.valueOf(s) + " " + he.head().index;
        } while ((he = he.next) != this.he0);
        return s;
    }

    public void getVertexIndices(int[] idxs) {
        HalfEdge he = this.he0;
        int i = 0;
        do {
            idxs[i++] = he.head().index;
        } while ((he = he.next) != this.he0);
    }

    private Face connectHalfEdges(HalfEdge hedgePrev, HalfEdge hedge) {
        Face discardedFace = null;
        if (hedgePrev.oppositeFace() == hedge.oppositeFace()) {
            HalfEdge hedgeOpp;
            Face oppFace = hedge.oppositeFace();
            if (hedgePrev == this.he0) {
                this.he0 = hedge;
            }
            if (oppFace.numVertices() == 3) {
                hedgeOpp = hedge.getOpposite().prev.getOpposite();
                oppFace.mark = 3;
                discardedFace = oppFace;
            } else {
                hedgeOpp = hedge.getOpposite().next;
                if (oppFace.he0 == hedgeOpp.prev) {
                    oppFace.he0 = hedgeOpp;
                }
                hedgeOpp.prev = hedgeOpp.prev.prev;
                hedgeOpp.prev.next = hedgeOpp;
            }
            hedge.prev = hedgePrev.prev;
            hedge.prev.next = hedge;
            hedge.opposite = hedgeOpp;
            hedgeOpp.opposite = hedge;
            oppFace.computeNormalAndCentroid();
        } else {
            hedgePrev.next = hedge;
            hedge.prev = hedgePrev;
        }
        return discardedFace;
    }

    void checkConsistency() {
        HalfEdge hedge = this.he0;
        double maxd = 0.0;
        int numv = 0;
        if (this.numVerts < 3) {
            throw new InternalErrorException("degenerate face: " + this.getVertexString());
        }
        do {
            HalfEdge hedgeOpp;
            if ((hedgeOpp = hedge.getOpposite()) == null) {
                throw new InternalErrorException("face " + this.getVertexString() + ": " + "unreflected half edge " + hedge.getVertexString());
            }
            if (hedgeOpp.getOpposite() != hedge) {
                throw new InternalErrorException("face " + this.getVertexString() + ": " + "opposite half edge " + hedgeOpp.getVertexString() + " has opposite " + hedgeOpp.getOpposite().getVertexString());
            }
            if (hedgeOpp.head() != hedge.tail() || hedge.head() != hedgeOpp.tail()) {
                throw new InternalErrorException("face " + this.getVertexString() + ": " + "half edge " + hedge.getVertexString() + " reflected by " + hedgeOpp.getVertexString());
            }
            Face oppFace = hedgeOpp.face;
            if (oppFace == null) {
                throw new InternalErrorException("face " + this.getVertexString() + ": " + "no face on half edge " + hedgeOpp.getVertexString());
            }
            if (oppFace.mark == 3) {
                throw new InternalErrorException("face " + this.getVertexString() + ": " + "opposite face " + oppFace.getVertexString() + " not on hull");
            }
            double d = Math.abs(this.distanceToPlane(hedge.head().pnt));
            if (d > maxd) {
                maxd = d;
            }
            ++numv;
        } while ((hedge = hedge.next) != this.he0);
        if (numv != this.numVerts) {
            throw new InternalErrorException("face " + this.getVertexString() + " numVerts=" + this.numVerts + " should be " + numv);
        }
    }

    public int mergeAdjacentFace(HalfEdge hedgeAdj, Face[] discarded) {
        Face discardedFace;
        Face oppFace = hedgeAdj.oppositeFace();
        int numDiscarded = 0;
        discarded[numDiscarded++] = oppFace;
        oppFace.mark = 3;
        HalfEdge hedgeOpp = hedgeAdj.getOpposite();
        HalfEdge hedgeAdjPrev = hedgeAdj.prev;
        HalfEdge hedgeAdjNext = hedgeAdj.next;
        HalfEdge hedgeOppPrev = hedgeOpp.prev;
        HalfEdge hedgeOppNext = hedgeOpp.next;
        while (hedgeAdjPrev.oppositeFace() == oppFace) {
            hedgeAdjPrev = hedgeAdjPrev.prev;
            hedgeOppNext = hedgeOppNext.next;
        }
        while (hedgeAdjNext.oppositeFace() == oppFace) {
            hedgeOppPrev = hedgeOppPrev.prev;
            hedgeAdjNext = hedgeAdjNext.next;
        }
        HalfEdge hedge = hedgeOppNext;
        while (hedge != hedgeOppPrev.next) {
            hedge.face = this;
            hedge = hedge.next;
        }
        if (hedgeAdj == this.he0) {
            this.he0 = hedgeAdjNext;
        }
        if ((discardedFace = this.connectHalfEdges(hedgeOppPrev, hedgeAdjNext)) != null) {
            discarded[numDiscarded++] = discardedFace;
        }
        if ((discardedFace = this.connectHalfEdges(hedgeAdjPrev, hedgeOppNext)) != null) {
            discarded[numDiscarded++] = discardedFace;
        }
        this.computeNormalAndCentroid();
        this.checkConsistency();
        return numDiscarded;
    }

    public void triangulate(FaceList newFaces, double minArea) {
        Face face;
        if (this.numVertices() < 4) {
            return;
        }
        Vertex v0 = this.he0.head();
        HalfEdge hedge = this.he0.next;
        HalfEdge oppPrev = hedge.opposite;
        Face face0 = null;
        hedge = hedge.next;
        while (hedge != this.he0.prev) {
            face = Face.createTriangle(v0, hedge.prev.head(), hedge.head(), minArea);
            face.he0.next.setOpposite(oppPrev);
            face.he0.prev.setOpposite(hedge.opposite);
            oppPrev = face.he0;
            newFaces.add(face);
            if (face0 == null) {
                face0 = face;
            }
            hedge = hedge.next;
        }
        hedge = new HalfEdge(this.he0.prev.prev.head(), this);
        hedge.setOpposite(oppPrev);
        hedge.prev = this.he0;
        hedge.prev.next = hedge;
        hedge.next = this.he0.prev;
        hedge.next.prev = hedge;
        this.computeNormalAndCentroid(minArea);
        this.checkConsistency();
        face = face0;
        while (face != null) {
            face.checkConsistency();
            face = face.next;
        }
    }
}

