/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.ui.birt.composites;

import java.security.InvalidParameterException;
import org.eclipse.apogy.common.ui.birt.composites.ApogyBIRTUtilities;
import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.Generator;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.impl.BoundsImpl;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.data.DataSet;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.layout.Plot;
import org.eclipse.birt.chart.model.type.LineSeries;
import org.eclipse.birt.chart.util.PluginSettings;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.progress.UIJob;

public abstract class AbstractBIRTChartComposite
extends Composite
implements PaintListener {
    public static long DEFAULT_UPDATE_PERIOD_MS = 500L;
    public static int DEFAULT_HISTORY_SIZE = 200;
    public static RGB DEFAULT_PLOT_BACKGROUND_COLOR = new RGB(0, 0, 0);
    public static RGB DEFAULT_PLOT_GRID_COLOR = new RGB(0, 255, 0);
    public static RGB DEFAULT_SERIES_COLOR = new RGB(255, 255, 0);
    public static RGB DEFAULT_X_AXIS_COLOR = new RGB(255, 0, 0);
    public static RGB DEFAULT_Y_AXIS_COLOR = new RGB(0, 255, 0);
    protected IDeviceRenderer idr = null;
    protected Chart chart = null;
    protected Canvas chartCanvas = null;
    protected String chartTitle = "Untitled";
    protected RGB plotBackgroundColor = DEFAULT_PLOT_BACKGROUND_COLOR;
    protected RGB plotGridColor = DEFAULT_PLOT_GRID_COLOR;
    protected RGB seriesColor = DEFAULT_SERIES_COLOR;
    protected RGB xAxisColor = DEFAULT_X_AXIS_COLOR;
    protected RGB yAxisColor = DEFAULT_Y_AXIS_COLOR;
    protected String xAxisName = null;
    protected String yAxisName = null;
    protected int historySize = DEFAULT_HISTORY_SIZE;
    protected Axis xAxis;
    protected Axis yAxis;
    protected Series xSeries;
    protected SeriesDefinition xSeriesDefinition;
    protected LineSeries ySeries;
    protected SeriesDefinition ySeriesDefinition;
    private UIJob uiJob = null;
    private boolean stopRequested = false;
    private boolean dataUpdated = false;

    public AbstractBIRTChartComposite(Composite parent, int style) {
        super(parent, style);
        PluginSettings pluginSettings = PluginSettings.instance();
        try {
            this.idr = pluginSettings.getDevice("dv.SWT");
        }
        catch (ChartException pex) {
            pex.printStackTrace();
        }
        this.setLayout((Layout)new GridLayout(1, false));
        this.setBackground(this.getBackground());
        GridData gd = new GridData(1808);
        this.chartCanvas = new Canvas((Composite)this, 2048);
        this.chartCanvas.setLayoutData((Object)gd);
        this.chartCanvas.addPaintListener((PaintListener)this);
        this.chartCanvas.layout();
        this.chartCanvas.redraw();
        this.chart = this.createChart();
        this.getUiJob().schedule();
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
                AbstractBIRTChartComposite.this.stopRequested = true;
            }
        });
    }

    public int getHistorySize() {
        return this.historySize;
    }

    public void setHistorySize(int historySize) {
        if (historySize == 0) {
            throw new InvalidParameterException("historySize cannot be 0 !");
        }
        this.historySize = historySize;
    }

    public void setChartTitle(String chartTitle) {
        if (chartTitle != null) {
            this.chartTitle = chartTitle;
            if (this.chart != null) {
                if (chartTitle != null && chartTitle.length() > 0) {
                    this.chart.getTitle().setVisible(true);
                    this.chart.getTitle().getLabel().setVisible(true);
                    this.chart.getTitle().getLabel().getCaption().setColor(ColorDefinitionImpl.GREEN());
                    this.chart.getTitle().getLabel().getCaption().setValue(chartTitle);
                } else {
                    this.chart.getTitle().setVisible(false);
                    this.chart.getTitle().getLabel().setVisible(false);
                    this.chart.getTitle().getLabel().getCaption().setValue("");
                }
            }
        } else {
            throw new InvalidParameterException("chartTitle cannot be null!");
        }
    }

    public RGB getPlotBackgroundColor() {
        return this.plotBackgroundColor;
    }

    public void setPlotBackgroundColor(RGB plotBackgroundColor) {
        if (plotBackgroundColor != null) {
            this.plotBackgroundColor = plotBackgroundColor;
            if (this.chart != null) {
                Plot plot = this.chart.getPlot();
                plot.setBackground((Fill)ApogyBIRTUtilities.convertToColorDefinition(plotBackgroundColor));
                plot.getClientArea().setBackground((Fill)ApogyBIRTUtilities.convertToColorDefinition(plotBackgroundColor));
            }
        } else {
            throw new InvalidParameterException("plotBackgroundColor cannot be null!");
        }
    }

    public RGB getPlotGridColor() {
        return this.plotGridColor;
    }

    public void setPlotGridColor(RGB plotGridColor) {
        if (plotGridColor == null) {
            throw new InvalidParameterException("plotGridColor cannot be null!");
        }
        this.plotGridColor = plotGridColor;
        this.chart.getTitle().getLabel().getCaption().setColor(ApogyBIRTUtilities.convertToColorDefinition(plotGridColor));
        this.xAxis.getMajorGrid().getLineAttributes().setColor(ApogyBIRTUtilities.convertToColorDefinition(plotGridColor));
        this.xAxis.getMinorGrid().getLineAttributes().setColor(ApogyBIRTUtilities.convertToColorDefinition(plotGridColor));
        this.yAxis.getMajorGrid().getLineAttributes().setColor(ApogyBIRTUtilities.convertToColorDefinition(plotGridColor));
        this.yAxis.getMinorGrid().getLineAttributes().setColor(ApogyBIRTUtilities.convertToColorDefinition(plotGridColor));
    }

    public String getXAxisName() {
        return this.xAxisName;
    }

    public void setXAxisName(String xAxisName) {
        this.xAxisName = xAxisName;
        if (this.chart != null && this.xAxis != null) {
            if (xAxisName != null && xAxisName.length() > 0) {
                this.xAxis.getTitle().setVisible(true);
                this.xAxis.getTitle().getCaption().setColor(ApogyBIRTUtilities.convertToColorDefinition(this.xAxisColor));
                this.xAxis.getTitle().getCaption().setValue(xAxisName);
            } else {
                this.xAxis.getTitle().setVisible(false);
            }
        }
    }

    public void setXAxisColor(RGB xAxisColor) {
        if (xAxisColor != null) {
            this.xAxisColor = xAxisColor;
            this.xAxis.getTitle().getCaption().setColor(ApogyBIRTUtilities.convertToColorDefinition(xAxisColor));
            this.xAxis.getLineAttributes().setColor(ApogyBIRTUtilities.convertToColorDefinition(xAxisColor));
            this.xAxis.getLabel().getCaption().setColor(ApogyBIRTUtilities.convertToColorDefinition(xAxisColor));
            this.xAxis.getMajorGrid().getTickAttributes().setColor(ApogyBIRTUtilities.convertToColorDefinition(xAxisColor));
            this.xAxis.getMajorGrid().getTickAttributes().setVisible(true);
            this.xAxis.getMinorGrid().getTickAttributes().setColor(ApogyBIRTUtilities.convertToColorDefinition(xAxisColor));
            this.xAxis.getMinorGrid().getTickAttributes().setVisible(false);
        }
    }

    public String getYAxisName() {
        return this.xAxisName;
    }

    public void setYAxisName(String yAxisName) {
        this.yAxisName = yAxisName;
        if (this.chart != null && this.yAxis != null) {
            if (yAxisName != null && yAxisName.length() > 0) {
                this.yAxis.getTitle().setVisible(true);
                this.yAxis.getTitle().getCaption().setColor(ApogyBIRTUtilities.convertToColorDefinition(this.yAxisColor));
                this.yAxis.getTitle().getCaption().setValue(yAxisName);
            } else {
                this.yAxis.getTitle().setVisible(false);
            }
        }
    }

    public void setYAxisColor(RGB yAxisColor) {
        if (yAxisColor != null) {
            this.yAxisColor = yAxisColor;
            this.yAxis.getTitle().getCaption().setColor(ApogyBIRTUtilities.convertToColorDefinition(yAxisColor));
            this.yAxis.getLineAttributes().setColor(ApogyBIRTUtilities.convertToColorDefinition(yAxisColor));
            this.yAxis.getLabel().getCaption().setColor(ApogyBIRTUtilities.convertToColorDefinition(yAxisColor));
            this.yAxis.getMajorGrid().getTickAttributes().setColor(ApogyBIRTUtilities.convertToColorDefinition(yAxisColor));
            this.yAxis.getMajorGrid().getTickAttributes().setVisible(true);
            this.yAxis.getMinorGrid().getTickAttributes().setColor(ApogyBIRTUtilities.convertToColorDefinition(yAxisColor));
            this.yAxis.getMinorGrid().getTickAttributes().setVisible(false);
        }
    }

    public RGB getSeriesColor() {
        return this.seriesColor;
    }

    public void setSeriesColor(RGB seriesColor) {
        if (seriesColor == null) {
            throw new InvalidParameterException("seriesColor cannot be null!");
        }
        this.seriesColor = seriesColor;
    }

    public void updateChart() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (AbstractBIRTChartComposite.this.chartCanvas != null && !AbstractBIRTChartComposite.this.chartCanvas.isDisposed()) {
                    AbstractBIRTChartComposite.this.chartCanvas.update();
                    AbstractBIRTChartComposite.this.chartCanvas.layout();
                    AbstractBIRTChartComposite.this.chartCanvas.redraw();
                }
            }
        });
    }

    public void paintControl(PaintEvent e) {
        this.idr.setProperty("device.output.context", (Object)e.gc);
        Composite co = (Composite)e.getSource();
        Rectangle re = co.getClientArea();
        Bounds bo = BoundsImpl.create((double)0.0, (double)0.0, (double)re.width, (double)re.height);
        bo.scale(72.0 / (double)this.idr.getDisplayServer().getDpiResolution());
        if (this.chart != null) {
            Generator gr = Generator.instance();
            try {
                gr.render(this.idr, gr.build(this.idr.getDisplayServer(), this.chart, bo, null, null, null));
            }
            catch (ChartException gex) {
                gex.printStackTrace();
            }
        }
    }

    private UIJob getUiJob() {
        if (this.uiJob == null) {
            this.uiJob = new UIJob("ValuesVsTime Update."){

                public IStatus runInUIThread(IProgressMonitor arg0) {
                    try {
                        AbstractBIRTChartComposite.this.updateValuesAndChart();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (!AbstractBIRTChartComposite.this.stopRequested) {
                        this.schedule(DEFAULT_UPDATE_PERIOD_MS);
                    }
                    return Status.OK_STATUS;
                }
            };
        }
        return this.uiJob;
    }

    protected abstract Chart createChart();

    protected abstract void updateValuesAndChart();

    protected abstract DataSet getXSeriesDataSet();

    protected abstract DataSet getYSeriesDataSet();
}

