/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.earth.surface.converters;

import javax.vecmath.Matrix4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.eclipse.apogy.common.converters.IConverter;
import org.eclipse.apogy.common.math.ApogyCommonMathFacade;
import org.eclipse.apogy.core.Positioned;
import org.eclipse.apogy.core.environment.ApogyEnvironment;
import org.eclipse.apogy.core.environment.earth.GeographicCoordinates;
import org.eclipse.apogy.core.environment.earth.surface.EarthSurfaceWorksite;
import org.eclipse.apogy.core.invocator.InvocatorSession;
import org.eclipse.emf.ecore.EObject;

public class PositionedToGeographicalCoordinatesConverter
implements IConverter {
    public Class<?> getOutputType() {
        return GeographicCoordinates.class;
    }

    public Class<?> getInputType() {
        return Positioned.class;
    }

    public boolean canConvert(Object input) {
        EarthSurfaceWorksite worksite;
        Positioned positioned;
        return input instanceof Positioned && (positioned = (Positioned)input).getPose() != null && (worksite = this.getEarthSurfaceWorksite(positioned)) != null;
    }

    public Object convert(Object input) throws Exception {
        if (this.canConvert(input)) {
            Positioned positioned = (Positioned)input;
            Matrix4d matrix = positioned.getPose().asMatrix4d();
            Vector3d position = new Vector3d();
            matrix.get(position);
            EarthSurfaceWorksite worksite = this.getEarthSurfaceWorksite(positioned);
            return worksite.convertToGeographicCoordinates(ApogyCommonMathFacade.INSTANCE.createTuple3d((Tuple3d)position));
        }
        return null;
    }

    protected EarthSurfaceWorksite getEarthSurfaceWorksite(Positioned positioned) {
        EarthSurfaceWorksite earthSurfaceWorksite = null;
        EObject container = positioned.eContainer();
        while (earthSurfaceWorksite == null && container != null) {
            if (container instanceof EarthSurfaceWorksite) {
                earthSurfaceWorksite = (EarthSurfaceWorksite)container;
                continue;
            }
            if (container instanceof InvocatorSession) {
                ApogyEnvironment se;
                InvocatorSession session = (InvocatorSession)container;
                if (!(session.getEnvironment() instanceof ApogyEnvironment) || !((se = (ApogyEnvironment)session.getEnvironment()).getActiveWorksite() instanceof EarthSurfaceWorksite)) continue;
                earthSurfaceWorksite = (EarthSurfaceWorksite)se.getActiveWorksite();
                continue;
            }
            container = container.eContainer();
        }
        return earthSurfaceWorksite;
    }
}

