/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.earth.surface.impl;

import java.util.Date;
import java.util.Iterator;
import javax.vecmath.Vector3d;
import org.eclipse.apogy.common.topology.Node;
import org.eclipse.apogy.common.topology.TransformNode;
import org.eclipse.apogy.core.environment.Moon;
import org.eclipse.apogy.core.environment.Sky;
import org.eclipse.apogy.core.environment.SkyNode;
import org.eclipse.apogy.core.environment.earth.ApogyCoreEnvironmentEarthFactory;
import org.eclipse.apogy.core.environment.earth.EarthWorksite;
import org.eclipse.apogy.core.environment.earth.GeographicCoordinates;
import org.eclipse.apogy.core.environment.earth.HorizontalCoordinates;
import org.eclipse.apogy.core.environment.earth.surface.ApogyEarthSurfaceEnvironmentFacade;
import org.eclipse.apogy.core.environment.earth.surface.AstronomyUtils;
import org.eclipse.apogy.core.environment.earth.surface.EarthSkyNode;
import org.eclipse.apogy.core.environment.earth.surface.EarthSurfaceWorksite;
import org.eclipse.apogy.core.environment.earth.surface.impl.EarthSkyImpl;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EarthSkyCustomImpl
extends EarthSkyImpl {
    private static final Logger Logger = LoggerFactory.getLogger(EarthSkyImpl.class);
    private Adapter adapter = null;

    protected EarthSkyCustomImpl() {
        this.eAdapters().add((Object)this.getAdapter());
    }

    @Override
    public HorizontalCoordinates getSunHorizontalCoordinates() {
        if (super.getSunHorizontalCoordinates() == null) {
            HorizontalCoordinates newHorizontalCoordinates = ApogyCoreEnvironmentEarthFactory.eINSTANCE.createHorizontalCoordinates();
            this.setSunHorizontalCoordinates(newHorizontalCoordinates);
        }
        return this.sunHorizontalCoordinates;
    }

    @Override
    public Moon getMoon() {
        if (this.basicGetMoon() == null) {
            this.moon = this.findMoonInTopology();
        }
        return this.moon;
    }

    public SkyNode getSkyNode() {
        if (this.skyNode == null || !(this.skyNode instanceof EarthSkyNode)) {
            EarthWorksite earthSurfaceWorksite = (EarthWorksite)this.getWorksite();
            this.skyNode = ApogyEarthSurfaceEnvironmentFacade.INSTANCE.createEarthSkyNode(earthSurfaceWorksite.getGeographicalCoordinates());
            this.skyNode.setSky((Sky)this);
        }
        return super.getSkyNode();
    }

    @Override
    public HorizontalCoordinates getMoonHorizontalCoordinates() {
        if (super.getMoonHorizontalCoordinates() == null) {
            HorizontalCoordinates newHorizontalCoordinates = ApogyCoreEnvironmentEarthFactory.eINSTANCE.createHorizontalCoordinates();
            this.setMoonHorizontalCoordinates(newHorizontalCoordinates);
        }
        return this.moonHorizontalCoordinates;
    }

    @Override
    public double getMoonAngularDiameter() {
        TransformNode transform = (TransformNode)this.getMoon().getParent();
        Vector3d vector = new Vector3d();
        transform.asMatrix4d().get(vector);
        double distance = vector.length();
        double angularDiameter = Math.atan(this.getMoon().getRadius() / distance) * 2.0;
        return angularDiameter;
    }

    public double getSunAngularDiameter() {
        double angularDiameter = Math.toRadians(0.535833333);
        return angularDiameter;
    }

    public void setTime(Date newTime) {
        super.setTime(newTime);
        if (this.getWorksite() != null) {
            if (newTime != null) {
                this.updateSky(newTime.getTime());
            } else {
                this.updateSky(new Date().getTime());
            }
        }
    }

    private Moon findMoonInTopology() {
        Moon foundMoon = null;
        EList children = this.getSkyNode().getChildren();
        Iterator it = children.iterator();
        while (it.hasNext() && foundMoon == null) {
            Node node = (Node)it.next();
            if (!(node instanceof TransformNode)) continue;
            TransformNode t = (TransformNode)node;
            EList tChildren = t.getChildren();
            Iterator tIt = tChildren.iterator();
            while (tIt.hasNext() && foundMoon == null) {
                Node n = (Node)tIt.next();
                if (!(n instanceof Moon)) continue;
                foundMoon = (Moon)n;
            }
        }
        return foundMoon;
    }

    private void updateSky(long newTime) {
        GeographicCoordinates geographicalCoordinates;
        EarthWorksite worksite = (EarthWorksite)this.getWorksite();
        if (worksite != null && (geographicalCoordinates = worksite.getGeographicalCoordinates()) != null) {
            try {
                Date newDate = new Date(newTime);
                double observerLongitude = geographicalCoordinates.getLongitude();
                double observerLatitude = geographicalCoordinates.getLatitude();
                HorizontalCoordinates sunHorizontalCoordinates = AstronomyUtils.INSTANCE.getHorizontalSunPosition(newDate, observerLongitude, observerLatitude);
                this.setSunHorizontalCoordinates(sunHorizontalCoordinates);
                HorizontalCoordinates moonHorizontalCoordinates = AstronomyUtils.INSTANCE.getHorizontalMoonPosition(newDate, observerLongitude, observerLatitude);
                this.setMoonHorizontalCoordinates(moonHorizontalCoordinates);
            }
            catch (Exception e) {
                Logger.error("Error occured during Sky Update !", (Throwable)e);
            }
        }
    }

    private Adapter getAdapter() {
        if (this.adapter == null) {
            this.adapter = new AdapterImpl(){

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public void notifyChanged(Notification msg) {
                    try {
                        if (msg.getNotifier() instanceof EarthSkyCustomImpl) {
                            int featureId = msg.getFeatureID(EarthSkyCustomImpl.class);
                            switch (featureId) {
                                case 1: {
                                    if (msg.getOldValue() instanceof EarthSurfaceWorksite) {
                                        EarthSurfaceWorksite oldWorksite = (EarthSurfaceWorksite)msg.getOldValue();
                                        oldWorksite.eAdapters().remove((Object)EarthSkyCustomImpl.this.getAdapter());
                                        if (oldWorksite.getGeographicalCoordinates() != null) {
                                            oldWorksite.getGeographicalCoordinates().eAdapters().remove((Object)EarthSkyCustomImpl.this.getAdapter());
                                        }
                                    }
                                    if (!(msg.getNewValue() instanceof EarthSurfaceWorksite)) return;
                                    EarthSurfaceWorksite newWorksite = (EarthSurfaceWorksite)msg.getNewValue();
                                    newWorksite.eAdapters().add((Object)EarthSkyCustomImpl.this.getAdapter());
                                    if (newWorksite.getGeographicalCoordinates() == null) return;
                                    newWorksite.getGeographicalCoordinates().eAdapters().add((Object)EarthSkyCustomImpl.this.getAdapter());
                                    long time = new Date().getTime();
                                    if (EarthSkyCustomImpl.this.getTime() != null) {
                                        time = EarthSkyCustomImpl.this.getTime().getTime() + 1L;
                                    }
                                    EarthSkyCustomImpl.this.updateSky(time);
                                    return;
                                }
                                default: {
                                    return;
                                }
                            }
                        } else if (msg.getNotifier() instanceof EarthSurfaceWorksite) {
                            int featureId = msg.getFeatureID(EarthSurfaceWorksite.class);
                            switch (featureId) {
                                case 6: {
                                    if (msg.getOldValue() instanceof GeographicCoordinates) {
                                        GeographicCoordinates oldCoordinates = (GeographicCoordinates)msg.getOldValue();
                                        oldCoordinates.eAdapters().remove((Object)EarthSkyCustomImpl.this.getAdapter());
                                    }
                                    if (!(msg.getNewValue() instanceof GeographicCoordinates)) return;
                                    GeographicCoordinates newCoordinates = (GeographicCoordinates)msg.getNewValue();
                                    newCoordinates.eAdapters().add((Object)EarthSkyCustomImpl.this.getAdapter());
                                    long time = new Date().getTime();
                                    if (EarthSkyCustomImpl.this.getTime() != null) {
                                        time = EarthSkyCustomImpl.this.getTime().getTime() + 1L;
                                    }
                                    EarthSkyCustomImpl.this.updateSky(time);
                                }
                                default: {
                                    return;
                                }
                            }
                        } else {
                            if (!(msg.getNotifier() instanceof GeographicCoordinates)) return;
                            long time = new Date().getTime();
                            if (EarthSkyCustomImpl.this.getTime() != null) {
                                time = EarthSkyCustomImpl.this.getTime().getTime() + 1L;
                            }
                            EarthSkyCustomImpl.this.updateSky(time);
                        }
                        return;
                    }
                    catch (Throwable t) {
                        Logger.error("Error occured during worksite coordinates update !", t);
                    }
                }
            };
        }
        return this.adapter;
    }
}

