/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.earth.ui.parts;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.apogy.core.environment.earth.ApogyCoreEnvironmentEarthFacade;
import org.eclipse.apogy.core.environment.earth.GeographicCoordinates;
import org.eclipse.apogy.core.environment.earth.ui.AbstractEarthViewPoint;
import org.eclipse.apogy.core.environment.earth.ui.AbstractEarthViewPointReference;
import org.eclipse.apogy.core.environment.earth.ui.ApogyEarthEnvironmentUIFactory;
import org.eclipse.apogy.core.environment.earth.ui.EarthUIFacade;
import org.eclipse.apogy.core.environment.earth.ui.EarthViewConfiguration;
import org.eclipse.apogy.core.environment.earth.ui.EarthViewConfigurationList;
import org.eclipse.apogy.core.environment.earth.ui.EarthViewConfigurationReference;
import org.eclipse.apogy.core.environment.earth.ui.composites.EarthViewComposite;
import org.eclipse.apogy.core.invocator.InvocatorSession;
import org.eclipse.apogy.core.invocator.ui.ApogyCoreInvocatorUIFacade;
import org.eclipse.apogy.core.invocator.ui.parts.AbstractSessionPart;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.PersistState;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EarthViewPart
extends AbstractSessionPart<InvocatorSession> {
    public static final String EarthViewConfigurationID = "EarthViewConfiguration";
    public static final String EarthViewActiveViewPointID = "EarthViewActiveViewPoint";
    private static final Logger Logger = LoggerFactory.getLogger(EarthViewPart.class);
    public static final String partName = "Earth View";
    private EarthViewConfiguration earthViewConfiguration;
    private AbstractEarthViewPoint abstractEarthViewPoint = null;
    protected EarthViewComposite earthViewComposite;
    private EarthViewComposite.EarthViewMode earthViewMode = EarthViewComposite.EarthViewMode.ROUND;
    @Inject
    MPart mPart;
    @Inject
    ECommandService commandService;
    @Inject
    EHandlerService handlerService;
    @Inject
    ESelectionService selectionService;
    @Inject
    UISynchronize uiSynchronize;

    protected void createComposite(Composite parent, int style) {
        this.earthViewComposite = new EarthViewComposite(parent, 2048){

            @Override
            protected void newEarthViewConfigurationSelected(EarthViewConfiguration newEarthViewConfiguration) {
                EarthViewPart.this.earthViewConfiguration = newEarthViewConfiguration;
                EarthViewPart.this.selectionService.setSelection((Object)newEarthViewConfiguration);
                ParameterizedCommand command = EarthViewPart.this.commandService.createCommand("org.eclipse.apogy.core.environment.earth.ui.command.updateearthviewtoolbar", Collections.emptyMap());
                EarthViewPart.this.handlerService.executeHandler(command);
            }

            @Override
            protected void newPositionSelected(final GeographicCoordinates newGeographicCoordinates) {
                EarthViewPart.this.uiSynchronize.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        (this).EarthViewPart.this.selectionService.setSelection((Object)newGeographicCoordinates);
                    }
                });
            }
        };
        GridData gd_earthViewComposite = new GridData(4, 4, true, true);
        this.earthViewComposite.setLayoutData(gd_earthViewComposite);
        this.earthViewComposite.setEarthViewMode(this.earthViewMode);
    }

    protected void sessionChanged(InvocatorSession session) {
        this.setContent((EObject)session);
    }

    protected void doSetContent(InvocatorSession invocatorSession) {
        EarthViewConfigurationList earthViewConfigurationList = null;
        if (invocatorSession != null) {
            earthViewConfigurationList = EarthUIFacade.INSTANCE.getActiveEarthViewConfigurationList();
            this.mPart.setLabel(EarthViewPart.getPartName(this.earthViewConfiguration, this.abstractEarthViewPoint));
        }
        if (earthViewConfigurationList != null) {
            EarthViewConfigurationReference ref = (EarthViewConfigurationReference)ApogyCoreInvocatorUIFacade.INSTANCE.readFromPersistedState(this.mPart, EarthViewConfigurationID);
            if (ref != null) {
                this.earthViewConfiguration = ref.getEarthViewConfiguration();
                AbstractEarthViewPointReference vpReference = (AbstractEarthViewPointReference)ApogyCoreInvocatorUIFacade.INSTANCE.readFromPersistedState(this.mPart, EarthViewActiveViewPointID);
                if (vpReference != null) {
                    this.abstractEarthViewPoint = vpReference.getAbstractEarthViewPoint();
                } else {
                    Logger.warn("No Earth View Point could be read back, using the default.");
                }
            }
            if (this.abstractEarthViewPoint == null) {
                this.abstractEarthViewPoint = ApogyEarthEnvironmentUIFactory.eINSTANCE.createDefaultEarthViewPoint();
                GeographicCoordinates coord = ApogyCoreEnvironmentEarthFacade.INSTANCE.createGeographicCoordinates(0.0, 0.0, 6000000.0);
                this.abstractEarthViewPoint.setEyePosition(coord);
                this.abstractEarthViewPoint.setName("Temp");
            }
            if (this.earthViewConfiguration == null) {
                if (!earthViewConfigurationList.getEarthViewConfigurations().isEmpty()) {
                    this.earthViewConfiguration = (EarthViewConfiguration)earthViewConfigurationList.getEarthViewConfigurations().get(0);
                } else {
                    Logger.warn("No Earth View Configuration could be read back, setting it to null. ");
                }
            }
            this.earthViewComposite.setEarthViewConfigurationList(earthViewConfigurationList);
            this.earthViewComposite.setActiveViewPoint(this.abstractEarthViewPoint);
            this.selectionService.setSelection((Object)this.earthViewConfiguration);
            this.setEarthViewConfiguration(this.earthViewConfiguration);
            this.earthViewComposite.getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    EarthViewPart.this.setActiveViewPoint(EarthViewPart.this.abstractEarthViewPoint);
                }
            });
        }
    }

    @Inject
    @Optional
    private void setSelection(@Named(value="org.eclipse.ui.selection") EObject eObject, EPartService partService) {
        if (partService != null && partService.getActivePart() != null && partService.getActivePart() != this.mPart && this.getEarthViewConfiguration() != null) {
            ArrayList<EObject> tmp = new ArrayList<EObject>();
            tmp.add(eObject);
            this.getEarthViewConfiguration().selectionChanged(tmp);
        }
    }

    @Inject
    @Optional
    private void setSelection(@Named(value="org.eclipse.ui.selection") List<EObject> eObjectList, EPartService partService) {
        if (partService != null && partService.getActivePart() != null && partService.getActivePart() != this.mPart && this.getEarthViewConfiguration() != null && eObjectList != null) {
            this.getEarthViewConfiguration().selectionChanged(eObjectList);
        }
    }

    @PersistState
    public void userPersistState() {
        try {
            if (this.earthViewConfiguration != null) {
                EarthViewConfigurationReference ref = ApogyEarthEnvironmentUIFactory.eINSTANCE.createEarthViewConfigurationReference();
                ref.setEarthViewConfiguration(this.earthViewConfiguration);
                ApogyCoreInvocatorUIFacade.INSTANCE.saveToPersistedState(this.mPart, EarthViewConfigurationID, (EObject)ref);
                Logger.info("Persisted active Earth View Configuration.");
                if (this.earthViewComposite.getActiveViewPoint() != null) {
                    AbstractEarthViewPointReference vpReference = ApogyEarthEnvironmentUIFactory.eINSTANCE.createAbstractEarthViewPointReference();
                    vpReference.setAbstractEarthViewPoint(this.earthViewComposite.getActiveViewPoint());
                    ApogyCoreInvocatorUIFacade.INSTANCE.saveToPersistedState(this.mPart, EarthViewActiveViewPointID, (EObject)vpReference);
                    Logger.info("Persisted active Active View Point.");
                }
            }
            this.mPart.setLabel(partName);
        }
        catch (Throwable t) {
            Logger.error(t.getMessage(), t);
        }
    }

    public void setEarthViewMode(EarthViewComposite.EarthViewMode mode) {
        System.out.println("EarthViewPart.setEarthViewMode() " + (Object)((Object)mode));
        if (this.earthViewComposite != null && !this.earthViewComposite.isDisposed()) {
            this.earthViewComposite.setEarthViewMode(mode);
        }
        this.earthViewMode = mode;
    }

    public EarthViewComposite.EarthViewMode getEarthViewMode() {
        return this.earthViewMode;
    }

    public void setEarthViewConfiguration(EarthViewConfiguration earthViewConfiguration) {
        this.earthViewConfiguration = earthViewConfiguration;
        if (this.earthViewComposite != null && !this.earthViewComposite.isDisposed()) {
            this.earthViewComposite.setEarthViewConfiguration(this.earthViewConfiguration);
            System.out.println("======+> EarthViewPart.setEarthViewConfiguration()");
            this.selectionService.setSelection((Object)earthViewConfiguration);
        }
    }

    public EarthViewConfiguration getEarthViewConfiguration() {
        return this.earthViewConfiguration;
    }

    public void setActiveViewPoint(AbstractEarthViewPoint newViewPoint) {
        if (newViewPoint != null && this.earthViewComposite != null && !this.earthViewComposite.isDisposed()) {
            this.earthViewComposite.setActiveViewPoint(newViewPoint);
        }
    }

    public AbstractEarthViewPoint getActiveViewPoint() {
        if (this.earthViewComposite != null && !this.earthViewComposite.isDisposed()) {
            return this.earthViewComposite.getActiveViewPoint();
        }
        return null;
    }

    public static String getPartName(EarthViewConfiguration earthViewConfiguration, AbstractEarthViewPoint newViewPoint) {
        String name = partName;
        if (earthViewConfiguration != null) {
            name = String.valueOf(name) + " - " + earthViewConfiguration.getName();
        }
        if (newViewPoint != null) {
            name = String.valueOf(name) + " (" + newViewPoint.getName() + ")";
        }
        return name;
    }
}

