/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.surface.ui.wizards;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.apogy.core.environment.surface.AbstractMapLayer;
import org.eclipse.apogy.core.environment.surface.ImageMapLayer;
import org.eclipse.apogy.core.environment.surface.Map;
import org.eclipse.apogy.core.environment.surface.MapsList;
import org.eclipse.apogy.core.environment.surface.ui.MapLayerPresentationUISettings;
import org.eclipse.apogy.core.environment.surface.ui.composites.ImageMapLayerPresentationComposite;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;

public class ImageMapLayerPresentationWizardPage
extends WizardPage {
    private static final String WIZARD_PAGE_ID = "org.eclipse.apogy.core.environment.surface.ui.wizards.ImageMapLayerPresentationWizardPage";
    private final MapLayerPresentationUISettings mapLayerPresentationUISettings;
    private final AdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
    private Tree tree;
    private TreeViewer treeViewer;
    private ImageMapLayerPresentationComposite imageMapLayerPresentationComposite;

    public ImageMapLayerPresentationWizardPage(MapLayerPresentationUISettings mapLayerPresentationUISettings) {
        super(WIZARD_PAGE_ID);
        this.mapLayerPresentationUISettings = mapLayerPresentationUISettings;
        this.setTitle("Image Map Layer Presentation Settings");
        this.setDescription("Configure the Image Map Layer Presentation settings");
        this.validate();
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        Group imageLayersGroup = new Group(container, 0);
        imageLayersGroup.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        imageLayersGroup.setText("Image Layers");
        imageLayersGroup.setLayout((Layout)new GridLayout(1, false));
        this.treeViewer = new TreeViewer((Composite)imageLayersGroup, 68354);
        this.tree = this.treeViewer.getTree();
        GridData gd_tree = new GridData(4, 4, true, true, 1, 1);
        gd_tree.widthHint = 300;
        gd_tree.minimumWidth = 300;
        this.tree.setLayoutData((Object)gd_tree);
        this.tree.setLinesVisible(true);
        this.treeViewer.setContentProvider((IContentProvider)new CompositeFilterContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider(this.adapterFactory));
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ImageMapLayer imageMapLayer = (ImageMapLayer)((IStructuredSelection)event.getSelection()).getFirstElement();
                ImageMapLayerPresentationWizardPage.this.mapLayerPresentationUISettings.setImageMapLayer(imageMapLayer);
                ImageMapLayerPresentationWizardPage.this.validate();
            }
        });
        MapsList mapList = (MapsList)this.mapLayerPresentationUISettings.getCartesianTriangularMeshMapLayer().getMap().eContainer();
        this.treeViewer.setInput((Object)mapList);
        this.setControl((Control)container);
        Group presentationSettingsGroup = new Group(container, 0);
        presentationSettingsGroup.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        presentationSettingsGroup.setText("Settings");
        presentationSettingsGroup.setLayout((Layout)new GridLayout(2, false));
        this.imageMapLayerPresentationComposite = new ImageMapLayerPresentationComposite((Composite)presentationSettingsGroup, 0);
        this.imageMapLayerPresentationComposite.setImageMapLayerPresentation(this.mapLayerPresentationUISettings.getImageMapLayerPresentation());
        new Label((Composite)presentationSettingsGroup, 0);
    }

    protected void validate() {
        if (this.mapLayerPresentationUISettings.getImageMapLayer() != null) {
            this.setErrorMessage(null);
            this.setPageComplete(true);
        } else {
            this.setErrorMessage("The Image Map Layer is not set !");
            this.setPageComplete(false);
        }
    }

    public class CompositeFilterContentProvider
    implements ITreeContentProvider {
        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof MapsList) {
                MapsList mapsList = (MapsList)inputElement;
                return mapsList.getMaps().toArray();
            }
            if (inputElement instanceof Map) {
                Map map = (Map)inputElement;
                return this.filterMap(map).toArray();
            }
            return null;
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof MapsList) {
                MapsList mapsList = (MapsList)parentElement;
                return mapsList.getMaps().toArray();
            }
            if (parentElement instanceof Map) {
                Map map = (Map)parentElement;
                return this.filterMap(map).toArray();
            }
            return null;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof MapsList) {
                MapsList mapsList = (MapsList)element;
                return !mapsList.getMaps().isEmpty();
            }
            if (element instanceof Map) {
                Map map = (Map)element;
                return !this.filterMap(map).isEmpty();
            }
            return false;
        }

        protected List<ImageMapLayer> filterMap(Map map) {
            ArrayList<ImageMapLayer> imageMapLayers = new ArrayList<ImageMapLayer>();
            for (AbstractMapLayer layer : map.getLayers()) {
                if (!(layer instanceof ImageMapLayer)) continue;
                imageMapLayers.add((ImageMapLayer)layer);
            }
            return imageMapLayers;
        }
    }
}

