/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.topology.ui.composites;

import org.eclipse.apogy.common.emf.ui.composites.AbstractEObjectComposite;
import org.eclipse.apogy.common.topology.Node;
import org.eclipse.apogy.common.topology.ui.MeshPresentationMode;
import org.eclipse.apogy.common.topology.ui.composites.TopologyTreeComposite;
import org.eclipse.apogy.core.ApogySystem;
import org.eclipse.apogy.core.topology.ui.DisplayedTopology;
import org.eclipse.apogy.core.topology.ui.internal.ApogySystem3dUtils;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class ApogySystemTopologyComposite
extends AbstractEObjectComposite<ApogySystem, ApogySystem, ApogySystem> {
    private AdapterFactory adapterFactory;
    protected FormToolkit formToolkit;
    protected ApogySystem apogySystem;
    protected DisplayedTopology displayedTopology;
    protected Node systemRoot;
    protected Node assemblyRoot;
    private TopologyTreeComposite systemTopologyTreeComposite;
    private TopologyTreeComposite assemblyTopologyTreeComposite;

    public ApogySystemTopologyComposite(Composite parent, int style) {
        super(parent, style);
    }

    protected Composite createContentComposite(Composite parent, int style) {
        this.displayedTopology = DisplayedTopology.ASSEMBLY;
        this.adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        this.formToolkit = new FormToolkit(Display.getDefault());
        Composite top = new Composite(parent, style);
        top.setLayout((Layout)new GridLayout(1, false));
        ScrolledForm scrolledForm = this.formToolkit.createScrolledForm(top);
        scrolledForm.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.formToolkit.paintBordersFor((Composite)scrolledForm);
        TableWrapLayout tableWrapLayout = new TableWrapLayout();
        tableWrapLayout.numColumns = 1;
        tableWrapLayout.makeColumnsEqualWidth = true;
        scrolledForm.getBody().setLayout((Layout)tableWrapLayout);
        Section sctnDisplaySettings = this.formToolkit.createSection(scrolledForm.getBody(), 322);
        TableWrapData twd_sctnDisplaySettings = new TableWrapData(2, 16, 1, 1);
        twd_sctnDisplaySettings.valign = 128;
        twd_sctnDisplaySettings.grabVertical = true;
        twd_sctnDisplaySettings.grabHorizontal = true;
        sctnDisplaySettings.setLayoutData((Object)twd_sctnDisplaySettings);
        this.formToolkit.paintBordersFor((Composite)sctnDisplaySettings);
        sctnDisplaySettings.setText("3D Display Settings");
        Composite displaySettingsComposite = new Composite((Composite)sctnDisplaySettings, 0);
        displaySettingsComposite.setLayout((Layout)new GridLayout(4, false));
        GridData gd_displaySettingsComposite = new GridData(4, 128, true, false);
        displaySettingsComposite.setLayoutData((Object)gd_displaySettingsComposite);
        this.formToolkit.adapt(displaySettingsComposite);
        this.formToolkit.paintBordersFor(displaySettingsComposite);
        sctnDisplaySettings.setClient((Control)displaySettingsComposite);
        Label lblDisplayedTopologyChoice = new Label(displaySettingsComposite, 0);
        lblDisplayedTopologyChoice.setText("Displayed Topology");
        final ComboViewer comboViewerDisplayedTopology = new ComboViewer(displaySettingsComposite, 0);
        comboViewerDisplayedTopology.setContentProvider((IContentProvider)new ArrayContentProvider());
        comboViewerDisplayedTopology.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider(this.adapterFactory));
        comboViewerDisplayedTopology.setInput((Object)DisplayedTopology.values());
        comboViewerDisplayedTopology.setSelection((ISelection)new StructuredSelection((Object)this.displayedTopology), true);
        comboViewerDisplayedTopology.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                DisplayedTopology displayedTopology = (DisplayedTopology)((Object)comboViewerDisplayedTopology.getStructuredSelection().getFirstElement());
                ApogySystemTopologyComposite.this.setDisplayedTopology(displayedTopology);
            }
        });
        Label cadNodeDisplayMode = new Label(displaySettingsComposite, 0);
        cadNodeDisplayMode.setText("Sub-System Display Mode:");
        final ComboViewer comboSubSystemPresentationMode = new ComboViewer(displaySettingsComposite, 0);
        comboSubSystemPresentationMode.setContentProvider((IContentProvider)new ArrayContentProvider());
        comboSubSystemPresentationMode.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider(this.adapterFactory));
        comboSubSystemPresentationMode.setInput((Object)MeshPresentationMode.values());
        comboSubSystemPresentationMode.setSelection((ISelection)new StructuredSelection((Object)MeshPresentationMode.SURFACE), true);
        comboSubSystemPresentationMode.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                MeshPresentationMode meshPresentationMode = (MeshPresentationMode)comboSubSystemPresentationMode.getStructuredSelection().getFirstElement();
                ApogySystemTopologyComposite.this.setSubSystemDisplayMode(meshPresentationMode);
            }
        });
        Section sctnSystemTopology = this.formToolkit.createSection(scrolledForm.getBody(), 322);
        TableWrapData twd_sctnDemlist = new TableWrapData(2, 16, 1, 1);
        twd_sctnDemlist.valign = 128;
        twd_sctnDemlist.grabVertical = true;
        twd_sctnDemlist.grabHorizontal = true;
        sctnSystemTopology.setLayoutData((Object)twd_sctnDemlist);
        this.formToolkit.paintBordersFor((Composite)sctnSystemTopology);
        sctnSystemTopology.setText("System");
        this.systemTopologyTreeComposite = new TopologyTreeComposite((Composite)sctnSystemTopology, 0){

            protected void createButtons(Composite parent, int style) {
                this.createNewButton(parent, style);
                this.createDeleteButton(parent, style);
            }

            protected void selectionChanged(IStructuredSelection selection) {
                if (!selection.isEmpty() && selection.getFirstElement() instanceof Node) {
                    ApogySystemTopologyComposite.this.nodeSelected((Node)selection.getFirstElement());
                }
            }
        };
        this.formToolkit.adapt((Composite)this.systemTopologyTreeComposite);
        this.formToolkit.paintBordersFor((Composite)this.systemTopologyTreeComposite);
        sctnSystemTopology.setClient((Control)this.systemTopologyTreeComposite);
        Section sctnAssemblyTopology = this.formToolkit.createSection(scrolledForm.getBody(), 258);
        TableWrapData twd_sctnAssemblyTopology = new TableWrapData(2, 16, 1, 1);
        twd_sctnAssemblyTopology.valign = 128;
        twd_sctnAssemblyTopology.grabVertical = true;
        twd_sctnAssemblyTopology.grabHorizontal = true;
        sctnAssemblyTopology.setLayoutData((Object)twd_sctnAssemblyTopology);
        this.formToolkit.paintBordersFor((Composite)sctnAssemblyTopology);
        sctnAssemblyTopology.setText("Assembly");
        this.assemblyTopologyTreeComposite = new TopologyTreeComposite((Composite)sctnAssemblyTopology, 0){

            protected void createButtons(Composite parent, int style) {
            }

            protected void selectionChanged(IStructuredSelection selection) {
                if (!selection.isEmpty() && selection.getFirstElement() instanceof Node) {
                    ApogySystemTopologyComposite.this.nodeSelected((Node)selection.getFirstElement());
                }
            }
        };
        this.formToolkit.adapt((Composite)this.assemblyTopologyTreeComposite);
        this.formToolkit.paintBordersFor((Composite)this.assemblyTopologyTreeComposite);
        sctnAssemblyTopology.setClient((Control)this.assemblyTopologyTreeComposite);
        return top;
    }

    protected void rootEObjectChanged(ApogySystem newApogySystem) {
        if (this.apogySystem != newApogySystem) {
            // empty if block
        }
        this.apogySystem = newApogySystem;
        if (newApogySystem != null) {
            if (newApogySystem.getTopologyRoot() != null) {
                this.setSystemRoot(newApogySystem.getTopologyRoot().getOriginNode());
            } else {
                this.setSystemRoot(null);
            }
        } else {
            this.setSystemRoot(null);
            this.setAssemblyRoot(null);
        }
    }

    public Node getAssemblyRoot() {
        return this.assemblyRoot;
    }

    public void setAssemblyRoot(Node newNode) {
        this.assemblyRoot = newNode;
    }

    public void selectNode(Node selectedNode) {
        if (this.assemblyTopologyTreeComposite != null) {
            this.assemblyTopologyTreeComposite.isDisposed();
        }
        this.nodeSelected(selectedNode);
    }

    protected void newDisplayedTopologySelected(DisplayedTopology newDisplayedTopology) {
    }

    protected Node getSystemRoot() {
        return this.systemRoot;
    }

    protected void setSystemRoot(Node newSystemRoot) {
        this.systemRoot = newSystemRoot;
        this.systemTopologyTreeComposite.setRootEObject((EObject)newSystemRoot);
    }

    protected void nodeSelected(Node node) {
    }

    private void setDisplayedTopology(DisplayedTopology newDisplayedTopology) {
        this.displayedTopology = newDisplayedTopology;
        this.newDisplayedTopologySelected(newDisplayedTopology);
    }

    private void setSubSystemDisplayMode(MeshPresentationMode newMeshPresentationMode) {
        ApogySystem3dUtils.setSubSystemMode(this.getAssemblyRoot(), newMeshPresentationMode);
    }
}

