/*
 * Decompiled with CFR 0.152.
 */
package javax.measure.unit;

import java.io.IOException;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.HashMap;
import java.util.Locale;
import javax.measure.converter.AddConverter;
import javax.measure.converter.MultiplyConverter;
import javax.measure.converter.RationalConverter;
import javax.measure.converter.UnitConverter;
import javax.measure.quantity.Quantity;
import javax.measure.unit.AlternateUnit;
import javax.measure.unit.BaseUnit;
import javax.measure.unit.CompoundUnit;
import javax.measure.unit.NonSI;
import javax.measure.unit.ProductUnit;
import javax.measure.unit.SI;
import javax.measure.unit.TransformedUnit;
import javax.measure.unit.Unit;

public abstract class UnitFormat
extends Format {
    private static final long serialVersionUID = 1098093680937760914L;
    private static final DefaultFormat DEFAULT = new DefaultFormat();
    private static final ASCIIFormat ASCII = new ASCIIFormat();
    private static final Unit<?>[] SI_UNITS = new Unit[]{SI.AMPERE, SI.BECQUEREL, SI.CANDELA, SI.COULOMB, SI.FARAD, SI.GRAY, SI.HENRY, SI.HERTZ, SI.JOULE, SI.KATAL, SI.KELVIN, SI.LUMEN, SI.LUX, SI.METRE, SI.MOLE, SI.NEWTON, SI.OHM, SI.PASCAL, SI.RADIAN, SI.SECOND, SI.SIEMENS, SI.SIEVERT, SI.STERADIAN, SI.TESLA, SI.VOLT, SI.WATT, SI.WEBER};
    private static final String[] PREFIXES = new String[]{"Y", "Z", "E", "P", "T", "G", "M", "k", "h", "da", "d", "c", "m", "\u00b5", "n", "p", "f", "a", "z", "y"};
    private static final UnitConverter[] CONVERTERS = new UnitConverter[]{SI.E24, SI.E21, SI.E18, SI.E15, SI.E12, SI.E9, SI.E6, SI.E3, SI.E2, SI.E1, SI.Em1, SI.Em2, SI.Em3, SI.Em6, SI.Em9, SI.Em12, SI.Em15, SI.Em18, SI.Em21, SI.Em24};

    static {
        int i = 0;
        while (i < SI_UNITS.length) {
            int j = 0;
            while (j < PREFIXES.length) {
                Unit<?> si = SI_UNITS[i];
                Unit<?> u = si.transform(CONVERTERS[j]);
                String symbol = si instanceof BaseUnit ? ((BaseUnit)si).getSymbol() : ((AlternateUnit)si).getSymbol();
                DEFAULT.label(u, String.valueOf(PREFIXES[j]) + symbol);
                if (PREFIXES[j] == "\u00b5") {
                    ASCII.label(u, "micro" + symbol);
                }
                ++j;
            }
            ++i;
        }
        DEFAULT.label(SI.GRAM, "g");
        i = 0;
        while (i < PREFIXES.length) {
            if (CONVERTERS[i] != SI.E3) {
                DEFAULT.label(SI.KILOGRAM.transform(CONVERTERS[i].concatenate(SI.Em3)), String.valueOf(PREFIXES[i]) + "g");
                if (PREFIXES[i] == "\u00b5") {
                    ASCII.label(SI.KILOGRAM.transform(CONVERTERS[i].concatenate(SI.Em3)), "microg");
                }
            }
            ++i;
        }
        DEFAULT.alias(SI.OHM, "Ohm");
        ASCII.label(SI.OHM, "Ohm");
        i = 0;
        while (i < PREFIXES.length) {
            DEFAULT.alias(SI.OHM.transform(CONVERTERS[i]), String.valueOf(PREFIXES[i]) + "Ohm");
            ASCII.label(SI.OHM.transform(CONVERTERS[i]), String.valueOf(UnitFormat.asciiPrefix(PREFIXES[i])) + "Ohm");
            ++i;
        }
        DEFAULT.label(SI.CELSIUS, "\u2103");
        DEFAULT.alias(SI.CELSIUS, "\u00b0C");
        ASCII.label(SI.CELSIUS, "Celsius");
        i = 0;
        while (i < PREFIXES.length) {
            DEFAULT.label(SI.CELSIUS.transform(CONVERTERS[i]), String.valueOf(PREFIXES[i]) + "\u2103");
            DEFAULT.alias(SI.CELSIUS.transform(CONVERTERS[i]), String.valueOf(PREFIXES[i]) + "\u00b0C");
            ASCII.label(SI.CELSIUS.transform(CONVERTERS[i]), String.valueOf(UnitFormat.asciiPrefix(PREFIXES[i])) + "Celsius");
            ++i;
        }
        DEFAULT.label(NonSI.PERCENT, "%");
        DEFAULT.label(NonSI.DECIBEL, "dB");
        DEFAULT.label(NonSI.G, "grav");
        DEFAULT.label(NonSI.ATOM, "atom");
        DEFAULT.label(NonSI.REVOLUTION, "rev");
        DEFAULT.label(NonSI.DEGREE_ANGLE, "\u00b0");
        ASCII.label(NonSI.DEGREE_ANGLE, "degree_angle");
        DEFAULT.label(NonSI.MINUTE_ANGLE, "'");
        DEFAULT.label(NonSI.SECOND_ANGLE, "\"");
        DEFAULT.label(NonSI.CENTIRADIAN, "centiradian");
        DEFAULT.label(NonSI.GRADE, "grade");
        DEFAULT.label(NonSI.ARE, "a");
        DEFAULT.label(NonSI.HECTARE, "ha");
        DEFAULT.label(NonSI.BYTE, "byte");
        DEFAULT.label(NonSI.MINUTE, "min");
        DEFAULT.label(NonSI.HOUR, "h");
        DEFAULT.label(NonSI.DAY, "day");
        DEFAULT.label(NonSI.WEEK, "week");
        DEFAULT.label(NonSI.YEAR, "year");
        DEFAULT.label(NonSI.MONTH, "month");
        DEFAULT.label(NonSI.DAY_SIDEREAL, "day_sidereal");
        DEFAULT.label(NonSI.YEAR_SIDEREAL, "year_sidereal");
        DEFAULT.label(NonSI.YEAR_CALENDAR, "year_calendar");
        DEFAULT.label(NonSI.E, "e");
        DEFAULT.label(NonSI.FARADAY, "Fd");
        DEFAULT.label(NonSI.FRANKLIN, "Fr");
        DEFAULT.label(NonSI.GILBERT, "Gi");
        DEFAULT.label(NonSI.ERG, "erg");
        DEFAULT.label(NonSI.ELECTRON_VOLT, "eV");
        DEFAULT.label(SI.KILO(NonSI.ELECTRON_VOLT), "keV");
        DEFAULT.label(SI.MEGA(NonSI.ELECTRON_VOLT), "MeV");
        DEFAULT.label(SI.GIGA(NonSI.ELECTRON_VOLT), "GeV");
        DEFAULT.label(NonSI.LAMBERT, "La");
        DEFAULT.label(NonSI.FOOT, "ft");
        DEFAULT.label(NonSI.FOOT_SURVEY_US, "foot_survey_us");
        DEFAULT.label(NonSI.YARD, "yd");
        DEFAULT.label(NonSI.INCH, "in");
        DEFAULT.label(NonSI.MILE, "mi");
        DEFAULT.label(NonSI.NAUTICAL_MILE, "nmi");
        DEFAULT.label(NonSI.MILES_PER_HOUR, "mph");
        DEFAULT.label(NonSI.ANGSTROM, "\u00c5");
        ASCII.label(NonSI.ANGSTROM, "Angstrom");
        DEFAULT.label(NonSI.ASTRONOMICAL_UNIT, "ua");
        DEFAULT.label(NonSI.LIGHT_YEAR, "ly");
        DEFAULT.label(NonSI.PARSEC, "pc");
        DEFAULT.label(NonSI.POINT, "pt");
        DEFAULT.label(NonSI.PIXEL, "pixel");
        DEFAULT.label(NonSI.MAXWELL, "Mx");
        DEFAULT.label(NonSI.GAUSS, "G");
        DEFAULT.label(NonSI.ATOMIC_MASS, "u");
        DEFAULT.label(NonSI.ELECTRON_MASS, "me");
        DEFAULT.label(NonSI.POUND, "lb");
        DEFAULT.label(NonSI.OUNCE, "oz");
        DEFAULT.label(NonSI.TON_US, "ton_us");
        DEFAULT.label(NonSI.TON_UK, "ton_uk");
        DEFAULT.label(NonSI.METRIC_TON, "t");
        DEFAULT.label(NonSI.DYNE, "dyn");
        DEFAULT.label(NonSI.KILOGRAM_FORCE, "kgf");
        DEFAULT.label(NonSI.POUND_FORCE, "lbf");
        DEFAULT.label(NonSI.HORSEPOWER, "hp");
        DEFAULT.label(NonSI.ATMOSPHERE, "atm");
        DEFAULT.label(NonSI.BAR, "bar");
        DEFAULT.label(NonSI.MILLIMETER_OF_MERCURY, "mmHg");
        DEFAULT.label(NonSI.INCH_OF_MERCURY, "inHg");
        DEFAULT.label(NonSI.RAD, "rd");
        DEFAULT.label(NonSI.REM, "rem");
        DEFAULT.label(NonSI.CURIE, "Ci");
        DEFAULT.label(NonSI.RUTHERFORD, "Rd");
        DEFAULT.label(NonSI.SPHERE, "sphere");
        DEFAULT.label(NonSI.RANKINE, "\u00b0R");
        ASCII.label(NonSI.RANKINE, "degree_rankine");
        DEFAULT.label(NonSI.FAHRENHEIT, "\u00b0F");
        ASCII.label(NonSI.FAHRENHEIT, "degree_fahrenheit");
        DEFAULT.label(NonSI.KNOT, "kn");
        DEFAULT.label(NonSI.MACH, "Mach");
        DEFAULT.label(NonSI.C, "c");
        DEFAULT.label(NonSI.LITRE, "L");
        DEFAULT.label(SI.MICRO(NonSI.LITRE), "\u00b5L");
        ASCII.label(SI.MICRO(NonSI.LITRE), "microL");
        DEFAULT.label(SI.MILLI(NonSI.LITRE), "mL");
        DEFAULT.label(SI.CENTI(NonSI.LITRE), "cL");
        DEFAULT.label(SI.DECI(NonSI.LITRE), "dL");
        DEFAULT.label(NonSI.GALLON_LIQUID_US, "gallon_us");
        DEFAULT.label(NonSI.OUNCE_LIQUID_US, "oz_liquid_us");
        DEFAULT.label(NonSI.GALLON_DRY_US, "gallon_dry_us");
        DEFAULT.label(NonSI.GALLON_UK, "gallon_uk");
        DEFAULT.label(NonSI.OUNCE_LIQUID_UK, "oz_liquid_uk");
        DEFAULT.label(NonSI.ROENTGEN, "Roentgen");
    }

    public static UnitFormat getInstance() {
        return UnitFormat.getInstance(Locale.getDefault());
    }

    public static UnitFormat getInstance(Locale inLocale) {
        return DEFAULT;
    }

    public static UnitFormat getUCUMInstance() {
        return ASCII;
    }

    protected UnitFormat() {
    }

    public abstract Appendable format(Unit<?> var1, Appendable var2) throws IOException;

    public abstract Unit<? extends Quantity> parseProductUnit(CharSequence var1, ParsePosition var2) throws ParseException;

    public abstract Unit<? extends Quantity> parseSingleUnit(CharSequence var1, ParsePosition var2) throws ParseException;

    public abstract void label(Unit<?> var1, String var2);

    public abstract void alias(Unit<?> var1, String var2);

    public abstract boolean isValidIdentifier(String var1);

    @Override
    public final StringBuffer format(Object unit, final StringBuffer toAppendTo, FieldPosition pos) {
        try {
            StringBuffer dest = toAppendTo;
            if (dest instanceof Appendable) {
                this.format((Unit)unit, dest);
            } else {
                this.format((Unit)unit, new Appendable(){

                    @Override
                    public Appendable append(char arg0) throws IOException {
                        toAppendTo.append(arg0);
                        return null;
                    }

                    @Override
                    public Appendable append(CharSequence arg0) throws IOException {
                        toAppendTo.append(arg0);
                        return null;
                    }

                    @Override
                    public Appendable append(CharSequence arg0, int arg1, int arg2) throws IOException {
                        toAppendTo.append(arg0.subSequence(arg1, arg2));
                        return null;
                    }
                });
            }
            return toAppendTo;
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    @Override
    public final Unit<?> parseObject(String source, ParsePosition pos) {
        int start = pos.getIndex();
        try {
            return this.parseProductUnit(source, pos);
        }
        catch (ParseException e) {
            pos.setIndex(start);
            pos.setErrorIndex(e.getErrorOffset());
            return null;
        }
    }

    private static String asciiPrefix(String prefix) {
        return prefix == "\u00b5" ? "micro" : prefix;
    }

    protected static class ASCIIFormat
    extends DefaultFormat {
        private static final long serialVersionUID = 1L;

        protected ASCIIFormat() {
        }

        @Override
        public String nameFor(Unit<?> unit) {
            String name = (String)this._unitToName.get(unit);
            if (name != null) {
                return name;
            }
            return DEFAULT.nameFor(unit);
        }

        @Override
        public Unit<?> unitFor(String name) {
            Unit unit = (Unit)this._nameToUnit.get(name);
            if (unit != null) {
                return unit;
            }
            return DEFAULT.unitFor(name);
        }

        @Override
        public Appendable format(Unit<?> unit, Appendable appendable) throws IOException {
            String name = this.nameFor(unit);
            if (name != null) {
                return appendable.append(name);
            }
            if (!(unit instanceof ProductUnit)) {
                throw new IllegalArgumentException("Cannot format given Object as a Unit");
            }
            ProductUnit productUnit = (ProductUnit)unit;
            int i = 0;
            while (i < productUnit.getUnitCount()) {
                if (i != 0) {
                    appendable.append('*');
                }
                name = this.nameFor(productUnit.getUnit(i));
                int pow = productUnit.getUnitPow(i);
                int root = productUnit.getUnitRoot(i);
                appendable.append(name);
                if (pow != 1 || root != 1) {
                    appendable.append('^');
                    appendable.append(String.valueOf(pow));
                    if (root != 1) {
                        appendable.append(':');
                        appendable.append(String.valueOf(root));
                    }
                }
                ++i;
            }
            return appendable;
        }
    }

    protected static class DefaultFormat
    extends UnitFormat {
        final HashMap<String, Unit<?>> _nameToUnit = new HashMap();
        final HashMap<Unit<?>, String> _unitToName = new HashMap();
        private static final int EOF = 0;
        private static final int IDENTIFIER = 1;
        private static final int OPEN_PAREN = 2;
        private static final int CLOSE_PAREN = 3;
        private static final int EXPONENT = 4;
        private static final int MULTIPLY = 5;
        private static final int DIVIDE = 6;
        private static final int PLUS = 7;
        private static final int INTEGER = 8;
        private static final int FLOAT = 9;
        private static final long serialVersionUID = 1L;

        protected DefaultFormat() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void label(Unit<?> unit, String label) {
            if (!this.isValidIdentifier(label)) {
                throw new IllegalArgumentException("Label: " + label + " is not a valid identifier.");
            }
            DefaultFormat defaultFormat = this;
            synchronized (defaultFormat) {
                this._nameToUnit.put(label, unit);
                this._unitToName.put(unit, label);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void alias(Unit<?> unit, String alias) {
            if (!this.isValidIdentifier(alias)) {
                throw new IllegalArgumentException("Alias: " + alias + " is not a valid identifier.");
            }
            DefaultFormat defaultFormat = this;
            synchronized (defaultFormat) {
                this._nameToUnit.put(alias, unit);
            }
        }

        @Override
        public boolean isValidIdentifier(String name) {
            if (name == null || name.length() == 0) {
                return false;
            }
            int i = 0;
            while (i < name.length()) {
                if (!DefaultFormat.isUnitIdentifierPart(name.charAt(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        static boolean isUnitIdentifierPart(char ch) {
            return Character.isLetter(ch) || !Character.isWhitespace(ch) && !Character.isDigit(ch) && ch != '\u00b7' && ch != '*' && ch != '/' && ch != '(' && ch != ')' && ch != '[' && ch != ']' && ch != '\u00b9' && ch != '\u00b2' && ch != '\u00b3' && ch != '^' && ch != '+' && ch != '-';
        }

        public String nameFor(Unit<?> unit) {
            String label = this._unitToName.get(unit);
            if (label != null) {
                return label;
            }
            if (unit instanceof BaseUnit) {
                return ((BaseUnit)unit).getSymbol();
            }
            if (unit instanceof AlternateUnit) {
                return ((AlternateUnit)unit).getSymbol();
            }
            if (unit instanceof TransformedUnit) {
                TransformedUnit tfmUnit = (TransformedUnit)unit;
                Unit baseUnits = tfmUnit.getStandardUnit();
                UnitConverter cvtr = tfmUnit.toStandardUnit();
                StringBuffer result = new StringBuffer();
                String baseUnitName = baseUnits.toString();
                if (baseUnitName.indexOf(183) >= 0 || baseUnitName.indexOf(42) >= 0 || baseUnitName.indexOf(47) >= 0) {
                    result.append('(');
                    result.append(baseUnitName);
                    result.append(')');
                } else {
                    result.append(baseUnitName);
                }
                if (cvtr instanceof AddConverter) {
                    result.append('+');
                    result.append(((AddConverter)cvtr).getOffset());
                } else if (cvtr instanceof RationalConverter) {
                    long divisor;
                    long dividend = ((RationalConverter)cvtr).getDividend();
                    if (dividend != 1L) {
                        result.append('*');
                        result.append(dividend);
                    }
                    if ((divisor = ((RationalConverter)cvtr).getDivisor()) != 1L) {
                        result.append('/');
                        result.append(divisor);
                    }
                } else if (cvtr instanceof MultiplyConverter) {
                    result.append('*');
                    result.append(((MultiplyConverter)cvtr).getFactor());
                } else {
                    return "[" + baseUnits + "?]";
                }
                return result.toString();
            }
            if (unit instanceof CompoundUnit) {
                CompoundUnit cpdUnit = (CompoundUnit)unit;
                return String.valueOf(this.nameFor(cpdUnit.getHigher()).toString()) + ":" + this.nameFor(cpdUnit.getLower());
            }
            return null;
        }

        public Unit<?> unitFor(String name) {
            Unit<?> unit = this._nameToUnit.get(name);
            if (unit != null) {
                return unit;
            }
            unit = Unit.SYMBOL_TO_UNIT.get(name);
            return unit;
        }

        @Override
        public Unit<? extends Quantity> parseSingleUnit(CharSequence csq, ParsePosition pos) throws ParseException {
            int startIndex = pos.getIndex();
            String name = this.readIdentifier(csq, pos);
            Unit<?> unit = this.unitFor(name);
            this.check(unit != null, String.valueOf(name) + " not recognized", csq, startIndex);
            return unit;
        }

        @Override
        public Unit<? extends Quantity> parseProductUnit(CharSequence csq, ParsePosition pos) throws ParseException {
            Unit<Quantity> result = Unit.ONE;
            int token = this.nextToken(csq, pos);
            switch (token) {
                case 1: {
                    result = this.parseSingleUnit(csq, pos);
                    break;
                }
                case 2: {
                    pos.setIndex(pos.getIndex() + 1);
                    result = this.parseProductUnit(csq, pos);
                    token = this.nextToken(csq, pos);
                    this.check(token == 3, "')' expected", csq, pos.getIndex());
                    pos.setIndex(pos.getIndex() + 1);
                }
            }
            token = this.nextToken(csq, pos);
            while (true) {
                switch (token) {
                    case 4: {
                        Exponent e = this.readExponent(csq, pos);
                        if (e.pow != 1) {
                            result = result.pow(e.pow);
                        }
                        if (e.root == 1) break;
                        result = result.root(e.root);
                        break;
                    }
                    case 5: {
                        pos.setIndex(pos.getIndex() + 1);
                        token = this.nextToken(csq, pos);
                        if (token == 8) {
                            long n = this.readLong(csq, pos);
                            if (n == 1L) break;
                            result = result.times(n);
                            break;
                        }
                        if (token == 9) {
                            double d = this.readDouble(csq, pos);
                            if (d == 1.0) break;
                            result = result.times(d);
                            break;
                        }
                        result = result.times(this.parseProductUnit(csq, pos));
                        break;
                    }
                    case 6: {
                        pos.setIndex(pos.getIndex() + 1);
                        token = this.nextToken(csq, pos);
                        if (token == 8) {
                            long n = this.readLong(csq, pos);
                            if (n == 1L) break;
                            result = result.divide(n);
                            break;
                        }
                        if (token == 9) {
                            double d = this.readDouble(csq, pos);
                            if (d == 1.0) break;
                            result = result.divide(d);
                            break;
                        }
                        result = result.divide(this.parseProductUnit(csq, pos));
                        break;
                    }
                    case 7: {
                        pos.setIndex(pos.getIndex() + 1);
                        token = this.nextToken(csq, pos);
                        if (token == 8) {
                            long n = this.readLong(csq, pos);
                            if (n == 1L) break;
                            result = result.plus(n);
                            break;
                        }
                        if (token == 9) {
                            double d = this.readDouble(csq, pos);
                            if (d == 1.0) break;
                            result = result.plus(d);
                            break;
                        }
                        throw new ParseException("not a number", pos.getIndex());
                    }
                    case 0: 
                    case 3: {
                        return result;
                    }
                    default: {
                        throw new ParseException("unexpected token " + token, pos.getIndex());
                    }
                }
                token = this.nextToken(csq, pos);
            }
        }

        private int nextToken(CharSequence csq, ParsePosition pos) {
            int length = csq.length();
            while (pos.getIndex() < length) {
                char c = csq.charAt(pos.getIndex());
                if (DefaultFormat.isUnitIdentifierPart(c)) {
                    return 1;
                }
                if (c == '(') {
                    return 2;
                }
                if (c == ')') {
                    return 3;
                }
                if (c == '^' || c == '\u00b9' || c == '\u00b2' || c == '\u00b3') {
                    return 4;
                }
                if (c == '*') {
                    char c2 = csq.charAt(pos.getIndex() + 1);
                    if (c2 == '*') {
                        return 4;
                    }
                    return 5;
                }
                if (c == '\u00b7') {
                    return 5;
                }
                if (c == '/') {
                    return 6;
                }
                if (c == '+') {
                    return 7;
                }
                if (c == '-' || Character.isDigit(c)) {
                    int index = pos.getIndex() + 1;
                    while (index < length && (Character.isDigit(c) || c == '-' || c == '.' || c == 'E')) {
                        if ((c = csq.charAt(index++)) != '.') continue;
                        return 9;
                    }
                    return 8;
                }
                pos.setIndex(pos.getIndex() + 1);
            }
            return 0;
        }

        private void check(boolean expr, String message, CharSequence csq, int index) throws ParseException {
            if (!expr) {
                throw new ParseException(String.valueOf(message) + " (in " + csq + " at index " + index + ")", index);
            }
        }

        private Exponent readExponent(CharSequence csq, ParsePosition pos) {
            char c = csq.charAt(pos.getIndex());
            if (c == '^') {
                pos.setIndex(pos.getIndex() + 1);
            } else if (c == '*') {
                pos.setIndex(pos.getIndex() + 2);
            }
            int length = csq.length();
            int pow = 0;
            boolean isPowNegative = false;
            int root = 0;
            boolean isRootNegative = false;
            boolean isRoot = false;
            while (pos.getIndex() < length) {
                c = csq.charAt(pos.getIndex());
                if (c == '\u00b9') {
                    if (isRoot) {
                        root = root * 10 + 1;
                    } else {
                        pow = pow * 10 + 1;
                    }
                } else if (c == '\u00b2') {
                    if (isRoot) {
                        root = root * 10 + 2;
                    } else {
                        pow = pow * 10 + 2;
                    }
                } else if (c == '\u00b3') {
                    if (isRoot) {
                        root = root * 10 + 3;
                    } else {
                        pow = pow * 10 + 3;
                    }
                } else if (c == '-') {
                    if (isRoot) {
                        isRootNegative = true;
                    } else {
                        isPowNegative = true;
                    }
                } else if (c >= '0' && c <= '9') {
                    if (isRoot) {
                        root = root * 10 + (c - 48);
                    } else {
                        pow = pow * 10 + (c - 48);
                    }
                } else {
                    if (c != ':') break;
                    isRoot = true;
                }
                pos.setIndex(pos.getIndex() + 1);
            }
            if (pow == 0) {
                pow = 1;
            }
            if (root == 0) {
                root = 1;
            }
            return new Exponent(isPowNegative ? -pow : pow, isRootNegative ? -root : root);
        }

        private long readLong(CharSequence csq, ParsePosition pos) {
            int length = csq.length();
            int result = 0;
            boolean isNegative = false;
            while (pos.getIndex() < length) {
                char c = csq.charAt(pos.getIndex());
                if (c == '-') {
                    isNegative = true;
                } else {
                    if (c < '0' || c > '9') break;
                    result = result * 10 + (c - 48);
                }
                pos.setIndex(pos.getIndex() + 1);
            }
            return isNegative ? -result : result;
        }

        private double readDouble(CharSequence csq, ParsePosition pos) {
            int length = csq.length();
            int start = pos.getIndex();
            int end = start + 1;
            while (end < length) {
                if ("012356789+-.E".indexOf(csq.charAt(end)) < 0) break;
                ++end;
            }
            pos.setIndex(end + 1);
            return Double.parseDouble(csq.subSequence(start, end).toString());
        }

        private String readIdentifier(CharSequence csq, ParsePosition pos) {
            int start;
            int length = csq.length();
            int i = start = pos.getIndex();
            while (++i < length && DefaultFormat.isUnitIdentifierPart(csq.charAt(i))) {
            }
            pos.setIndex(i);
            return csq.subSequence(start, i).toString();
        }

        @Override
        public Appendable format(Unit<?> unit, Appendable appendable) throws IOException {
            int root;
            int pow;
            String name = this.nameFor(unit);
            if (name != null) {
                return appendable.append(name);
            }
            if (!(unit instanceof ProductUnit)) {
                throw new IllegalArgumentException("Cannot format given Object as a Unit");
            }
            ProductUnit productUnit = (ProductUnit)unit;
            int invNbr = 0;
            boolean start = true;
            int i = 0;
            while (i < productUnit.getUnitCount()) {
                pow = productUnit.getUnitPow(i);
                if (pow >= 0) {
                    if (!start) {
                        appendable.append('\u00b7');
                    }
                    name = this.nameFor(productUnit.getUnit(i));
                    root = productUnit.getUnitRoot(i);
                    this.append(appendable, name, pow, root);
                    start = false;
                } else {
                    ++invNbr;
                }
                ++i;
            }
            if (invNbr != 0) {
                if (start) {
                    appendable.append('1');
                }
                appendable.append('/');
                if (invNbr > 1) {
                    appendable.append('(');
                }
                start = true;
                i = 0;
                while (i < productUnit.getUnitCount()) {
                    pow = productUnit.getUnitPow(i);
                    if (pow < 0) {
                        name = this.nameFor(productUnit.getUnit(i));
                        root = productUnit.getUnitRoot(i);
                        if (!start) {
                            appendable.append('\u00b7');
                        }
                        this.append(appendable, name, -pow, root);
                        start = false;
                    }
                    ++i;
                }
                if (invNbr > 1) {
                    appendable.append(')');
                }
            }
            return appendable;
        }

        private void append(Appendable appendable, CharSequence symbol, int pow, int root) throws IOException {
            appendable.append(symbol);
            if (pow != 1 || root != 1) {
                if (pow == 2 && root == 1) {
                    appendable.append('\u00b2');
                } else if (pow == 3 && root == 1) {
                    appendable.append('\u00b3');
                } else {
                    appendable.append('^');
                    appendable.append(String.valueOf(pow));
                    if (root != 1) {
                        appendable.append(':');
                        appendable.append(String.valueOf(root));
                    }
                }
            }
        }
    }

    private static class Exponent {
        public final int pow;
        public final int root;

        public Exponent(int pow, int root) {
            this.pow = pow;
            this.root = root;
        }
    }
}

