/*
 * Decompiled with CFR 0.152.
 */
package org.ros.internal.node.topic;

import com.google.common.base.Preconditions;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ros.concurrent.CancellableLoop;
import org.ros.node.topic.Publisher;

public class RepeatingPublisher<MessageType> {
    private static final boolean DEBUG = false;
    private static final Log log = LogFactory.getLog(RepeatingPublisher.class);
    private final Publisher<MessageType> publisher;
    private final MessageType message;
    private final int frequency;
    private final RepeatingPublisherLoop runnable;
    private final ScheduledExecutorService executorService;

    public RepeatingPublisher(Publisher<MessageType> publisher, MessageType message, int frequency, ScheduledExecutorService executorService) {
        this.publisher = publisher;
        this.message = message;
        this.frequency = frequency;
        this.executorService = executorService;
        this.runnable = new RepeatingPublisherLoop();
    }

    public void start() {
        Preconditions.checkState((!this.runnable.isRunning() ? 1 : 0) != 0);
        this.executorService.execute(this.runnable);
    }

    public void cancel() {
        Preconditions.checkState((boolean)this.runnable.isRunning());
        this.runnable.cancel();
    }

    private final class RepeatingPublisherLoop
    extends CancellableLoop {
        private RepeatingPublisherLoop() {
        }

        @Override
        public void loop() throws InterruptedException {
            RepeatingPublisher.this.publisher.publish(RepeatingPublisher.this.message);
            Thread.sleep((long)(1000.0 / (double)RepeatingPublisher.this.frequency));
        }
    }
}

