/*
 * Decompiled with CFR 0.152.
 */
package org.ros.internal.node.topic;

import java.util.concurrent.ExecutorService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.MessageEvent;
import org.ros.internal.node.topic.SubscriberHandshake;
import org.ros.internal.transport.BaseClientHandshakeHandler;
import org.ros.internal.transport.ConnectionHeader;
import org.ros.internal.transport.queue.IncomingMessageQueue;
import org.ros.internal.transport.tcp.NamedChannelHandler;

class SubscriberHandshakeHandler<T>
extends BaseClientHandshakeHandler {
    private static final Log log = LogFactory.getLog(SubscriberHandshakeHandler.class);
    private final IncomingMessageQueue<T> incomingMessageQueue;

    public SubscriberHandshakeHandler(ConnectionHeader outgoingConnectionHeader, IncomingMessageQueue<T> incomingMessageQueue, ExecutorService executorService) {
        super(new SubscriberHandshake(outgoingConnectionHeader), executorService);
        this.incomingMessageQueue = incomingMessageQueue;
    }

    @Override
    protected void onSuccess(ConnectionHeader incomingConnectionHeader, ChannelHandlerContext ctx, MessageEvent e) {
        ChannelPipeline pipeline = e.getChannel().getPipeline();
        pipeline.remove((ChannelHandler)this);
        NamedChannelHandler namedChannelHandler = this.incomingMessageQueue.getMessageReceiver();
        pipeline.addLast(namedChannelHandler.getName(), (ChannelHandler)namedChannelHandler);
        String latching = incomingConnectionHeader.getField("latching");
        if (latching != null && latching.equals("1")) {
            this.incomingMessageQueue.setLatchMode(true);
        }
    }

    @Override
    protected void onFailure(String errorMessage, ChannelHandlerContext ctx, MessageEvent e) {
        log.error((Object)("Subscriber handshake failed: " + errorMessage));
        e.getChannel().close();
    }

    @Override
    public String getName() {
        return "SubscriberHandshakeHandler";
    }
}

